/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J-\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/punisher/commands/PunishesXCommands;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "mH", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "sendHelp", "page", "", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunisherXCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunisherXCommands.kt\npl/syntaxdevteam/punisher/commands/PunishesXCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1869#2,2:161\n*S KotlinDebug\n*F\n+ 1 PunisherXCommands.kt\npl/syntaxdevteam/punisher/commands/PunishesXCommands\n*L\n149#1:161,2\n*E\n"})
public final class PunishesXCommands
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final MessageHandler mH;

    public PunishesXCommands(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.mH = this.plugin.getMessageHandler();
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        String prefix = this.plugin.getMessageHandler().getPrefix();
        if (!(args.length == 0) && StringsKt.equals(args[0], "help", true)) {
            Object object = ArraysKt.getOrNull(args, 1);
            int page = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
            this.sendHelp(stack, page);
            return;
        }
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.PUNISHERX_COMMAND)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "error", "no_permission", null, 4, null));
            return;
        }
        if (args.length == 0) {
            stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <green>Type </green><gold>/prx help</gold> <green>to see available commands</green>"));
            return;
        }
        PunisherX punisherX = this.plugin;
        Intrinsics.checkNotNull((Object)punisherX, "null cannot be cast to non-null type io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner");
        PluginMeta pluginMeta = ((LifecycleEventOwner)punisherX).getPluginMeta();
        Intrinsics.checkNotNullExpressionValue(pluginMeta, "getPluginMeta(...)");
        PluginMeta pluginMeta2 = pluginMeta;
        PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
        Intrinsics.checkNotNullExpressionValue(pluginDescriptionFile, "getDescription(...)");
        PluginDescriptionFile pdf = pluginDescriptionFile;
        if (StringsKt.equals(args[0], "version", true)) {
            stack.getSender().sendMessage(this.mH.miniMessageFormat("\n<gray>-------------------------------------------------\n <gray>|\n <gray>|   <gold>\u2192 <bold>" + pluginMeta2.getName() + "</bold> \u2190\n <gray>|   <white>Author: <bold><gold>" + pdf.getAuthors() + "</gold></bold>\n <gray>|   <white>Website: <bold><gold><click:open_url:'" + pdf.getWebsite() + "'>" + pdf.getWebsite() + "</click></gold></bold>\n <gray>|   <white>Version: <bold><gold>" + pluginMeta2.getVersion() + "</gold></bold>\n <gray>|\n<gray>-------------------------------------------------"));
        } else if (StringsKt.equals(args[0], "reload", true)) {
            this.plugin.onReload();
            stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <green>The configuration file has been reloaded.</green>"));
        } else if (StringsKt.equals(args[0], "export", true)) {
            this.plugin.getDatabaseHandler().exportDatabase();
        } else if (StringsKt.equals(args[0], "import", true)) {
            this.plugin.getDatabaseHandler().importDatabase();
        } else {
            stack.getSender().sendMessage(this.mH.miniMessageFormat(prefix + " <green>Type </green><gold>/prx help</gold> <green>to see available commands</green>"));
        }
    }

    private final void sendHelp(CommandSourceStack stack, int page) {
        String[] stringArray = new String[]{"  <gold>/prx help <gray>- <white>Displays this prompt.", "  <gold>/prx version <gray>- <white>Shows plugin info.", "  <gold>/prx reload <gray>- <white>Reloads the configuration file.", "  <gold>/kick <player> <reason> <gray>- <white>Kicks a player from the server", "  <gold>/warn <player> (time) <reason> <gray>- <white>Warns a player.", "  <gold>/unwarn <player> <gray>- <white>Removes a player's warning.", "  <gold>/mute <player> (time) <reason> <gray>- <white>Mutes a player.", "  <gold>/unmute <player> <gray>- <white>Unmutes a player.", "  <gold>/ban <player> (time) <reason> [--force]", "         <gray>- <white>Bans a player, optionally ignoring bypass.", "  <gold>/banip <player/ip> (time) <reason> [--force] ", "         <gray>- <white>Bans a player's IP, optionally ignoring bypass.", "  <gold>/unban <player/ip> <gray>- <white>Unbans a player.", "  <gold>/check <player> <all/warn/mute/ban> ", "    <gray>- <white>Checks and displays the punishments of a given player", "  <gold>/clearall <player> <gray>- <white>Clears all active penalties.", "  <gold>/jail <player> (time) <reason> <gray>- <white>Sends a player to jail.", "  <gold>/unjail <player> <gray>- <white>Releases a player from jail.", "  <gold>/setjail <radius> <gray>- <white>Setting up the jail location.", "  <gold>/setspawn <gray>- <white>Sets the respawn location after serving a prison sentence.", "  <gold>/change-reason <penalty_id> <new_reason> <gray>", "                - <white>Changes the reason for the penalty.", "  <gold>/history <player> <page> <gray>- <white>Displays the player's punishment history.", "  <gold>/banlist <page> --h <gray>- <white>Displays the list of banned players.", " ", " ", " ", " "};
        List<String> commands = CollectionsKt.listOf(stringArray);
        int itemsPerPage = 12;
        int totalPages = (commands.size() + itemsPerPage - 1) / itemsPerPage;
        int currentPage = RangesKt.coerceIn(page, 1, totalPages);
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>+-------------------------------------------------"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|    <gold>Available commands for " + this.plugin.getPluginMeta().getName() + ":"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        int startIndex = (currentPage - 1) * itemsPerPage;
        int endIndex = RangesKt.coerceAtMost(currentPage * itemsPerPage, commands.size());
        for (int i = startIndex; i < endIndex; ++i) {
            stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|  " + commands.get(i)));
        }
        int prevPage = currentPage > 1 ? currentPage - 1 : totalPages;
        int nextPage = currentPage < totalPages ? currentPage + 1 : 1;
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>| (Page " + currentPage + "/" + totalPages + ") <click:run_command:'/prx help " + prevPage + "'><white>[Previous]</white></click>   <click:run_command:'/prx help " + nextPage + "'><white>[Next]</white></click>"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>|"));
        stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>+-------------------------------------------------"));
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 1) {
            List baseSuggestions = new ArrayList();
            if (StringsKt.startsWith("help", args[0], true)) {
                baseSuggestions.add("help");
            }
            CommandSender commandSender = stack.getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            if (PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.PUNISHERX_COMMAND)) {
                String[] stringArray = new String[]{"version", "reload", "export", "import"};
                Iterable $this$forEach$iv = CollectionsKt.listOf(stringArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String cmd = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith(cmd, args[0], true)) continue;
                    baseSuggestions.add(cmd);
                }
            }
            return baseSuggestions;
        }
        return CollectionsKt.emptyList();
    }
}

