/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lpl/syntaxdevteam/punisher/common/CommandLoggerPlugin;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "gson", "Lcom/google/gson/Gson;", "logFile", "Ljava/io/File;", "dateFormat", "Ljava/text/SimpleDateFormat;", "logCommand", "", "executor", "", "command", "target", "reason", "loadLogs", "", "Lpl/syntaxdevteam/punisher/common/CommandLoggerPlugin$CommandEntry;", "saveLogs", "logs", "CommandEntry", "PunisherX"})
public final class CommandLoggerPlugin {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final Gson gson;
    @NotNull
    private final File logFile;
    @NotNull
    private final SimpleDateFormat dateFormat;

    public CommandLoggerPlugin(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        this.gson = gson;
        this.logFile = new File(this.plugin.getDataFolder(), "commands.json");
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if (!this.logFile.exists()) {
            this.logFile.createNewFile();
            this.saveLogs(new ArrayList());
        }
    }

    public final void logCommand(@NotNull String executor, @NotNull String command, @NotNull String target, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(executor, "executor");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(reason, "reason");
        List<CommandEntry> logs = CollectionsKt.toMutableList((Collection)this.loadLogs());
        String string = this.dateFormat.format(new Date());
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        logs.add(new CommandEntry(executor, command, target, reason, string));
        this.saveLogs(logs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<CommandEntry> loadLogs() {
        List list;
        try {
            List list2;
            list = new FileReader(this.logFile);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)((Object)list);
                boolean bl = false;
                List list3 = (List)this.gson.fromJson((Reader)reader, new TypeToken<List<? extends CommandEntry>>(){}.getType());
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                list2 = list3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)list), throwable);
            }
            list = list2;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Nie mo\u017cna odczyta\u0107 commands.json: " + e.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveLogs(List<CommandEntry> logs) {
        try {
            Closeable closeable = new FileWriter(this.logFile);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                this.gson.toJson(logs, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("B\u0142\u0105d zapisu commands.json: " + e.getMessage());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lpl/syntaxdevteam/punisher/common/CommandLoggerPlugin$CommandEntry;", "", "executor", "", "command", "target", "reason", "time", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getExecutor", "()Ljava/lang/String;", "getCommand", "getTarget", "getReason", "getTime", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "PunisherX"})
    public static final class CommandEntry {
        @NotNull
        private final String executor;
        @NotNull
        private final String command;
        @NotNull
        private final String target;
        @NotNull
        private final String reason;
        @NotNull
        private final String time;

        public CommandEntry(@NotNull String executor, @NotNull String command, @NotNull String target, @NotNull String reason, @NotNull String time) {
            Intrinsics.checkNotNullParameter(executor, "executor");
            Intrinsics.checkNotNullParameter(command, "command");
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter(reason, "reason");
            Intrinsics.checkNotNullParameter(time, "time");
            this.executor = executor;
            this.command = command;
            this.target = target;
            this.reason = reason;
            this.time = time;
        }

        @NotNull
        public final String getExecutor() {
            return this.executor;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @NotNull
        public final String getTarget() {
            return this.target;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public final String getTime() {
            return this.time;
        }

        @NotNull
        public final String component1() {
            return this.executor;
        }

        @NotNull
        public final String component2() {
            return this.command;
        }

        @NotNull
        public final String component3() {
            return this.target;
        }

        @NotNull
        public final String component4() {
            return this.reason;
        }

        @NotNull
        public final String component5() {
            return this.time;
        }

        @NotNull
        public final CommandEntry copy(@NotNull String executor, @NotNull String command, @NotNull String target, @NotNull String reason, @NotNull String time) {
            Intrinsics.checkNotNullParameter(executor, "executor");
            Intrinsics.checkNotNullParameter(command, "command");
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter(reason, "reason");
            Intrinsics.checkNotNullParameter(time, "time");
            return new CommandEntry(executor, command, target, reason, time);
        }

        public static /* synthetic */ CommandEntry copy$default(CommandEntry commandEntry, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = commandEntry.executor;
            }
            if ((n & 2) != 0) {
                string2 = commandEntry.command;
            }
            if ((n & 4) != 0) {
                string3 = commandEntry.target;
            }
            if ((n & 8) != 0) {
                string4 = commandEntry.reason;
            }
            if ((n & 0x10) != 0) {
                string5 = commandEntry.time;
            }
            return commandEntry.copy(string, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "CommandEntry(executor=" + this.executor + ", command=" + this.command + ", target=" + this.target + ", reason=" + this.reason + ", time=" + this.time + ")";
        }

        public int hashCode() {
            int result = this.executor.hashCode();
            result = result * 31 + this.command.hashCode();
            result = result * 31 + this.target.hashCode();
            result = result * 31 + this.reason.hashCode();
            result = result * 31 + this.time.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandEntry)) {
                return false;
            }
            CommandEntry commandEntry = (CommandEntry)other;
            if (!Intrinsics.areEqual(this.executor, commandEntry.executor)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.command, commandEntry.command)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.target, commandEntry.target)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.reason, commandEntry.reason)) {
                return false;
            }
            return Intrinsics.areEqual(this.time, commandEntry.time);
        }
    }
}

