/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.ansi.ANSIComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0002J\u0006\u0010\u0010\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\u0007J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J,\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J,\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J,\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J2\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J2\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0013J\u000e\u0010&\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0013J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0002J\u000e\u0010)\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lpl/syntaxdevteam/punisher/common/MessageHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "language", "", "Lorg/jetbrains/annotations/Nullable;", "messages", "Lorg/bukkit/configuration/file/FileConfiguration;", "initial", "", "copyDefaultMessages", "updateLanguageFile", "loadMessages", "reloadMessages", "getPrefix", "getMessage", "Lnet/kyori/adventure/text/Component;", "category", "key", "placeholders", "", "getSimpleMessage", "getCleanMessage", "getLogMessage", "getComplexMessage", "", "getSmartMessage", "getReasons", "formatLegacyText", "message", "formatLegacyTextBukkit", "formatHexAndLegacyText", "miniMessageFormat", "getANSIText", "component", "getPlainText", "convertLegacyToMiniMessage", "convertHexToMiniMessage", "formatMixedTextToMiniMessage", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageHandler.kt\npl/syntaxdevteam/punisher/common/MessageHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n1803#2,3:256\n1803#2,3:259\n1803#2,3:262\n1803#2,3:265\n1563#2:268\n1634#2,2:269\n1803#2,3:271\n1636#2:274\n1803#2,3:275\n808#2,11:278\n1563#2:289\n1634#2,2:290\n1803#2,3:292\n1636#2:295\n*S KotlinDebug\n*F\n+ 1 MessageHandler.kt\npl/syntaxdevteam/punisher/common/MessageHandler\n*L\n106#1:256,3\n119#1:259,3\n130#1:262,3\n141#1:265,3\n153#1:268\n153#1:269,2\n154#1:271,3\n153#1:274\n167#1:275,3\n169#1:278,11\n169#1:289\n169#1:290,2\n171#1:292,3\n169#1:295\n*E\n"})
public final class MessageHandler {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final String language;
    @NotNull
    private FileConfiguration messages;

    public MessageHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        String string = this.plugin.getConfig().getString("language");
        if (string == null) {
            string = "EN";
        }
        this.language = string;
        this.copyDefaultMessages();
        this.updateLanguageFile();
        this.messages = this.loadMessages();
    }

    public final void initial() {
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String author = switch (string) {
            case "pl" -> "WieszczY";
            case "en" -> "Syntaxerr";
            case "nl" -> "LegacyHeaven";
            case "fr" -> "OpenAI ChatGPT-3.5";
            case "es" -> "OpenAI ChatGPT-3.5";
            case "de" -> "OpenAI ChatGPT-3.5";
            case "ru" -> "marat2509";
            default -> this.plugin.getServerName();
        };
        this.plugin.getLogger().log("<gray>Loaded \"" + this.language + "\" language file by: <white><b>" + author + "</b></white>");
    }

    private final void copyDefaultMessages() {
        File file = this.plugin.getDataFolder();
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        File messageFile = new File(file, "lang/messages_" + string + ".yml");
        if (!messageFile.exists()) {
            messageFile.getParentFile().mkdirs();
            String string2 = this.language.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            this.plugin.saveResource("lang/messages_" + string2 + ".yml", false);
        }
    }

    private final void updateLanguageFile() {
        File file = this.plugin.getDataFolder();
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        File langFile = new File(file, "lang/messages_" + string + ".yml");
        String string2 = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        InputStream defaultLangStream = this.plugin.getResource("lang/messages_" + string2 + ".yml");
        if (defaultLangStream == null) {
            this.plugin.getLogger().err("Default language file for " + this.language + " not found in plugin resources!");
            return;
        }
        InputStream inputStream = defaultLangStream;
        Charset charset = Charsets.UTF_8;
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream, charset));
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration defaultConfig = yamlConfiguration;
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)langFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration2, "loadConfiguration(...)");
        YamlConfiguration currentConfig = yamlConfiguration2;
        Ref.BooleanRef updated = new Ref.BooleanRef();
        MessageHandler.updateLanguageFile$synchronizeSections(updated, (ConfigurationSection)defaultConfig, (ConfigurationSection)currentConfig);
        if (updated.element) {
            Logger logger = this.plugin.getLogger();
            String string3 = this.language.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            logger.success("Updating language file: messages_" + string3 + ".yml with missing entries.");
            currentConfig.save(langFile);
        }
    }

    private final FileConfiguration loadMessages() {
        File file = this.plugin.getDataFolder();
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        File langFile = new File(file, "lang/messages_" + string + ".yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)langFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        return (FileConfiguration)yamlConfiguration;
    }

    public final void reloadMessages() {
        this.messages = this.loadMessages();
    }

    @NotNull
    public final String getPrefix() {
        Object object = this.messages.getString("prefix");
        if (object == null) {
            object = "[" + this.plugin.getPluginMeta().getName() + "]";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Component getMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String prefix = this.getPrefix();
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getMessage_u24lambda_u240 = this;
            boolean bl = false;
            $this$getMessage_u24lambda_u240.plugin.getLogger().err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable iterable = placeholders.entrySet();
        String initial$iv = message;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        String mixMessage = prefix + " " + formattedMessage;
        return this.formatMixedTextToMiniMessage(mixMessage);
    }

    public static /* synthetic */ Component getMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getSimpleMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String prefix = this.getPrefix();
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getSimpleMessage_u24lambda_u242 = this;
            boolean bl = false;
            $this$getSimpleMessage_u24lambda_u242.plugin.getLogger().err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable iterable = placeholders.entrySet();
        String initial$iv = message;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        return prefix + " " + formattedMessage;
    }

    public static /* synthetic */ String getSimpleMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getSimpleMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getCleanMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getCleanMessage_u24lambda_u244 = this;
            boolean bl = false;
            $this$getCleanMessage_u24lambda_u244.plugin.getLogger().err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable iterable = placeholders.entrySet();
        String initial$iv = message;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        return formattedMessage;
    }

    public static /* synthetic */ String getCleanMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getCleanMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Component getLogMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getLogMessage_u24lambda_u246 = this;
            boolean bl = false;
            $this$getLogMessage_u24lambda_u246.plugin.getLogger().err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable iterable = placeholders.entrySet();
        String initial$iv = message;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        return this.formatMixedTextToMiniMessage(formattedMessage);
    }

    public static /* synthetic */ Component getLogMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getLogMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> getComplexMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        List list = this.messages.getStringList(category + "." + key);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List messageList = list;
        if (messageList.isEmpty()) {
            this.plugin.getLogger().err("There was an error loading the message list " + key + " from category " + category);
            return CollectionsKt.listOf(Component.text((String)"Message list not found. Check console..."));
        }
        Iterable $this$map$iv = messageList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$fold$iv;
            void message;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = placeholders.entrySet();
            void initial$iv = message;
            boolean $i$f$fold = false;
            String accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void entry;
                Map.Entry entry2 = (Map.Entry)element$iv;
                void acc = accumulator$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(acc);
                accumulator$iv = StringsKt.replace$default((String)acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
            }
            void formattedMessage = accumulator$iv;
            Intrinsics.checkNotNull(formattedMessage);
            collection.add(this.formatMixedTextToMiniMessage((String)formattedMessage));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getComplexMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getComplexMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> getSmartMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        List list;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String path = category + "." + key;
        Object value = this.messages.get(path);
        String prefix = this.getPrefix();
        Object object = value;
        if (object instanceof String) {
            void $this$fold$iv;
            void initial$iv;
            Iterable iterable = placeholders.entrySet();
            Object object2 = value;
            String string = prefix;
            MessageHandler messageHandler = this;
            boolean $i$f$fold = false;
            String accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void entry;
                Map.Entry entry2 = (Map.Entry)element$iv;
                String acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
            }
            void var29_29 = accumulator$iv;
            list = CollectionsKt.listOf(messageHandler.formatMixedTextToMiniMessage(string + " " + var29_29));
        } else if (object instanceof List) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)value;
            boolean $i$f$filterIsInstance = false;
            Iterable $i$f$fold = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof String)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$fold$iv;
                void initial$iv;
                void line;
                String acc = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable = placeholders.entrySet();
                void var18_31 = line;
                MessageHandler messageHandler = this;
                boolean $i$f$fold2 = false;
                String accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void entry;
                    Map.Entry entry3 = (Map.Entry)element$iv;
                    void acc2 = accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = StringsKt.replace$default((String)acc2, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
                }
                collection.add(messageHandler.formatMixedTextToMiniMessage(accumulator$iv));
            }
            list = (List)destination$iv$iv;
        } else {
            this.plugin.getLogger().err("There was an error loading the message list " + key + " from category " + category);
            return CollectionsKt.listOf(Component.text((String)"Message list not found. Check console..."));
        }
        return list;
    }

    public static /* synthetic */ List getSmartMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getSmartMessage(string, string2, map);
    }

    @NotNull
    public final List<String> getReasons(@NotNull String category, @NotNull String key) {
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        List list = this.messages.getStringList(category + "." + key);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        return list;
    }

    @NotNull
    public final Component formatLegacyText(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        TextComponent textComponent = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        Intrinsics.checkNotNullExpressionValue(textComponent, "deserialize(...)");
        return (Component)textComponent;
    }

    @NotNull
    public final String formatLegacyTextBukkit(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Intrinsics.checkNotNullExpressionValue(string, "translateAlternateColorCodes(...)");
        return string;
    }

    @NotNull
    public final Component formatHexAndLegacyText(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        CharSequence charSequence = message;
        Regex regex = new Regex("&#([a-fA-F0-9]{6})");
        Function1<MatchResult, CharSequence> function1 = MessageHandler::formatHexAndLegacyText$lambda$13;
        String hexFormatted = regex.replace(charSequence, function1);
        TextComponent textComponent = LegacyComponentSerializer.legacySection().deserialize(hexFormatted);
        Intrinsics.checkNotNullExpressionValue(textComponent, "deserialize(...)");
        return (Component)textComponent;
    }

    @NotNull
    public final Component miniMessageFormat(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Component component = MiniMessage.miniMessage().deserialize((Object)message);
        Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
        return component;
    }

    @NotNull
    public final String getANSIText(@NotNull Component component) {
        Intrinsics.checkNotNullParameter(component, "component");
        Object object = ANSIComponentSerializer.ansi().serialize(component);
        Intrinsics.checkNotNullExpressionValue(object, "serialize(...)");
        return (String)object;
    }

    @NotNull
    public final String getPlainText(@NotNull Component component) {
        Intrinsics.checkNotNullParameter(component, "component");
        String string = PlainTextComponentSerializer.plainText().serialize(component);
        Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
        return string;
    }

    private final String convertLegacyToMiniMessage(String message) {
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(message, "&0", "<black>", false, 4, null), "&1", "<dark_blue>", false, 4, null), "&2", "<dark_green>", false, 4, null), "&3", "<dark_aqua>", false, 4, null), "&4", "<dark_red>", false, 4, null), "&5", "<dark_purple>", false, 4, null), "&6", "<gold>", false, 4, null), "&7", "<gray>", false, 4, null), "&8", "<dark_gray>", false, 4, null), "&9", "<blue>", false, 4, null), "&a", "<green>", false, 4, null), "&b", "<aqua>", false, 4, null), "&c", "<red>", false, 4, null), "&d", "<light_purple>", false, 4, null), "&e", "<yellow>", false, 4, null), "&f", "<white>", false, 4, null), "&k", "<obfuscated>", false, 4, null), "&l", "<bold>", false, 4, null), "&m", "<strikethrough>", false, 4, null), "&n", "<underlined>", false, 4, null), "&o", "<italic>", false, 4, null), "&r", "<reset>", false, 4, null);
    }

    private final String convertHexToMiniMessage(String message) {
        CharSequence charSequence = message;
        Regex regex = new Regex("&#([a-fA-F0-9]{6})");
        Function1<MatchResult, CharSequence> function1 = MessageHandler::convertHexToMiniMessage$lambda$14;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public final Component formatMixedTextToMiniMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        String formattedMessage = this.convertLegacyToMiniMessage(message);
        formattedMessage = this.convertHexToMiniMessage(formattedMessage);
        Component component = MiniMessage.miniMessage().deserialize((Object)formattedMessage);
        Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
        return component;
    }

    private static final void updateLanguageFile$synchronizeSections(Ref.BooleanRef updated, ConfigurationSection defaultSection, ConfigurationSection currentSection) {
        for (String key : defaultSection.getKeys(false)) {
            if (!currentSection.contains(key)) {
                currentSection.set(key, defaultSection.get(key));
                updated.element = true;
                continue;
            }
            if (!defaultSection.isConfigurationSection(key)) continue;
            ConfigurationSection configurationSection = defaultSection.getConfigurationSection(key);
            Intrinsics.checkNotNull(configurationSection);
            ConfigurationSection configurationSection2 = currentSection.getConfigurationSection(key);
            Intrinsics.checkNotNull(configurationSection2);
            MessageHandler.updateLanguageFile$synchronizeSections(updated, configurationSection, configurationSection2);
        }
    }

    private static final CharSequence formatHexAndLegacyText$lambda$13(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String hex = it.getGroupValues().get(1);
        return "\u00a7x\u00a7" + hex.charAt(0) + "\u00a7" + hex.charAt(1) + "\u00a7" + hex.charAt(2) + "\u00a7" + hex.charAt(3) + "\u00a7" + hex.charAt(4) + "\u00a7" + hex.charAt(5);
    }

    private static final CharSequence convertHexToMiniMessage$lambda$14(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String hex = it.getGroupValues().get(1);
        return "<#" + hex + ">";
    }
}

