/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\bJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lpl/syntaxdevteam/punisher/common/UUIDManager;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "activeUUIDs", "", "", "Ljava/util/UUID;", "gson", "Lcom/google/gson/Gson;", "getUUID", "playerName", "fetchUUIDFromAPI", "fetchUUIDFromPlayerDB", "parseUUIDFromResponse", "response", "generateOfflineUUID", "PunisherX"})
public final class UUIDManager {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final Map<String, UUID> activeUUIDs;
    @NotNull
    private final Gson gson;

    public UUIDManager(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.activeUUIDs = new HashMap();
        this.gson = new Gson();
    }

    @NotNull
    public final UUID getUUID(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        Player player = Bukkit.getPlayer((String)playerName);
        if (player != null) {
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            return uUID;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer offlinePlayer2 = offlinePlayer;
        if (offlinePlayer2.hasPlayedBefore()) {
            UUID uUID = offlinePlayer2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            return uUID;
        }
        UUID uUID = this.fetchUUIDFromAPI(playerName);
        if (uUID == null && (uUID = this.fetchUUIDFromPlayerDB(playerName)) == null) {
            uUID = this.generateOfflineUUID(playerName);
        }
        UUID uuid = uUID;
        return uuid;
    }

    private final UUID fetchUUIDFromAPI(String playerName) {
        UUID uUID;
        URI uri = new URI("https://api.mojang.com/users/profiles/minecraft/" + playerName);
        byte[] byArray = ("OfflinePlayer:" + playerName).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        UUID uUID2 = UUID.nameUUIDFromBytes(byArray);
        Intrinsics.checkNotNullExpressionValue(uUID2, "nameUUIDFromBytes(...)");
        UUID offlineUUID = uUID2;
        try {
            UUID uUID3;
            URLConnection uRLConnection = uri.toURL().openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.connect();
            this.plugin.getLogger().debug("API Response Code: " + connection.getResponseCode());
            if (connection.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                String response = TextStreamsKt.readText(reader);
                reader.close();
                UUID uuid = this.parseUUIDFromResponse(response);
                this.plugin.getLogger().debug("parseUUIDFromResponse(response): " + uuid);
                if (uuid != null) {
                    Map<String, UUID> map = this.activeUUIDs;
                    String string = playerName;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                    String string2 = string.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                    string = string2;
                    map.put(string, uuid);
                }
                uUID3 = uuid;
            } else {
                this.plugin.getLogger().err("Failed to fetch UUID from API. Response code: " + connection.getResponseCode());
                this.plugin.getLogger().debug("Returning offline UUID: " + offlineUUID);
                uUID3 = offlineUUID;
            }
            uUID = uUID3;
        }
        catch (Exception e) {
            this.plugin.getLogger().err("Error: " + e);
            this.plugin.getLogger().debug("Returning offline UUID: " + offlineUUID);
            uUID = offlineUUID;
        }
        return uUID;
    }

    private final UUID fetchUUIDFromPlayerDB(String playerName) {
        UUID uUID;
        URI uri = new URI("https://playerdb.co/api/player/minecraft/" + playerName);
        try {
            UUID uUID2;
            URLConnection uRLConnection = uri.toURL().openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.connect();
            this.plugin.getLogger().debug("API Response Code: " + connection.getResponseCode());
            if (connection.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                String response = TextStreamsKt.readText(reader);
                reader.close();
                JsonObject jsonObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
                String rawUUID = jsonObject.getAsJsonObject("data").getAsJsonObject("player").get("id").getAsString();
                this.plugin.getLogger().debug("Raw UUID from PlayerDB API: " + rawUUID);
                Intrinsics.checkNotNull(rawUUID);
                Object object = rawUUID;
                Object object2 = new Regex("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)");
                String string = "$1-$2-$3-$4-$5";
                UUID uuid = UUID.fromString(((Regex)object2).replaceFirst((CharSequence)object, string));
                if (uuid != null) {
                    object = this.activeUUIDs;
                    object2 = playerName;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                    String string2 = ((String)object2).toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                    object2 = string2;
                    object.put(object2, uuid);
                }
                uUID2 = uuid;
            } else {
                this.plugin.getLogger().err("Failed to fetch UUID from PlayerDB API. Response code: " + connection.getResponseCode());
                uUID2 = null;
            }
            uUID = uUID2;
        }
        catch (Exception e) {
            this.plugin.getLogger().err("Error: " + e);
            uUID = null;
        }
        return uUID;
    }

    private final UUID parseUUIDFromResponse(String response) {
        UUID uUID;
        try {
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            String rawUUID = jsonObject.get("id").getAsString();
            this.plugin.getLogger().debug("Raw UUID from API: " + rawUUID);
            Intrinsics.checkNotNull(rawUUID);
            CharSequence charSequence = rawUUID;
            Regex regex = new Regex("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)");
            String string = "$1-$2-$3-$4-$5";
            uUID = UUID.fromString(regex.replaceFirst(charSequence, string));
        }
        catch (Exception e) {
            this.plugin.getLogger().err("Error: " + e);
            uUID = null;
        }
        return uUID;
    }

    private final UUID generateOfflineUUID(String playerName) {
        String string = "OfflinePlayer:" + playerName;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        UUID offlineUUID = UUID.nameUUIDFromBytes(byArray);
        this.plugin.getLogger().debug("Generated offline UUID for " + playerName + ": " + offlineUUID);
        Intrinsics.checkNotNull(offlineUUID);
        return offlineUUID;
    }
}

