/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.common;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/syntaxdevteam/punisher/common/UpdateChecker;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "hangarApiUrl", "", "pluginUrl", "gson", "Lcom/google/gson/Gson;", "checkForUpdates", "", "checkForUpdatesForPlayer", "player", "Lorg/bukkit/entity/Player;", "isNewerVersion", "", "latestVersion", "currentVersion", "notifyUpdate", "version", "Lcom/google/gson/JsonObject;", "downloadUpdate", "notifyAdmins", "message", "Lnet/kyori/adventure/text/Component;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nUpdateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateChecker.kt\npl/syntaxdevteam/punisher/common/UpdateChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
public final class UpdateChecker {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final String hangarApiUrl;
    @NotNull
    private final String pluginUrl;
    @NotNull
    private final Gson gson;

    public UpdateChecker(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.hangarApiUrl = "https://hangar.papermc.io/api/v1/projects/" + this.plugin.getPluginMeta().getName() + "/versions";
        this.pluginUrl = "https://hangar.papermc.io/SyntaxDevTeam/" + this.plugin.getPluginMeta().getName();
        this.gson = new Gson();
    }

    public final void checkForUpdates() {
        if (!this.plugin.getConfig().getBoolean("checkForUpdates", true)) {
            this.plugin.getLogger().debug("Update check is disabled in the config.");
            return;
        }
        CompletableFuture.runAsync(() -> UpdateChecker.checkForUpdates$lambda$1(this)).orTimeout(10L, TimeUnit.SECONDS).exceptionally(arg_0 -> UpdateChecker.checkForUpdates$lambda$2(this, arg_0));
    }

    public final void checkForUpdatesForPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!this.plugin.getConfig().getBoolean("checkForUpdates", true)) {
            this.plugin.getLogger().debug("Update check is disabled in the config.");
            return;
        }
        CompletableFuture.runAsync(() -> UpdateChecker.checkForUpdatesForPlayer$lambda$4(this, player)).orTimeout(10L, TimeUnit.SECONDS).exceptionally(arg_0 -> UpdateChecker.checkForUpdatesForPlayer$lambda$5(this, player, arg_0));
    }

    private final boolean isNewerVersion(String latestVersion, String currentVersion) {
        String[] stringArray = new String[]{"-"};
        List latestParts = StringsKt.split$default((CharSequence)latestVersion, stringArray, false, 2, 2, null);
        String[] stringArray2 = new String[]{"-"};
        List currentParts = StringsKt.split$default((CharSequence)currentVersion, stringArray2, false, 2, 2, null);
        String[] stringArray3 = new String[]{"."};
        List latestBase = StringsKt.split$default((CharSequence)latestParts.get(0), stringArray3, false, 0, 6, null);
        String[] stringArray4 = new String[]{"."};
        List currentBase = StringsKt.split$default((CharSequence)currentParts.get(0), stringArray4, false, 0, 6, null);
        int n = ((Collection)latestBase).size();
        for (int i = 0; i < n; ++i) {
            int currentPart;
            Object object = (String)CollectionsKt.getOrNull(latestBase, i);
            int latestPart = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
            Object object2 = (String)CollectionsKt.getOrNull(currentBase, i);
            int n2 = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : (currentPart = 0);
            if (latestPart > currentPart) {
                return true;
            }
            if (latestPart >= currentPart) continue;
            return false;
        }
        if (latestParts.size() > 1 && currentParts.size() > 1) {
            return ((String)latestParts.get(1)).compareTo((String)currentParts.get(1)) > 0;
        }
        return latestParts.size() > currentParts.size();
    }

    private final void notifyUpdate(JsonObject version) {
        String versionName = version.get("name").getAsString();
        String channel = version.getAsJsonObject("channel").get("name").getAsString();
        String string = channel;
        String message = Intrinsics.areEqual(string, "Release") ? "<green>New release version <bold>" + versionName + "</bold> is available on <click:open_url:'" + this.pluginUrl + "'>Hangar</click>!" : (Intrinsics.areEqual(string, "Snapshot") ? "<yellow>New snapshot version <bold>" + versionName + "</bold> is available on <click:open_url:'" + this.pluginUrl + "'>Hangar</click>!" : "<blue>New version <bold>" + versionName + "</bold> is available on <click:open_url:'" + this.pluginUrl + "'>Hangar</click>!");
        Component component = MiniMessage.miniMessage().deserialize((Object)message);
        Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
        Component component2 = component;
        this.plugin.getLogger().success("New release version " + versionName + " is available on " + this.pluginUrl);
        this.notifyAdmins(component2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadUpdate(JsonObject version) {
        block16: {
            String versionName = version.get("name").getAsString();
            String downloadUrl = version.getAsJsonObject("downloads").getAsJsonObject("PAPER").get("downloadUrl").getAsString();
            String fileName = version.getAsJsonObject("downloads").getAsJsonObject("PAPER").getAsJsonObject("fileInfo").get("name").getAsString();
            File newFile = new File(this.plugin.getDataFolder().getParentFile(), fileName);
            File currentFile = this.plugin.getPluginFile();
            try {
                URI uri = new URI(downloadUrl);
                URL url = uri.toURL();
                URLConnection uRLConnection = url.openConnection();
                Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
                HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    Closeable closeable = url.openStream();
                    Throwable throwable = null;
                    try {
                        long l;
                        InputStream input = (InputStream)closeable;
                        boolean bl = false;
                        Closeable closeable2 = new FileOutputStream(newFile);
                        Throwable throwable2 = null;
                        try {
                            FileOutputStream output = (FileOutputStream)closeable2;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull(input);
                            l = ByteStreamsKt.copyTo$default(input, output, 0, 2, null);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable2, throwable2);
                        }
                        long l2 = l;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                    this.plugin.getLogger().success("Downloaded new version " + versionName + " to " + newFile.getAbsolutePath());
                    if (currentFile.exists() && !Intrinsics.areEqual(currentFile, newFile)) {
                        currentFile.delete();
                        this.plugin.getLogger().success("Deleted old version " + currentFile.getName() + ". Restart your server to enjoy the latest plugin version");
                    }
                    break block16;
                }
                this.plugin.getLogger().warning("Failed to download new version " + versionName + ": " + responseCode);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to download new version " + versionName + ": " + e.getMessage());
            }
        }
    }

    private final void notifyAdmins(Component message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(this.plugin.getPluginMeta().getName() + ".update.notify")) continue;
            player.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void checkForUpdates$lambda$1(UpdateChecker this$0) {
        try {
            JsonObject latestVersion;
            Object it;
            URI uri = new URI(this$0.hangarApiUrl);
            URL url = uri.toURL();
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                this$0.plugin.getLogger().warning("Failed to check for updates: " + responseCode);
                return;
            }
            Closeable closeable = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            Throwable throwable = null;
            try {
                it = (BufferedReader)closeable;
                boolean bl = false;
                it = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Object responseBody = it;
            JsonObject jsonObject = (JsonObject)this$0.gson.fromJson((String)responseBody, JsonObject.class);
            JsonArray versions = jsonObject.getAsJsonArray("result");
            Intrinsics.checkNotNull(versions);
            JsonElement jsonElement = (JsonElement)CollectionsKt.firstOrNull((Iterable)versions);
            Object object = latestVersion = jsonElement != null ? jsonElement.getAsJsonObject() : null;
            if (latestVersion != null) {
                String string = latestVersion.get("name").getAsString();
                Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
                String string2 = this$0.plugin.getPluginMeta().getVersion();
                Intrinsics.checkNotNullExpressionValue(string2, "getVersion(...)");
                if (this$0.isNewerVersion(string, string2)) {
                    this$0.notifyUpdate(latestVersion);
                    if (!this$0.plugin.getConfig().getBoolean("autoDownloadUpdates", false)) return;
                    this$0.downloadUpdate(latestVersion);
                    return;
                }
            }
            this$0.plugin.getLogger().success("Your version is up to date");
            return;
        }
        catch (Exception e) {
            this$0.plugin.getLogger().warning("An error occurred while checking for updates: " + e.getMessage());
        }
    }

    private static final Void checkForUpdates$lambda$2(UpdateChecker this$0, Throwable e) {
        this$0.plugin.getLogger().warning("Update check timed out or failed: " + e.getMessage());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void checkForUpdatesForPlayer$lambda$4(UpdateChecker this$0, Player $player) {
        block12: {
            try {
                URI uri = new URI(this$0.hangarApiUrl);
                URL url = uri.toURL();
                URLConnection uRLConnection = url.openConnection();
                Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
                HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    JsonObject latestVersion;
                    Object it;
                    Closeable closeable = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    Throwable throwable = null;
                    try {
                        it = (BufferedReader)closeable;
                        boolean bl = false;
                        it = TextStreamsKt.readText((Reader)it);
                    }
                    catch (Throwable bl) {
                        throwable = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                    Object responseBody = it;
                    JsonObject jsonObject = (JsonObject)this$0.gson.fromJson((String)responseBody, JsonObject.class);
                    JsonArray versions = jsonObject.getAsJsonArray("result");
                    Intrinsics.checkNotNull(versions);
                    JsonElement jsonElement = (JsonElement)CollectionsKt.firstOrNull((Iterable)versions);
                    Object object = latestVersion = jsonElement != null ? jsonElement.getAsJsonObject() : null;
                    if (latestVersion != null) {
                        String string = latestVersion.get("name").getAsString();
                        Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
                        String string2 = this$0.plugin.getPluginMeta().getVersion();
                        Intrinsics.checkNotNullExpressionValue(string2, "getVersion(...)");
                        if (this$0.isNewerVersion(string, string2)) {
                            String versionName = latestVersion.get("name").getAsString();
                            String channel = latestVersion.getAsJsonObject("channel").get("name").getAsString();
                            String prefix = this$0.plugin.getMessageHandler().getPrefix();
                            String string3 = channel;
                            String message = Intrinsics.areEqual(string3, "Release") ? prefix + " <green>New release version <bold>" + versionName + "</bold> is available on <u><click:open_url:'" + this$0.pluginUrl + "'>Hangar</click>!" : (Intrinsics.areEqual(string3, "Snapshot") ? prefix + " <yellow>New snapshot version <bold>" + versionName + "</bold> is available on <u><click:open_url:'" + this$0.pluginUrl + "'>Hangar</click>!" : prefix + " <blue>New version <bold>" + versionName + "</bold> is available on <u><click:open_url:'" + this$0.pluginUrl + "'>Hangar</click>!");
                            Component component = MiniMessage.miniMessage().deserialize((Object)message);
                            Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
                            Component component2 = component;
                            $player.sendMessage(component2);
                            if (this$0.plugin.getConfig().getBoolean("autoDownloadUpdates", false)) {
                                this$0.downloadUpdate(latestVersion);
                            }
                        }
                    }
                    break block12;
                }
                this$0.plugin.getLogger().warning("Failed to check for updates (for player): " + responseCode);
            }
            catch (Exception e) {
                this$0.plugin.getLogger().warning("B\u0142\u0105d podczas sprawdzania aktualizacji (dla gracza " + $player.getName() + "): " + e.getMessage());
            }
        }
    }

    private static final Void checkForUpdatesForPlayer$lambda$5(UpdateChecker this$0, Player $player, Throwable e) {
        this$0.plugin.getLogger().warning("Update check (dla gracza " + $player.getName() + ") timeout lub nieudane: " + e.getMessage());
        return null;
    }
}

