/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.hooks;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.Logger;
import pl.syntaxdevteam.punisher.common.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lpl/syntaxdevteam/punisher/hooks/DiscordWebhook;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "webhookUrl", "", "enabled", "", "formatter", "Ljava/time/format/DateTimeFormatter;", "log", "Lpl/syntaxdevteam/punisher/common/Logger;", "mh", "Lpl/syntaxdevteam/punisher/common/MessageHandler;", "sendPunishmentWebhook", "", "playerName", "adminName", "reason", "type", "duration", "", "createField", "Lcom/google/gson/JsonObject;", "name", "value", "inline", "getColorForPunishmentType", "", "formatDuration", "sendWebhook", "content", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nDiscordWebhook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscordWebhook.kt\npl/syntaxdevteam/punisher/hooks/DiscordWebhook\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class DiscordWebhook {
    @NotNull
    private final String webhookUrl;
    private final boolean enabled;
    @NotNull
    private final DateTimeFormatter formatter;
    @NotNull
    private final Logger log;
    @NotNull
    private final MessageHandler mh;

    public DiscordWebhook(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        String string = plugin.getConfig().getString("webhook.discord.url");
        if (string == null) {
            string = "";
        }
        this.webhookUrl = string;
        this.enabled = plugin.getConfig().getBoolean("webhook.discord.enabled", false);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(...)");
        this.formatter = dateTimeFormatter;
        this.log = plugin.getLogger();
        this.mh = plugin.getMessageHandler();
    }

    /*
     * WARNING - void declaration
     */
    public final void sendPunishmentWebhook(@NotNull String playerName, @NotNull String adminName, @NotNull String reason, @NotNull String type2, long duration) {
        void $this$sendPunishmentWebhook_u24lambda_u244_u24lambda_u243;
        JsonObject jsonObject;
        void $this$sendPunishmentWebhook_u24lambda_u242_u24lambda_u241;
        JsonObject jsonObject2;
        JsonArray jsonArray;
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        Intrinsics.checkNotNullParameter(adminName, "adminName");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Intrinsics.checkNotNullParameter(type2, "type");
        this.log.debug("Sending webhook...");
        this.log.debug("Webhook URL: " + this.webhookUrl);
        this.log.debug("Webhook enabled: " + this.enabled);
        if (!this.enabled || ((CharSequence)this.webhookUrl).length() == 0) {
            this.log.debug("Webhook is disabled or URL is empty");
            return;
        }
        JsonArray $this$sendPunishmentWebhook_u24lambda_u240 = jsonArray = new JsonArray();
        boolean bl = false;
        $this$sendPunishmentWebhook_u24lambda_u240.add((JsonElement)this.createField(MessageHandler.getCleanMessage$default(this.mh, "webhook", "player", null, 4, null), playerName, true));
        $this$sendPunishmentWebhook_u24lambda_u240.add((JsonElement)this.createField(MessageHandler.getCleanMessage$default(this.mh, "webhook", "operator", null, 4, null), adminName, true));
        String string = MessageHandler.getCleanMessage$default(this.mh, "webhook", "type", null, 4, null);
        String string2 = type2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        $this$sendPunishmentWebhook_u24lambda_u240.add((JsonElement)this.createField(string, string2, true));
        $this$sendPunishmentWebhook_u24lambda_u240.add((JsonElement)this.createField(MessageHandler.getCleanMessage$default(this.mh, "webhook", "reason", null, 4, null), reason, false));
        $this$sendPunishmentWebhook_u24lambda_u240.add((JsonElement)this.createField(MessageHandler.getCleanMessage$default(this.mh, "webhook", "time", null, 4, null), this.formatDuration(duration), true));
        JsonArray fields = jsonArray;
        JsonArray $this$sendPunishmentWebhook_u24lambda_u242 = $this$sendPunishmentWebhook_u24lambda_u240 = new JsonObject();
        boolean bl2 = false;
        $this$sendPunishmentWebhook_u24lambda_u242.addProperty("title", MessageHandler.getCleanMessage$default(this.mh, "webhook", "title", null, 4, null));
        $this$sendPunishmentWebhook_u24lambda_u242.addProperty("color", (Number)this.getColorForPunishmentType(type2));
        $this$sendPunishmentWebhook_u24lambda_u242.addProperty("timestamp", Instant.now().toString());
        $this$sendPunishmentWebhook_u24lambda_u242.add("fields", (JsonElement)fields);
        JsonObject jsonObject3 = jsonObject2 = new JsonObject();
        String string3 = "footer";
        Object object = $this$sendPunishmentWebhook_u24lambda_u242;
        boolean bl3 = false;
        $this$sendPunishmentWebhook_u24lambda_u242_u24lambda_u241.addProperty("text", MessageHandler.getCleanMessage$default(this.mh, "webhook", "app_name", null, 4, null) + LocalDateTime.now().format(this.formatter));
        Unit unit = Unit.INSTANCE;
        object.add(string3, (JsonElement)jsonObject2);
        JsonArray embed = $this$sendPunishmentWebhook_u24lambda_u240;
        JsonObject $this$sendPunishmentWebhook_u24lambda_u244 = jsonObject = new JsonObject();
        boolean bl4 = false;
        jsonObject3 = new JsonArray();
        string3 = jsonObject3;
        object = "embeds";
        JsonObject jsonObject4 = $this$sendPunishmentWebhook_u24lambda_u244;
        boolean bl5 = false;
        $this$sendPunishmentWebhook_u24lambda_u244_u24lambda_u243.add((JsonElement)embed);
        Unit unit2 = Unit.INSTANCE;
        jsonObject4.add((String)object, (JsonElement)jsonObject3);
        JsonObject json = jsonObject;
        this.log.debug("Sending JSON: " + json);
        String string4 = json.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
        this.sendWebhook(string4);
    }

    private final JsonObject createField(String name, String value, boolean inline) {
        JsonObject jsonObject;
        JsonObject $this$createField_u24lambda_u245 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$createField_u24lambda_u245.addProperty("name", name);
        $this$createField_u24lambda_u245.addProperty("value", value);
        $this$createField_u24lambda_u245.addProperty("inline", Boolean.valueOf(inline));
        return jsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int getColorForPunishmentType(String type2) {
        String string = type2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String string2 = string;
        switch (string2.hashCode()) {
            case 3641990: {
                if (string2.equals("warn")) return 16753920;
                return 0x808080;
            }
            case 3291718: {
                if (string2.equals("kick")) return 0xFFFF00;
                return 0x808080;
            }
            case 3363353: {
                if (string2.equals("mute")) return 15158332;
                return 0x808080;
            }
            case 97295: {
                if (!string2.equals("ban")) return 0x808080;
                return 9447935;
            }
        }
        return 0x808080;
    }

    private final String formatDuration(long duration) {
        String string;
        if (duration == -1L) {
            string = "PERMANENT";
        } else {
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(duration), ZoneId.systemDefault());
            String string2 = dateTime.format(this.formatter);
            Intrinsics.checkNotNull(string2);
            string = string2;
        }
        return string;
    }

    private final void sendWebhook(String content) {
        CompletableFuture.runAsync(() -> DiscordWebhook.sendWebhook$lambda$8(this, content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendWebhook$lambda$8(DiscordWebhook this$0, String $content) {
        try {
            this$0.log.debug("Attempting to send webhook asynchronously...");
            URI uri = new URI(this$0.webhookUrl);
            URLConnection uRLConnection = uri.toURL().openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            Closeable closeable = new OutputStreamWriter(connection.getOutputStream());
            Throwable throwable = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)closeable;
                boolean bl = false;
                writer.write($content);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            int responseCode = connection.getResponseCode();
            this$0.log.debug("Response code: " + responseCode);
            if (responseCode != 204) {
                Object object;
                this$0.log.debug("Error sending webhook. Response code: " + responseCode);
                InputStream inputStream = connection.getErrorStream();
                if (inputStream != null) {
                    Closeable closeable2 = inputStream;
                    Object object2 = Charsets.UTF_8;
                    Object object3 = new InputStreamReader((InputStream)closeable2, (Charset)object2);
                    int n = 8192;
                    closeable2 = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                    object2 = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable2;
                        boolean bl = false;
                        object3 = TextStreamsKt.readText(it);
                        object = object3;
                    }
                    catch (Throwable throwable3) {
                        object2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable2, (Throwable)object2);
                    }
                } else {
                    object = null;
                }
                Object errorStream = object;
                this$0.log.debug("Error content: " + errorStream);
            }
            connection.disconnect();
        }
        catch (Exception e) {
            this$0.log.debug("Error occurred while sending webhook: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

