/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.hooks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.user.User;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0014J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lpl/syntaxdevteam/punisher/hooks/HookHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "luckPerms", "Lnet/luckperms/api/LuckPerms;", "chat", "Lnet/milkbowl/vault/chat/Chat;", "permission", "Lnet/milkbowl/vault/permission/Permission;", "checkLuckPerms", "", "checkVault", "checkVaultUnlocked", "checkPlaceholderAPI", "", "checkMiniPlaceholderAPI", "getPrimaryGroup", "", "player", "Lorg/bukkit/entity/Player;", "getPlayerPrefix", "getPlayerSuffix", "getLuckPermsMetaValue", "key", "getAllLuckPermsMetData", "Lnet/luckperms/api/cacheddata/CachedMetaData;", "PunisherX"})
public final class HookHandler {
    @NotNull
    private final PunisherX plugin;
    @Nullable
    private LuckPerms luckPerms;
    @Nullable
    private Chat chat;
    @Nullable
    private Permission permission;

    public HookHandler(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.checkPlaceholderAPI();
        this.checkLuckPerms();
        this.checkVault();
        if (this.chat == null || this.permission == null) {
            this.checkVaultUnlocked();
        }
    }

    public final void checkLuckPerms() {
        if (Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
            if (provider != null) {
                this.luckPerms = (LuckPerms)provider.getProvider();
                this.plugin.getLogger().debug("Hooked into LuckPerms!");
            }
        } else {
            this.plugin.getLogger().warning("LuckPerms plugin not found on server!");
        }
    }

    private final void checkVault() {
        if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            RegisteredServiceProvider chatProvider = Bukkit.getServicesManager().getRegistration(Chat.class);
            RegisteredServiceProvider permProvider = Bukkit.getServicesManager().getRegistration(Permission.class);
            if (chatProvider != null && permProvider != null) {
                this.chat = (Chat)chatProvider.getProvider();
                this.permission = (Permission)permProvider.getProvider();
                this.plugin.getLogger().debug("Hooked into Vault!");
            }
        } else {
            this.plugin.getLogger().warning("Vault plugin not found on server!");
        }
    }

    private final void checkVaultUnlocked() {
        if (Bukkit.getPluginManager().isPluginEnabled("VaultUnlocked")) {
            RegisteredServiceProvider chatProvider = Bukkit.getServicesManager().getRegistration(Chat.class);
            RegisteredServiceProvider permProvider = Bukkit.getServicesManager().getRegistration(Permission.class);
            if (chatProvider != null && permProvider != null) {
                this.chat = (Chat)chatProvider.getProvider();
                this.permission = (Permission)permProvider.getProvider();
                this.plugin.getLogger().debug("Hooked into VaultUnlocked!");
            }
        } else {
            this.plugin.getLogger().warning("VaultUnlocked plugin not found on server!");
        }
    }

    public final boolean checkPlaceholderAPI() {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.plugin.getLogger().debug("Hooked into PlaceholderAPI!");
            return true;
        }
        this.plugin.getLogger().warning("PlaceholderAPI plugin not found on server!");
        return false;
    }

    public final boolean checkMiniPlaceholderAPI() {
        if (Bukkit.getPluginManager().isPluginEnabled("MiniPlaceholders")) {
            this.plugin.getLogger().debug("Hooked into MiniPlaceholders!");
            return true;
        }
        this.plugin.getLogger().warning("MiniPlaceholders plugin not found on server!");
        return false;
    }

    @NotNull
    public final String getPrimaryGroup(@NotNull Player player) {
        String lpGroup;
        Intrinsics.checkNotNullParameter(player, "player");
        LuckPerms luckPerms = this.luckPerms;
        String string = luckPerms != null && (luckPerms = luckPerms.getPlayerAdapter(Player.class)) != null && (luckPerms = luckPerms.getMetaData((Object)player)) != null ? luckPerms.getPrimaryGroup() : (lpGroup = null);
        if (lpGroup != null) {
            this.plugin.getLogger().debug("LuckPerms primary group for " + player.getName() + ": " + lpGroup);
            return lpGroup;
        }
        Permission permission = this.permission;
        String groups2 = permission != null ? permission.getPrimaryGroup(player) : null;
        CharSequence charSequence = groups2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.plugin.getLogger().debug("Vault groups for " + player.getName() + ": " + groups2);
            return groups2;
        }
        return "default";
    }

    @NotNull
    public final String getPlayerPrefix(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = this.luckPerms;
        if (object == null || (object = object.getPlayerAdapter(Player.class)) == null || (object = object.getMetaData((Object)player)) == null || (object = object.getPrefix()) == null) {
            Chat chat = this.chat;
            object = chat != null ? chat.getPlayerPrefix(player) : null;
            if (object == null) {
                object = "";
            }
        }
        return object;
    }

    @NotNull
    public final String getPlayerSuffix(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = this.luckPerms;
        if (object == null || (object = object.getPlayerAdapter(Player.class)) == null || (object = object.getMetaData((Object)player)) == null || (object = object.getSuffix()) == null) {
            Chat chat = this.chat;
            object = chat != null ? chat.getPlayerSuffix(player) : null;
            if (object == null) {
                object = "";
            }
        }
        return object;
    }

    @Nullable
    public final String getLuckPermsMetaValue(@NotNull Player player, @NotNull String key) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(key, "key");
        LuckPerms luckPerms = this.luckPerms;
        User user = luckPerms != null && (luckPerms = luckPerms.getUserManager()) != null ? luckPerms.getUser(player.getUniqueId()) : null;
        User user2 = user;
        return user2 != null && (user2 = user2.getCachedData()) != null && (user2 = user2.getMetaData()) != null ? user2.getMetaValue(key) : null;
    }

    @Nullable
    public final CachedMetaData getAllLuckPermsMetData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        LuckPerms luckPerms = this.luckPerms;
        return luckPerms != null && (luckPerms = luckPerms.getPlayerAdapter(Player.class)) != null ? luckPerms.getMetaData((Object)player) : null;
    }
}

