/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.JailUtils;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.common.UpdateChecker;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0016H\u0007J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001eH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lpl/syntaxdevteam/punisher/basic/PunishmentChecker;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "updateChecker", "Lpl/syntaxdevteam/punisher/common/UpdateChecker;", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "scheduleTeleport", "player", "Lorg/bukkit/entity/Player;", "targetLoc", "Lorg/bukkit/Location;", "mode", "Lorg/bukkit/GameMode;", "onPlayerChat", "Lio/papermc/paper/event/player/AsyncChatEvent;", "onPlayerCommand", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "isPlayerInJail", "", "playerLocation", "jailCenter", "radius", "", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunishmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunishmentChecker.kt\npl/syntaxdevteam/punisher/basic/PunishmentChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1761#2,3:252\n1869#2,2:255\n*S KotlinDebug\n*F\n+ 1 PunishmentChecker.kt\npl/syntaxdevteam/punisher/basic/PunishmentChecker\n*L\n35#1:252,3\n169#1:255,2\n*E\n"})
public final class PunishmentChecker
implements Listener {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final UpdateChecker updateChecker;

    public PunishmentChecker(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.updateChecker = new UpdateChecker(this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        boolean isJailed;
        Location unjailLoc;
        Location jailLoc;
        double radius;
        String name;
        Player player;
        block11: {
            Intrinsics.checkNotNullParameter(event, "event");
            Player player2 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
            player = player2;
            String string = player.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            name = string;
            String string2 = this.plugin.getUuidManager().getUUID(name).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String uuid = string2;
            radius = this.plugin.getConfig().getDouble("jail.radius", 10.0);
            FileConfiguration fileConfiguration = this.plugin.getConfig();
            Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
            jailLoc = JailUtils.INSTANCE.getJailLocation(fileConfiguration);
            FileConfiguration fileConfiguration2 = this.plugin.getConfig();
            Intrinsics.checkNotNullExpressionValue(fileConfiguration2, "getConfig(...)");
            unjailLoc = JailUtils.INSTANCE.getUnjailLocation(fileConfiguration2);
            List punishments = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
            Iterable $this$any$iv = punishments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v5 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PunishmentData it = (PunishmentData)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it.getType(), "JAIL") && this.plugin.getPunishmentManager().isPunishmentActive(it))) continue;
                    v5 = true;
                    break block11;
                }
                v5 = isJailed = false;
            }
        }
        if (jailLoc == null || unjailLoc == null) {
            this.plugin.getLogger().warning("Jail lub unjail location niezdefiniowane!");
        } else {
            Pair<Location, GameMode> pair;
            if (isJailed) {
                pair = TuplesKt.to(jailLoc, GameMode.ADVENTURE);
            } else {
                Location location = player.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                if (this.isPlayerInJail(location, jailLoc, radius)) {
                    pair = TuplesKt.to(unjailLoc, GameMode.SURVIVAL);
                } else {
                    return;
                }
            }
            Pair<Location, GameMode> pair2 = pair;
            Location targetLoc = pair2.component1();
            GameMode targetMode = pair2.component2();
            this.scheduleTeleport(player, targetLoc, targetMode);
            this.plugin.getLogger().debug("Scheduling teleport of " + name + " to " + targetLoc + " with gamemode " + targetMode + " (jailed=" + isJailed + ")");
        }
        if (PermissionChecker.INSTANCE.hasWithLegacy((CommandSender)player, PermissionChecker.PermissionKey.SEE_UPDATE)) {
            this.updateChecker.checkForUpdatesForPlayer(player);
            this.plugin.getLogger().debug("Checking for updates for player: " + name);
        } else {
            this.plugin.getLogger().debug("Player " + name + " does not have permission to see updates.");
        }
    }

    private final void scheduleTeleport(Player player, Location targetLoc, GameMode mode) {
        World world = targetLoc.getWorld();
        if (world == null) {
            PunishmentChecker $this$scheduleTeleport_u24lambda_u241 = this;
            boolean bl = false;
            $this$scheduleTeleport_u24lambda_u241.plugin.getLogger().warning("Brak \u015bwiata dla " + targetLoc);
            return;
        }
        World world2 = world;
        String string = this.plugin.getServer().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        if (StringsKt.contains$default((CharSequence)string, "Folia", false, 2, null)) {
            Bukkit.getServer().getRegionScheduler().execute((Plugin)this.plugin, targetLoc, () -> PunishmentChecker.scheduleTeleport$lambda$8(world2, targetLoc, this, player, mode));
        } else {
            Chunk chunk = world2.getChunkAt(targetLoc.getBlockX() >> 4, targetLoc.getBlockZ() >> 4);
            Intrinsics.checkNotNullExpressionValue(chunk, "getChunkAt(...)");
            Chunk chunk2 = chunk;
            if (!chunk2.isLoaded()) {
                try {
                    chunk2.load(true);
                }
                catch (Exception e) {
                    this.plugin.getLogger().debug("<red>Error loading chunk for " + player.getName() + ": " + e.getMessage() + "</red>");
                }
            }
            try {
                player.teleport(targetLoc);
                player.setGameMode(mode);
                this.plugin.getLogger().debug("<green>Player " + player.getName() + " teleported to " + targetLoc + " and set to " + mode + ".</green>");
            }
            catch (Exception e) {
                this.plugin.getLogger().debug("<red>Error while teleporting " + player.getName() + ": " + e.getMessage() + "</red>");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerChat(@NotNull AsyncChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String playerName = string;
        try {
            String string2 = this.plugin.getUuidManager().getUUID(playerName).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String uuid = string2;
            Component component = event.message();
            Intrinsics.checkNotNullExpressionValue(component, "message(...)");
            Component messageComponent = component;
            String string3 = PlainTextComponentSerializer.plainText().serialize(messageComponent);
            Intrinsics.checkNotNullExpressionValue(string3, "serialize(...)");
            String plainMessage = string3;
            List punishments = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
            if (punishments.isEmpty()) {
                this.plugin.getLogger().debug("No punishments found for player: " + playerName);
                return;
            }
            for (PunishmentData punishment : punishments) {
                if ((Intrinsics.areEqual(punishment.getType(), "MUTE") || Intrinsics.areEqual(punishment.getType(), "JAIL")) && this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                    event.setCancelled(true);
                    long endTime = punishment.getEnd();
                    String remainingTime = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf((endTime - System.currentTimeMillis()) / (long)1000));
                    String reason = punishment.getReason();
                    String messageKey = Intrinsics.areEqual(punishment.getType(), "JAIL") ? "jail" : "mute";
                    Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", remainingTime)};
                    Component infoMessage = this.plugin.getMessageHandler().getMessage(messageKey, "mute_info_message", MapsKt.mapOf(pairArray));
                    Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", playerName), TuplesKt.to("message", plainMessage)};
                    Component logMessage = this.plugin.getMessageHandler().getLogMessage(messageKey, "log", MapsKt.mapOf(pairArray2));
                    this.plugin.getLogger().clearLog(logMessage);
                    player2.sendMessage(infoMessage);
                    return;
                }
                this.plugin.getDatabaseHandler().removePunishment(uuid, "MUTE", true);
                this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerChat, report it urgently to the plugin author: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerCommand(@NotNull PlayerCommandPreprocessEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        try {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            Player player2 = player;
            UUIDManager uUIDManager = this.plugin.getUuidManager();
            String string = player2.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String string2 = uUIDManager.getUUID(string).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String uuid = string2;
            String string3 = event.getMessage();
            Intrinsics.checkNotNullExpressionValue(string3, "getMessage(...)");
            Object object = new String[]{" "};
            object = (String)StringsKt.split$default((CharSequence)string3, (String[])object, false, 0, 6, null).get(0);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string4 = ((String)object).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            String command = StringsKt.removePrefix(string4, (CharSequence)"/");
            if (this.plugin.getConfig().getBoolean("mute_pm")) {
                List list = this.plugin.getConfig().getStringList("mute_cmd");
                Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
                List muteCommands = list;
                if (muteCommands.contains(command)) {
                    List punishments = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
                    Iterable $this$forEach$iv = punishments;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PunishmentData punishment = (PunishmentData)element$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual(punishment.getType(), "MUTE") && this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                            long endTime = punishment.getEnd();
                            long remainingTime = (endTime - System.currentTimeMillis()) / (long)1000;
                            String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingTime));
                            String reason = punishment.getReason();
                            event.setCancelled(true);
                            Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                            Component muteMessage = this.plugin.getMessageHandler().getMessage("mute", "mute_message", MapsKt.mapOf(pairArray));
                            player2.sendMessage(muteMessage);
                            continue;
                        }
                        this.plugin.getDatabaseHandler().removePunishment(uuid, "MUTE", true);
                        this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerCommand, report it urgently to the plugin author with the message: " + event.getPlayer().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private final boolean isPlayerInJail(Location playerLocation, Location jailCenter, double radius) {
        return Intrinsics.areEqual(playerLocation.getWorld(), jailCenter.getWorld()) && playerLocation.distance(jailCenter) <= radius;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUIDManager uUIDManager = this.plugin.getUuidManager();
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        UUID uuid = uUIDManager.getUUID(string);
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        Location location = JailUtils.INSTANCE.getJailLocation(fileConfiguration);
        if (location == null) {
            return;
        }
        Location jailLocation = location;
        Long l = this.plugin.getCache().getPunishmentEnd(uuid);
        if (l == null) {
            return;
        }
        long punishmentEnd = l;
        if (!this.plugin.getCache().isPlayerInCache(uuid)) {
            return;
        }
        if (punishmentEnd != -1L && punishmentEnd < System.currentTimeMillis()) {
            this.plugin.getCache().removePunishment(uuid);
            player2.setGameMode(GameMode.SURVIVAL);
            return;
        }
        double radius = this.plugin.getConfig().getDouble("jail.radius", 10.0);
        String string2 = this.plugin.getServer().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        if (StringsKt.contains$default((CharSequence)string2, "Folia", false, 2, null)) {
            Bukkit.getServer().getRegionScheduler().execute((Plugin)this.plugin, jailLocation, () -> PunishmentChecker.onPlayerMove$lambda$14(this, player2, jailLocation, radius));
        } else {
            Location location2 = player2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            if (!this.isPlayerInJail(location2, jailLocation, radius)) {
                player2.teleport(jailLocation);
                Component message = this.plugin.getMessageHandler().getMessage("jail", "jail_restrict_message", MapsKt.emptyMap());
                player2.sendMessage(message);
            }
        }
    }

    private static final Unit scheduleTeleport$lambda$8$lambda$6$lambda$5$lambda$2(Player $player, GameMode $mode, PunishmentChecker this$0, Location $targetLoc, Boolean success) {
        if (success.booleanValue()) {
            $player.setGameMode($mode);
            this$0.plugin.getLogger().debug("Player " + $player.getName() + " teleported to " + $targetLoc + " and set to " + $mode);
        } else {
            this$0.plugin.getLogger().debug("<red>Failed to teleport " + $player.getName() + " to " + $targetLoc + ".</red>");
        }
        return Unit.INSTANCE;
    }

    private static final void scheduleTeleport$lambda$8$lambda$6$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void scheduleTeleport$lambda$8$lambda$6$lambda$5$lambda$4(PunishmentChecker this$0, Throwable thr) {
        this$0.plugin.getLogger().debug("<red>Teleportation error: " + thr.getMessage() + "</red>");
        return null;
    }

    private static final void scheduleTeleport$lambda$8$lambda$6$lambda$5(Player $player, Location $targetLoc, GameMode $mode, PunishmentChecker this$0) {
        ((CompletableFuture)$player.teleportAsync($targetLoc).thenAccept(arg_0 -> PunishmentChecker.scheduleTeleport$lambda$8$lambda$6$lambda$5$lambda$3(arg_0 -> PunishmentChecker.scheduleTeleport$lambda$8$lambda$6$lambda$5$lambda$2($player, $mode, this$0, $targetLoc, arg_0), arg_0))).exceptionally(arg_0 -> PunishmentChecker.scheduleTeleport$lambda$8$lambda$6$lambda$5$lambda$4(this$0, arg_0));
    }

    private static final void scheduleTeleport$lambda$8$lambda$6(PunishmentChecker this$0, Player $player, Location $targetLoc, GameMode $mode) {
        Bukkit.getServer().getGlobalRegionScheduler().execute((Plugin)this$0.plugin, () -> PunishmentChecker.scheduleTeleport$lambda$8$lambda$6$lambda$5($player, $targetLoc, $mode, this$0));
    }

    private static final Void scheduleTeleport$lambda$8$lambda$7(PunishmentChecker this$0, Throwable thr) {
        this$0.plugin.getLogger().debug("<red>Chunk load error: " + thr.getMessage() + "</red>");
        return null;
    }

    private static final void scheduleTeleport$lambda$8(World $world, Location $targetLoc, PunishmentChecker this$0, Player $player, GameMode $mode) {
        ((CompletableFuture)$world.getChunkAtAsync($targetLoc.getBlockX() >> 4, $targetLoc.getBlockZ() >> 4).thenRun(() -> PunishmentChecker.scheduleTeleport$lambda$8$lambda$6(this$0, $player, $targetLoc, $mode))).exceptionally(arg_0 -> PunishmentChecker.scheduleTeleport$lambda$8$lambda$7(this$0, arg_0));
    }

    private static final Unit onPlayerMove$lambda$14$lambda$13$lambda$10(PunishmentChecker this$0, Player $player, Boolean success) {
        if (success.booleanValue()) {
            Component message = this$0.plugin.getMessageHandler().getMessage("jail", "jail_restrict_message", MapsKt.emptyMap());
            $player.sendMessage(message);
        } else {
            this$0.plugin.getLogger().debug("<red>Failed to teleport player back to jail in Folia.</red>");
        }
        return Unit.INSTANCE;
    }

    private static final void onPlayerMove$lambda$14$lambda$13$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void onPlayerMove$lambda$14$lambda$13$lambda$12(PunishmentChecker this$0, Throwable throwable) {
        this$0.plugin.getLogger().debug("<red>Error while teleporting back to jail: " + throwable.getMessage() + "</red>");
        return null;
    }

    private static final void onPlayerMove$lambda$14$lambda$13(Player $player, Location $jailLocation, PunishmentChecker this$0) {
        ((CompletableFuture)$player.teleportAsync($jailLocation).thenAccept(arg_0 -> PunishmentChecker.onPlayerMove$lambda$14$lambda$13$lambda$11(arg_0 -> PunishmentChecker.onPlayerMove$lambda$14$lambda$13$lambda$10(this$0, $player, arg_0), arg_0))).exceptionally(arg_0 -> PunishmentChecker.onPlayerMove$lambda$14$lambda$13$lambda$12(this$0, arg_0));
    }

    private static final void onPlayerMove$lambda$14(PunishmentChecker this$0, Player $player, Location $jailLocation, double $radius) {
        try {
            Location location = $player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            boolean isInJail = this$0.isPlayerInJail(location, $jailLocation, $radius);
            if (!isInJail) {
                Bukkit.getServer().getGlobalRegionScheduler().execute((Plugin)this$0.plugin, () -> PunishmentChecker.onPlayerMove$lambda$14$lambda$13($player, $jailLocation, this$0));
            }
        }
        catch (Exception e) {
            this$0.plugin.getLogger().debug("<red>Error while checking player in jail: " + e.getMessage() + "</red>");
        }
    }
}

