/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.JailUtils;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/syntaxdevteam/punisher/commands/UnjailCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nUnjailCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnjailCommand.kt\npl/syntaxdevteam/punisher/commands/UnjailCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1869#2,2:88\n1563#2:90\n1634#2,3:91\n*S KotlinDebug\n*F\n+ 1 UnjailCommand.kt\npl/syntaxdevteam/punisher/commands/UnjailCommand\n*L\n66#1:88,2\n82#1:90\n82#1:91,3\n*E\n"})
public final class UnjailCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public UnjailCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.UNJAIL)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "error", "no_permission", null, 4, null));
            return;
        }
        if (args.length == 0) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "unjail", "usage", null, 4, null));
            return;
        }
        String playerName = args[0];
        UUID uuid = this.plugin.getUuidManager().getUUID(playerName);
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            FileConfiguration fileConfiguration = this.plugin.getConfig();
            Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
            Location location = JailUtils.INSTANCE.getUnjailLocation(fileConfiguration);
            if (location == null) {
                return;
            }
            Location spawnLocation = location;
            String string = this.plugin.getServer().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (StringsKt.contains$default((CharSequence)string, "Folia", false, 2, null)) {
                Bukkit.getServer().getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> UnjailCommand.execute$lambda$3(player, spawnLocation, this, playerName));
            } else {
                player.teleport(spawnLocation);
                player.setGameMode(GameMode.SURVIVAL);
                player.sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "unjail", "unjail_message", null, 4, null));
            }
        }
        this.plugin.getCache().removePunishment(uuid);
        DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        DatabaseHandler.removePunishment$default(databaseHandler, string, "JAIL", false, 4, null);
        Component broadcastMessage = this.plugin.getMessageHandler().getMessage("unjail", "broadcast", MapsKt.mapOf(TuplesKt.to("player", playerName)));
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player onlinePlayer = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(onlinePlayer);
            if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)onlinePlayer, PermissionChecker.PermissionKey.SEE_UNJAIL)) continue;
            onlinePlayer.sendMessage(broadcastMessage);
        }
        stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("unjail", "success", MapsKt.mapOf(TuplesKt.to("player", playerName))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.UNJAIL)) {
            return CollectionsKt.emptyList();
        }
        if (args.length == 1) {
            void $this$mapTo$iv$iv;
            Collection collection = this.plugin.getServer().getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Player player = (Player)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Unit execute$lambda$3$lambda$0(Player $player, UnjailCommand this$0, String $playerName, Boolean success) {
        if (success.booleanValue()) {
            $player.setGameMode(GameMode.SURVIVAL);
            $player.sendMessage(MessageHandler.getMessage$default(this$0.plugin.getMessageHandler(), "unjail", "unjail_message", null, 4, null));
            this$0.plugin.getLogger().debug("<green>Player " + $playerName + " successfully unjailed (Folia).</green>");
        } else {
            this$0.plugin.getLogger().debug("<red>Failed to teleport player " + $playerName + " during unjail (Folia).</red>");
        }
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void execute$lambda$3$lambda$2(UnjailCommand this$0, String $playerName, Throwable throwable) {
        this$0.plugin.getLogger().debug("<red>Error while teleporting " + $playerName + " during unjail: " + throwable.getMessage() + "</red>");
        return null;
    }

    private static final void execute$lambda$3(Player $player, Location $spawnLocation, UnjailCommand this$0, String $playerName) {
        try {
            ((CompletableFuture)$player.teleportAsync($spawnLocation).thenAccept(arg_0 -> UnjailCommand.execute$lambda$3$lambda$1(arg_0 -> UnjailCommand.execute$lambda$3$lambda$0($player, this$0, $playerName, arg_0), arg_0))).exceptionally(arg_0 -> UnjailCommand.execute$lambda$3$lambda$2(this$0, $playerName, arg_0));
        }
        catch (Exception e) {
            this$0.plugin.getLogger().debug("<red>Error during Folia unjail for " + $playerName + ": " + e.getMessage() + "</red>");
        }
    }
}

