/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.listeners;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.connection.PlayerLoginConnection;
import io.papermc.paper.event.connection.PlayerConnectionValidateLoginEvent;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lpl/syntaxdevteam/punisher/listeners/ModernLoginListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "onValidateLogin", "", "event", "Lio/papermc/paper/event/connection/PlayerConnectionValidateLoginEvent;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nModernLoginListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModernLoginListener.kt\npl/syntaxdevteam/punisher/listeners/ModernLoginListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1869#2,2:89\n*S KotlinDebug\n*F\n+ 1 ModernLoginListener.kt\npl/syntaxdevteam/punisher/listeners/ModernLoginListener\n*L\n66#1:89,2\n*E\n"})
public final class ModernLoginListener
implements Listener {
    @NotNull
    private final PunisherX plugin;

    public ModernLoginListener(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onValidateLogin(@NotNull PlayerConnectionValidateLoginEvent event) {
        PlayerProfile profile;
        Intrinsics.checkNotNullParameter(event, "event");
        Object object = event.getConnection();
        PlayerLoginConnection playerLoginConnection = object instanceof PlayerLoginConnection ? (PlayerLoginConnection)object : null;
        if (playerLoginConnection == null) {
            event.allow();
            return;
        }
        PlayerLoginConnection loginConn = playerLoginConnection;
        PlayerProfile playerProfile = loginConn.getUnsafeProfile();
        if (playerProfile == null) {
            playerProfile = loginConn.getAuthenticatedProfile();
        }
        PlayerProfile playerProfile2 = profile = playerProfile;
        object = playerProfile2 != null ? playerProfile2.getName() : null;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            this.plugin.getLogger().debug("ModernLogin: brak profilu \u2192 allow()");
            event.allow();
            return;
        }
        String playerName = profile.getName();
        UUIDManager uUIDManager = this.plugin.getUuidManager();
        String string = playerName;
        Intrinsics.checkNotNull(string);
        UUID uuid = uUIDManager.getUUID(string);
        this.plugin.getLogger().debug("Checking punishment for player: " + playerName);
        String ip = loginConn.getClientAddress().getAddress().getHostAddress();
        try {
            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
            String string2 = uuid.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            Collection collection = DatabaseHandler.getPunishments$default(databaseHandler, string2, null, null, 6, null);
            DatabaseHandler databaseHandler2 = this.plugin.getDatabaseHandler();
            Intrinsics.checkNotNull(ip);
            List<PunishmentData> punishments = CollectionsKt.plus(collection, (Iterable)databaseHandler2.getPunishmentsByIP(ip));
            if (punishments.isEmpty()) {
                this.plugin.getLogger().debug("No punishments found for player: " + playerName);
                event.allow();
                return;
            }
            for (PunishmentData punishment : punishments) {
                if (this.plugin.getPunishmentManager().isPunishmentActive(punishment) && (Intrinsics.areEqual(punishment.getType(), "BAN") || Intrinsics.areEqual(punishment.getType(), "BANIP"))) {
                    TextComponent.Builder builder;
                    List<Object> list;
                    long endTime = punishment.getEnd();
                    long remainingSecs = endTime == -1L ? -1L : (endTime - System.currentTimeMillis()) / (long)1000;
                    String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingSecs));
                    String reason = punishment.getReason();
                    String string3 = punishment.getType();
                    if (Intrinsics.areEqual(string3, "BAN")) {
                        var18_16 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                        list = this.plugin.getMessageHandler().getComplexMessage("ban", "kick_message", MapsKt.mapOf(var18_16));
                    } else if (Intrinsics.areEqual(string3, "BANIP")) {
                        var18_16 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                        list = this.plugin.getMessageHandler().getComplexMessage("banip", "kick_message", MapsKt.mapOf(var18_16));
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List kickLines = list;
                    TextComponent.Builder b = builder = Component.text();
                    boolean bl = false;
                    Iterable $this$forEach$iv = kickLines;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Component line = (Component)element$iv;
                        boolean bl2 = false;
                        ((TextComponent.Builder)b.append(line)).append((Component)Component.newline());
                    }
                    BuildableComponent buildableComponent = builder.build();
                    Intrinsics.checkNotNullExpressionValue(buildableComponent, "build(...)");
                    TextComponent kickMessage = (TextComponent)buildableComponent;
                    event.kickMessage((Component)kickMessage);
                    event.getConnection().disconnect((Component)kickMessage);
                    this.plugin.getLogger().debug("Player " + playerName + " was kicked for: " + reason);
                    return;
                }
                if (this.plugin.getPunishmentManager().isPunishmentActive(punishment)) continue;
                DatabaseHandler databaseHandler3 = this.plugin.getDatabaseHandler();
                String string3 = uuid.toString();
                Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
                databaseHandler3.removePunishment(string3, punishment.getType(), true);
                this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
            }
            event.allow();
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Error in onValidateLogin for " + playerName + ": " + ex.getMessage());
            ex.printStackTrace();
            event.allow();
        }
    }
}

