/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007J$\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/punisher/loader/VersionChecker;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "getRawVersion", "", "getServerVersion", "isSupported", "", "checkAndLog", "isAtLeast", "minVersion", "compareVersions", "", "a", "", "b", "normalizeVersion", "Companion", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nVersionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionChecker.kt\npl/syntaxdevteam/punisher/loader/VersionChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1#2:71\n1563#3:72\n1634#3,3:73\n*S KotlinDebug\n*F\n+ 1 VersionChecker.kt\npl/syntaxdevteam/punisher/loader/VersionChecker\n*L\n60#1:72\n60#1:73,3\n*E\n"})
public final class VersionChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private static final Set<String> SUPPORTED_VERSIONS;

    public VersionChecker(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    private final String getRawVersion() {
        String string = Bukkit.getServer().getBukkitVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getBukkitVersion(...)");
        return string;
    }

    @NotNull
    public final String getServerVersion() {
        return StringsKt.substringBefore$default(this.getRawVersion(), "-", null, 2, null);
    }

    public final boolean isSupported() {
        return SUPPORTED_VERSIONS.contains(this.getServerVersion());
    }

    public final boolean checkAndLog() {
        boolean bl;
        String version = this.getServerVersion();
        if (this.isSupported()) {
            this.plugin.getLogger().success("The server is running on a supported version " + version + ".");
            bl = true;
        } else {
            this.plugin.getLogger().warning("Warning! Unsupported version " + version + " \u2013 use with caution!");
            bl = false;
        }
        return bl;
    }

    public final boolean isAtLeast(@NotNull String minVersion) {
        Intrinsics.checkNotNullParameter(minVersion, "minVersion");
        List<Integer> current = this.normalizeVersion(this.getServerVersion());
        List<Integer> required = this.normalizeVersion(minVersion);
        return this.compareVersions(current, required) >= 0;
    }

    private final int compareVersions(List<Integer> a, List<Integer> b) {
        for (int i = 0; i < 3; ++i) {
            Integer n;
            int it;
            Integer n2;
            List<Integer> list = a;
            boolean bl = 0 <= i ? i < list.size() : false;
            if (bl) {
                n2 = list.get(i);
            } else {
                it = i;
                boolean bl2 = false;
                n2 = 0;
            }
            int n3 = ((Number)n2).intValue();
            list = b;
            boolean bl3 = 0 <= i ? i < list.size() : false;
            if (bl3) {
                n = list.get(i);
            } else {
                it = i;
                int n4 = n3;
                boolean bl4 = false;
                Integer n5 = 0;
                n3 = n4;
                n = n5;
            }
            int cmp = Intrinsics.compare(n3, ((Number)n).intValue());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> normalizeVersion(String $this$normalizeVersion) {
        List<Integer> list;
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$normalizeVersion, stringArray, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = StringsKt.toIntOrNull((String)it);
            collection.add(n != null ? n : 0);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        switch (it.size()) {
            case 1: {
                Integer[] integerArray = new Integer[]{it.get(0), 0, 0};
                list = CollectionsKt.listOf(integerArray);
                break;
            }
            case 2: {
                Integer[] integerArray = new Integer[]{it.get(0), it.get(1), 0};
                list = CollectionsKt.listOf(integerArray);
                break;
            }
            default: {
                Integer[] integerArray = new Integer[]{it.get(0), it.get(1), it.get(2)};
                list = CollectionsKt.listOf(integerArray);
            }
        }
        return list;
    }

    static {
        String[] stringArray = new String[]{"1.20.6", "1.21", "1.21.0", "1.21.1", "1.21.2", "1.21.3", "1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8"};
        SUPPORTED_VERSIONS = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lpl/syntaxdevteam/punisher/loader/VersionChecker$Companion;", "", "<init>", "()V", "SUPPORTED_VERSIONS", "", "", "PunisherX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

