/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\nJ\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0019J\b\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lpl/syntaxdevteam/punisher/basic/PunishmentCache;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "cacheFile", "Ljava/io/File;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Ljava/util/UUID;", "", "gson", "Lcom/google/gson/Gson;", "addOrUpdatePunishment", "", "uuid", "endTime", "removePunishment", "isPunishmentActive", "", "isPlayerInCache", "getPunishmentEnd", "(Ljava/util/UUID;)Ljava/lang/Long;", "getActivePunishments", "", "loadCacheIntoMemory", "isValidUUID", "str", "", "saveSingleEntry", "removeSingleEntry", "Companion", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunishmentCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunishmentCache.kt\npl/syntaxdevteam/punisher/basic/PunishmentCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,136:1\n774#2:137\n865#2,2:138\n1869#2,2:140\n1#3:142\n504#4,7:143\n216#5,2:150\n*S KotlinDebug\n*F\n+ 1 PunishmentCache.kt\npl/syntaxdevteam/punisher/basic/PunishmentCache\n*L\n55#1:137\n55#1:138,2\n56#1:140,2\n75#1:143,7\n86#1:150,2\n*E\n"})
public final class PunishmentCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final File cacheFile;
    @NotNull
    private final Cache<UUID, Long> cache;
    @NotNull
    private final Gson gson;
    private static final long DEFAULT_EXPIRE_AFTER_ACCESS = 1L;
    @NotNull
    private static final TimeUnit DEFAULT_EXPIRE_UNIT = TimeUnit.HOURS;
    private static final long DEFAULT_MAXIMUM_SIZE = 1000L;

    public PunishmentCache(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.cacheFile = new File(this.plugin.getDataFolder(), "jail_cache.json");
        Cache cache = Caffeine.newBuilder().expireAfterAccess(1L, DEFAULT_EXPIRE_UNIT).maximumSize(1000L).build();
        Intrinsics.checkNotNullExpressionValue(cache, "build(...)");
        this.cache = cache;
        this.gson = new Gson();
        this.loadCacheIntoMemory();
    }

    public final void addOrUpdatePunishment(@NotNull UUID uuid, long endTime) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Long previous = (Long)this.cache.getIfPresent((Object)uuid);
        if (previous == null || previous < System.currentTimeMillis()) {
            this.plugin.getLogger().debug("Dodaj\u0119 now\u0105 kar\u0119 dla gracza " + uuid + " do " + endTime);
        } else {
            this.plugin.getLogger().debug("Aktualizuj\u0119 kar\u0119 dla gracza " + uuid + " z " + previous + " na " + endTime);
        }
        this.cache.put((Object)uuid, (Object)endTime);
        this.saveSingleEntry(uuid, endTime);
    }

    /*
     * WARNING - void declaration
     */
    public final void removePunishment(@NotNull UUID uuid) {
        block3: {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            if (this.cache.asMap().remove(uuid) == null) break block3;
            this.plugin.getLogger().debug("Usuwam kar\u0119 dla " + uuid);
            this.removeSingleEntry(uuid);
            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
            String string = uuid.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            DatabaseHandler.removePunishment$default(databaseHandler, string, "JAIL", false, 4, null);
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Player player2 = player;
                boolean bl = false;
                Component bc = this.plugin.getMessageHandler().getMessage("unjail", "broadcast", MapsKt.mapOf(TuplesKt.to("player", player2.getName())));
                Collection collection = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                Iterable iterable = collection;
                boolean $i$f$filter = false;
                Iterator iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Player it = (Player)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.hasPermission("punisherx.see.unjail")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Player it = (Player)element$iv;
                    boolean bl3 = false;
                    it.sendMessage(bc);
                }
                player2.sendMessage(this.plugin.getMessageHandler().getMessage("unjail", "success", MapsKt.mapOf(TuplesKt.to("player", player2.getName()))));
            }
        }
    }

    public final boolean isPunishmentActive(@NotNull UUID uuid) {
        boolean bl;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Long l = (Long)this.cache.getIfPresent((Object)uuid);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            bl = it > System.currentTimeMillis();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isPlayerInCache(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return this.cache.asMap().containsKey(uuid);
    }

    @Nullable
    public final Long getPunishmentEnd(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return (Long)this.cache.getIfPresent((Object)uuid);
    }

    @NotNull
    public final Map<UUID, Long> getActivePunishments() {
        ConcurrentMap concurrentMap = this.cache.asMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "asMap(...)");
        Map $this$filterValues$iv = concurrentMap;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Long it = (Long)entry$iv.getValue();
            boolean bl = false;
            if (!(it > System.currentTimeMillis())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    private final void loadCacheIntoMemory() {
        if (!this.cacheFile.exists()) {
            this.plugin.getLogger().debug("Cache file does not exist, creating an empty cache.");
            return;
        }
        try {
            Map map;
            String json = FilesKt.readText$default(this.cacheFile, null, 1, null);
            Type type2 = new TypeToken<Map<String, ? extends Long>>(){}.getType();
            Object object = this.gson.fromJson(json, type2);
            Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
            Map $this$forEach$iv = map = (Map)object;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                long value = ((Number)entry.getValue()).longValue();
                if (this.isValidUUID(key)) {
                    this.cache.put((Object)UUID.fromString(key), (Object)value);
                    continue;
                }
                this.plugin.getLogger().warning("Invalid UUID in cache: " + key + ". Skipping this entry.");
            }
            this.plugin.getLogger().debug("Loaded " + this.cache.asMap().size() + " entries into cache.");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Unexpected error loading cache: " + e.getMessage());
        }
    }

    private final boolean isValidUUID(String str) {
        boolean bl;
        try {
            UUID.fromString(str);
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    private final void saveSingleEntry(UUID uuid, long endTime) {
        try {
            Map map;
            if (this.cacheFile.exists()) {
                map = (Map)this.gson.fromJson(FilesKt.readText$default(this.cacheFile, null, 1, null), new TypeToken<Map<String, Long>>(){}.getType());
                if (map == null) {
                    map = new LinkedHashMap();
                }
            } else {
                map = new LinkedHashMap();
            }
            Map existing2 = map;
            existing2.put(uuid.toString(), endTime);
            String string = this.gson.toJson((Object)existing2);
            Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
            FilesKt.writeText$default(this.cacheFile, string, null, 2, null);
            this.plugin.getLogger().debug("Saved punishment for player " + uuid + ".");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error saving punishment to file: " + e.getMessage());
        }
    }

    private final void removeSingleEntry(UUID uuid) {
        try {
            if (!this.cacheFile.exists()) {
                return;
            }
            Map map = (Map)this.gson.fromJson(FilesKt.readText$default(this.cacheFile, null, 1, null), new TypeToken<Map<String, Long>>(){}.getType());
            if (map == null) {
                map = new LinkedHashMap();
            }
            Map existing2 = map;
            existing2.remove(uuid.toString());
            String string = this.gson.toJson((Object)existing2);
            Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
            FilesKt.writeText$default(this.cacheFile, string, null, 2, null);
            this.plugin.getLogger().debug("Removed punishment for player " + uuid + " from file.");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error removing punishment from file: " + e.getMessage());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lpl/syntaxdevteam/punisher/basic/PunishmentCache$Companion;", "", "<init>", "()V", "DEFAULT_EXPIRE_AFTER_ACCESS", "", "DEFAULT_EXPIRE_UNIT", "Ljava/util/concurrent/TimeUnit;", "DEFAULT_MAXIMUM_SIZE", "PunisherX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

