/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.basic;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.JailUtils;
import pl.syntaxdevteam.punisher.basic.PunishmentCache;
import pl.syntaxdevteam.punisher.common.UUIDManager;
import pl.syntaxdevteam.punisher.common.UpdateChecker;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.databases.PunishmentData;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001aH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/syntaxdevteam/punisher/basic/PunishmentChecker;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "updateChecker", "Lpl/syntaxdevteam/punisher/common/UpdateChecker;", "onPlayerLogin", "", "event", "Lorg/bukkit/event/player/PlayerLoginEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerChat", "Lio/papermc/paper/event/player/AsyncChatEvent;", "onPlayerCommand", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "isPlayerInJail", "", "playerLocation", "Lorg/bukkit/Location;", "jailCenter", "radius", "", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nPunishmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PunishmentChecker.kt\npl/syntaxdevteam/punisher/basic/PunishmentChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n1869#2:251\n1869#2,2:252\n1870#2:254\n1869#2,2:255\n*S KotlinDebug\n*F\n+ 1 PunishmentChecker.kt\npl/syntaxdevteam/punisher/basic/PunishmentChecker\n*L\n41#1:251\n54#1:252,2\n41#1:254\n168#1:255,2\n*E\n"})
public final class PunishmentChecker
implements Listener {
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private final UpdateChecker updateChecker;

    public PunishmentChecker(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.updateChecker = new UpdateChecker(this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerLogin(@NotNull PlayerLoginEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        try {
            this.plugin.getLogger().debug("Checking punishment for player: " + player2.getName());
            UUIDManager uUIDManager = this.plugin.getUuidManager();
            String string = player2.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String string2 = uUIDManager.getUUID(string).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String uuid = string2;
            String ip = event.getAddress().getHostAddress();
            Collection collection = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
            DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
            Intrinsics.checkNotNull(ip);
            List punishments = CollectionsKt.plus(collection, (Iterable)databaseHandler.getPunishmentsByIP(ip));
            if (punishments.isEmpty()) {
                this.plugin.getLogger().debug("No punishments found for player: " + event.getPlayer().getName());
                return;
            }
            Iterable $this$forEach$iv = punishments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PunishmentData punishment = (PunishmentData)element$iv;
                boolean bl = false;
                if (this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                    TextComponent.Builder kickMessage;
                    List<Object> list;
                    if (!Intrinsics.areEqual(punishment.getType(), "BAN") && !Intrinsics.areEqual(punishment.getType(), "BANIP")) continue;
                    long endTime = punishment.getEnd();
                    long remainingTime = (endTime - System.currentTimeMillis()) / (long)1000;
                    String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingTime));
                    String reason = punishment.getReason();
                    String string3 = punishment.getType();
                    if (Intrinsics.areEqual(string3, "BAN")) {
                        var19_18 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                        list = this.plugin.getMessageHandler().getComplexMessage("ban", "kick_message", MapsKt.mapOf(var19_18));
                    } else if (Intrinsics.areEqual(string3, "BANIP")) {
                        var19_18 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                        list = this.plugin.getMessageHandler().getComplexMessage("banip", "kick_message", MapsKt.mapOf(var19_18));
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List kickMessages = list;
                    Intrinsics.checkNotNullExpressionValue(Component.text(), "text(...)");
                    Iterable $this$forEach$iv2 = kickMessages;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Component line = (Component)element$iv2;
                        boolean bl2 = false;
                        kickMessage.append(line);
                        kickMessage.append((Component)Component.newline());
                    }
                    event.disallow(PlayerLoginEvent.Result.KICK_BANNED, (Component)kickMessage.build());
                    this.plugin.getLogger().debug("Player " + event.getPlayer().getName() + " was kicked for: " + reason);
                    continue;
                }
                this.plugin.getDatabaseHandler().removePunishment(uuid, punishment.getType(), true);
                this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerPreLogin, report it urgently to the plugin author with the message: " + event.getPlayer().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        double radius = this.plugin.getConfig().getDouble("jail.radius", 10.0);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> PunishmentChecker.onPlayerJoin$lambda$2(player2, this, radius), 1L);
        if (PermissionChecker.INSTANCE.hasWithLegacy((CommandSender)player2, PermissionChecker.PermissionKey.SEE_UPDATE)) {
            this.updateChecker.checkForUpdatesForPlayer(player2);
            this.plugin.getLogger().debug("Checking for updates for player: " + player2.getName());
        } else {
            this.plugin.getLogger().debug("Player " + player2.getName() + " does not have permission to see updates.");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerChat(@NotNull AsyncChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String playerName = string;
        try {
            String string2 = this.plugin.getUuidManager().getUUID(playerName).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String uuid = string2;
            Component component = event.message();
            Intrinsics.checkNotNullExpressionValue(component, "message(...)");
            Component messageComponent = component;
            String string3 = PlainTextComponentSerializer.plainText().serialize(messageComponent);
            Intrinsics.checkNotNullExpressionValue(string3, "serialize(...)");
            String plainMessage = string3;
            List punishments = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
            if (punishments.isEmpty()) {
                this.plugin.getLogger().debug("No punishments found for player: " + playerName);
                return;
            }
            for (PunishmentData punishment : punishments) {
                if ((Intrinsics.areEqual(punishment.getType(), "MUTE") || Intrinsics.areEqual(punishment.getType(), "JAIL")) && this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                    event.setCancelled(true);
                    long endTime = punishment.getEnd();
                    String remainingTime = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf((endTime - System.currentTimeMillis()) / (long)1000));
                    String reason = punishment.getReason();
                    String messageKey = Intrinsics.areEqual(punishment.getType(), "JAIL") ? "jail" : "mute";
                    Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", remainingTime)};
                    Component infoMessage = this.plugin.getMessageHandler().getMessage(messageKey, "mute_info_message", MapsKt.mapOf(pairArray));
                    Pair[] pairArray2 = new Pair[]{TuplesKt.to("player", playerName), TuplesKt.to("message", plainMessage)};
                    Component logMessage = this.plugin.getMessageHandler().getLogMessage(messageKey, "log", MapsKt.mapOf(pairArray2));
                    this.plugin.getLogger().clearLog(logMessage);
                    player2.sendMessage(infoMessage);
                    return;
                }
                this.plugin.getDatabaseHandler().removePunishment(uuid, "MUTE", true);
                this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerChat, report it urgently to the plugin author: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerCommand(@NotNull PlayerCommandPreprocessEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        try {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            Player player2 = player;
            UUIDManager uUIDManager = this.plugin.getUuidManager();
            String string = player2.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String string2 = uUIDManager.getUUID(string).toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String uuid = string2;
            String string3 = event.getMessage();
            Intrinsics.checkNotNullExpressionValue(string3, "getMessage(...)");
            Object object = new String[]{" "};
            object = (String)StringsKt.split$default((CharSequence)string3, (String[])object, false, 0, 6, null).get(0);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string4 = ((String)object).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            String command = StringsKt.removePrefix(string4, (CharSequence)"/");
            if (this.plugin.getConfig().getBoolean("mute_pm")) {
                List list = this.plugin.getConfig().getStringList("mute_cmd");
                Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
                List muteCommands = list;
                if (muteCommands.contains(command)) {
                    List punishments = DatabaseHandler.getPunishments$default(this.plugin.getDatabaseHandler(), uuid, null, null, 6, null);
                    Iterable $this$forEach$iv = punishments;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PunishmentData punishment = (PunishmentData)element$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual(punishment.getType(), "MUTE") && this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                            long endTime = punishment.getEnd();
                            long remainingTime = (endTime - System.currentTimeMillis()) / (long)1000;
                            String duration = endTime == -1L ? "permanent" : this.plugin.getTimeHandler().formatTime(String.valueOf(remainingTime));
                            String reason = punishment.getReason();
                            event.setCancelled(true);
                            Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", duration)};
                            Component muteMessage = this.plugin.getMessageHandler().getMessage("mute", "mute_message", MapsKt.mapOf(pairArray));
                            player2.sendMessage(muteMessage);
                            continue;
                        }
                        this.plugin.getDatabaseHandler().removePunishment(uuid, "MUTE", true);
                        this.plugin.getLogger().debug("Punishment for UUID: " + uuid + " has expired and has been removed");
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in onPlayerCommand, report it urgently to the plugin author with the message: " + event.getPlayer().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private final boolean isPlayerInJail(Location playerLocation, Location jailCenter, double radius) {
        return Intrinsics.areEqual(playerLocation.getWorld(), jailCenter.getWorld()) && playerLocation.distance(jailCenter) <= radius;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUIDManager uUIDManager = this.plugin.getUuidManager();
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        UUID uuid = uUIDManager.getUUID(string);
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        Location location = JailUtils.INSTANCE.getJailLocation(fileConfiguration);
        if (location == null) {
            return;
        }
        Location jailLocation = location;
        Long l = this.plugin.getCache().getPunishmentEnd(uuid);
        if (l == null) {
            return;
        }
        long punishmentEnd = l;
        if (!this.plugin.getCache().isPlayerInCache(uuid)) {
            return;
        }
        if (punishmentEnd != -1L && punishmentEnd < System.currentTimeMillis()) {
            this.plugin.getCache().removePunishment(uuid);
            player2.setGameMode(GameMode.SURVIVAL);
            return;
        }
        double radius = this.plugin.getConfig().getDouble("jail.radius", 10.0);
        String string2 = this.plugin.getServer().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        if (StringsKt.contains$default((CharSequence)string2, "Folia", false, 2, null)) {
            Bukkit.getServer().getRegionScheduler().execute((Plugin)this.plugin, jailLocation, () -> PunishmentChecker.onPlayerMove$lambda$8(this, player2, jailLocation, radius));
        } else {
            Location location2 = player2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            if (!this.isPlayerInJail(location2, jailLocation, radius)) {
                player2.teleport(jailLocation);
                Component message = this.plugin.getMessageHandler().getMessage("jail", "jail_restrict_message", MapsKt.emptyMap());
                player2.sendMessage(message);
            }
        }
    }

    private static final void onPlayerJoin$lambda$2(Player $player, PunishmentChecker this$0, double $radius) {
        if (!$player.isOnline()) {
            return;
        }
        FileConfiguration fileConfiguration = this$0.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        Location jailLoc = JailUtils.INSTANCE.getJailLocation(fileConfiguration);
        FileConfiguration fileConfiguration2 = this$0.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration2, "getConfig(...)");
        Location unjailLoc = JailUtils.INSTANCE.getUnjailLocation(fileConfiguration2);
        if (jailLoc == null || unjailLoc == null) {
            this$0.plugin.getLogger().warning("Jail lub unjail location niezdefiniowane!");
            return;
        }
        this$0.plugin.getLogger().debug("DBG: Player at " + $player.getLocation() + ", jail at " + jailLoc + ", radius " + $radius);
        Location location = $player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this$0.isPlayerInJail(location, jailLoc, $radius)) {
            this$0.plugin.getLogger().debug("DBG: teleporting " + $player.getName() + " \u2192 " + unjailLoc);
            $player.teleport(unjailLoc);
            $player.setGameMode(GameMode.SURVIVAL);
            this$0.plugin.getLogger().debug("Player " + $player.getName() + " by\u0142 w obszarze jail po joinie \u2013 przeniesiony na unjail");
        } else {
            PunishmentCache punishmentCache = this$0.plugin.getCache();
            UUID uUID = $player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            if (!punishmentCache.isPunishmentActive(uUID)) {
                return;
            }
            if (!jailLoc.getChunk().isLoaded()) {
                jailLoc.getChunk().load();
            }
            $player.teleport(jailLoc);
            $player.setGameMode(GameMode.ADVENTURE);
        }
    }

    private static final Unit onPlayerMove$lambda$8$lambda$7$lambda$4(PunishmentChecker this$0, Player $player, Boolean success) {
        if (success.booleanValue()) {
            Component message = this$0.plugin.getMessageHandler().getMessage("jail", "jail_restrict_message", MapsKt.emptyMap());
            $player.sendMessage(message);
        } else {
            this$0.plugin.getLogger().debug("<red>Failed to teleport player back to jail in Folia.</red>");
        }
        return Unit.INSTANCE;
    }

    private static final void onPlayerMove$lambda$8$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void onPlayerMove$lambda$8$lambda$7$lambda$6(PunishmentChecker this$0, Throwable throwable) {
        this$0.plugin.getLogger().debug("<red>Error while teleporting back to jail: " + throwable.getMessage() + "</red>");
        return null;
    }

    private static final void onPlayerMove$lambda$8$lambda$7(Player $player, Location $jailLocation, PunishmentChecker this$0) {
        ((CompletableFuture)$player.teleportAsync($jailLocation).thenAccept(arg_0 -> PunishmentChecker.onPlayerMove$lambda$8$lambda$7$lambda$5(arg_0 -> PunishmentChecker.onPlayerMove$lambda$8$lambda$7$lambda$4(this$0, $player, arg_0), arg_0))).exceptionally(arg_0 -> PunishmentChecker.onPlayerMove$lambda$8$lambda$7$lambda$6(this$0, arg_0));
    }

    private static final void onPlayerMove$lambda$8(PunishmentChecker this$0, Player $player, Location $jailLocation, double $radius) {
        try {
            Location location = $player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            boolean isInJail = this$0.isPlayerInJail(location, $jailLocation, $radius);
            if (!isInJail) {
                Bukkit.getServer().getGlobalRegionScheduler().execute((Plugin)this$0.plugin, () -> PunishmentChecker.onPlayerMove$lambda$8$lambda$7($player, $jailLocation, this$0));
            }
        }
        catch (Exception e) {
            this$0.plugin.getLogger().debug("<red>Error while checking player in jail: " + e.getMessage() + "</red>");
        }
    }
}

