/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.ban.BanListType;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.CommandLoggerPlugin;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lpl/syntaxdevteam/punisher/commands/BanCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "clp", "Lpl/syntaxdevteam/punisher/common/CommandLoggerPlugin;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "generateTimeSuggestions", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nBanCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BanCommand.kt\npl/syntaxdevteam/punisher/commands/BanCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n827#2:121\n855#2,2:122\n827#2:124\n855#2,2:125\n1869#2,2:127\n1869#2,2:129\n1563#2:131\n1634#2,3:132\n*S KotlinDebug\n*F\n+ 1 BanCommand.kt\npl/syntaxdevteam/punisher/commands/BanCommand\n*L\n44#1:121\n44#1:122,2\n47#1:124\n47#1:125,2\n70#1:127,2\n79#1:129,2\n102#1:131\n102#1:132,3\n*E\n"})
public final class BanCommand
implements BasicCommand {
    @NotNull
    private PunisherX plugin;
    @NotNull
    private final CommandLoggerPlugin clp;

    public BanCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.clp = this.plugin.getCommandLoggerPlugin();
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.BAN)) {
            if (!(args.length == 0)) {
                if (args.length < 2) {
                    stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "ban", "usage", null, 4, null));
                } else {
                    Pair[] kickMessage;
                    Object kickMessages;
                    Iterable destination$iv$iv;
                    String player = args[0];
                    UUID uuid = this.plugin.getUuidManager().getUUID(player);
                    Player targetPlayer = Bukkit.getPlayer((UUID)uuid);
                    boolean isForce = ArraysKt.contains(args, "--force");
                    if (targetPlayer != null && !isForce && PermissionChecker.INSTANCE.hasWithLegacy((CommandSender)targetPlayer, PermissionChecker.PermissionKey.BYPASS_BAN)) {
                        stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", player))));
                        return;
                    }
                    if (PermissionChecker.INSTANCE.isAuthor(uuid)) {
                        stack.getSender().sendMessage(this.plugin.getMessageHandler().formatMixedTextToMiniMessage("<red>You can't punish the plugin author</red>"));
                        return;
                    }
                    String gtime = null;
                    String reason = null;
                    try {
                        void $this$filterNotTo$iv$iv;
                        gtime = args[1];
                        this.plugin.getTimeHandler().parseTime(gtime);
                        Iterable $this$filterNot$iv = ArraysKt.slice(args, RangesKt.until(2, args.length));
                        boolean $i$f$filterNot = false;
                        Iterable iterable = $this$filterNot$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Iterator element$iv$iv : $this$filterNotTo$iv$iv) {
                            String it = (String)((Object)element$iv$iv);
                            boolean bl = false;
                            if (Intrinsics.areEqual(it, "--force")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        reason = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
                    }
                    catch (NumberFormatException numberFormatException) {
                        void $this$filterNotTo$iv$iv;
                        gtime = null;
                        Iterable $this$filterNot$iv = ArraysKt.slice(args, RangesKt.until(1, args.length));
                        boolean $i$f$filterNot = false;
                        destination$iv$iv = $this$filterNot$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                            String it = (String)element$iv$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual(it, "--force")) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        reason = CollectionsKt.joinToString$default((List)destination$iv$iv2, " ", null, null, 0, null, null, 62, null);
                    }
                    String punishmentType = "BAN";
                    long start = System.currentTimeMillis();
                    Long end = gtime != null ? Long.valueOf(System.currentTimeMillis() + this.plugin.getTimeHandler().parseTime(gtime) * (long)1000) : null;
                    DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                    String string = uuid.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    String string2 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    Long l = end;
                    boolean success = databaseHandler.addPunishment(player, string, reason, string2, punishmentType, start, l != null ? l : -1L);
                    if (success) {
                        this.plugin.getLogger().err("Failed to add ban to database for player " + player + ". Using fallback method.");
                        return;
                    }
                    PlayerProfile playerProfile = Bukkit.createProfile((UUID)UUID.fromString(uuid.toString()), (String)player);
                    Intrinsics.checkNotNullExpressionValue(playerProfile, "createProfile(...)");
                    PlayerProfile playerProfile2 = playerProfile;
                    BanList banList = Bukkit.getBanList((BanListType)BanListType.PROFILE);
                    Intrinsics.checkNotNullExpressionValue(banList, "getBanList(...)");
                    Pair[] banList2 = (Pair[])banList;
                    Date banEndDate = gtime != null ? new Date(System.currentTimeMillis() + this.plugin.getTimeHandler().parseTime(gtime) * (long)1000) : null;
                    banList2.addBan(playerProfile2, reason, banEndDate, stack.getSender().getName());
                    String string3 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                    this.clp.logCommand(string3, punishmentType, player, reason);
                    DatabaseHandler databaseHandler2 = this.plugin.getDatabaseHandler();
                    String string4 = uuid.toString();
                    Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
                    String string5 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                    Long l2 = end;
                    databaseHandler2.addPunishmentHistory(player, string4, reason, string5, punishmentType, start, l2 != null ? l2 : -1L);
                    if (targetPlayer != null) {
                        banList2 = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime))};
                        kickMessages = this.plugin.getMessageHandler().getComplexMessage("ban", "kick_message", MapsKt.mapOf(banList2));
                        Pair[] pairArray = Component.text();
                        Intrinsics.checkNotNullExpressionValue(pairArray, "text(...)");
                        kickMessage = pairArray;
                        Iterable $this$forEach$iv = (Iterable)kickMessages;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Component line = (Component)element$iv;
                            boolean bl = false;
                            kickMessage.append(line);
                            kickMessage.append((Component)Component.newline());
                        }
                        targetPlayer.kick((Component)kickMessage.build());
                    }
                    kickMessages = new Pair[]{TuplesKt.to("player", player), TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime))};
                    stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("ban", "ban", MapsKt.mapOf(kickMessages)));
                    kickMessage = new Pair[]{TuplesKt.to("player", player), TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime))};
                    Component broadcastMessage = this.plugin.getMessageHandler().getMessage("ban", "broadcast", MapsKt.mapOf(kickMessage));
                    Collection collection = this.plugin.getServer().getOnlinePlayers();
                    Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Player onlinePlayer = (Player)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(onlinePlayer);
                        if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)onlinePlayer, PermissionChecker.PermissionKey.SEE_BAN)) continue;
                        onlinePlayer.sendMessage(broadcastMessage);
                    }
                    if (isForce) {
                        this.plugin.getLogger().warning("Force-banned by " + stack.getSender().getName() + " on " + player);
                    }
                }
            } else {
                stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "ban", "usage", null, 4, null));
            }
        } else {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "error", "no_permission", null, 4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.BAN)) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v1 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v1, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v1;
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_10 = (Player)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-BanCommand$suggest$1 = false;
                    var12_12.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> this.generateTimeSuggestions();
            case 3 -> this.plugin.getMessageHandler().getReasons("ban", "reasons");
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<String> generateTimeSuggestions() {
        String[] stringArray = new String[]{"s", "m", "h", "d"};
        List<String> units = CollectionsKt.listOf(stringArray);
        List suggestions = new ArrayList();
        for (int i = 1; i < 1000; ++i) {
            for (String unit : units) {
                suggestions.add(i + unit);
            }
        }
        return suggestions;
    }
}

