/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.databases.DatabaseHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lpl/syntaxdevteam/punisher/commands/MuteCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "generateTimeSuggestions", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nMuteCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MuteCommand.kt\npl/syntaxdevteam/punisher/commands/MuteCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n827#2:97\n855#2,2:98\n827#2:100\n855#2,2:101\n1869#2,2:103\n1563#2:105\n1634#2,3:106\n*S KotlinDebug\n*F\n+ 1 MuteCommand.kt\npl/syntaxdevteam/punisher/commands/MuteCommand\n*L\n41#1:97\n41#1:98,2\n44#1:100\n44#1:101,2\n59#1:103,2\n78#1:105\n78#1:106,3\n*E\n"})
public final class MuteCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public MuteCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.MUTE)) {
            if (!(args.length == 0)) {
                if (args.length < 2) {
                    stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "mute", "usage", null, 4, null));
                } else {
                    Pair[] element$iv$iv2;
                    Iterable destination$iv$iv;
                    String player = args[0];
                    Player targetPlayer = Bukkit.getPlayer((String)player);
                    boolean isForce = ArraysKt.contains(args, "--force");
                    if (targetPlayer != null && !isForce && PermissionChecker.INSTANCE.hasWithBypass((CommandSender)targetPlayer, PermissionChecker.PermissionKey.BYPASS_MUTE)) {
                        stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("error", "bypass", MapsKt.mapOf(TuplesKt.to("player", player))));
                        return;
                    }
                    String string = this.plugin.getUuidManager().getUUID(player).toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    String uuid = string;
                    String gtime = null;
                    String reason = null;
                    try {
                        void $this$filterNotTo$iv$iv;
                        gtime = args[1];
                        this.plugin.getTimeHandler().parseTime(gtime);
                        Iterable $this$filterNot$iv = ArraysKt.slice(args, RangesKt.until(2, args.length));
                        boolean $i$f$filterNot = false;
                        Iterable iterable = $this$filterNot$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Pair[] element$iv$iv2 : $this$filterNotTo$iv$iv) {
                            String it = (String)element$iv$iv2;
                            boolean bl = false;
                            if (Intrinsics.areEqual(it, "--force")) continue;
                            destination$iv$iv.add(element$iv$iv2);
                        }
                        reason = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
                    }
                    catch (NumberFormatException e) {
                        void $this$filterNotTo$iv$iv;
                        gtime = null;
                        Iterable $this$filterNot$iv = ArraysKt.slice(args, RangesKt.until(1, args.length));
                        boolean $i$f$filterNot = false;
                        destination$iv$iv = $this$filterNot$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Object element$iv$iv3 : $this$filterNotTo$iv$iv) {
                            String it = (String)element$iv$iv3;
                            boolean bl = false;
                            if (Intrinsics.areEqual(it, "--force")) continue;
                            destination$iv$iv2.add(element$iv$iv3);
                        }
                        reason = CollectionsKt.joinToString$default((List)destination$iv$iv2, " ", null, null, 0, null, null, 62, null);
                    }
                    String punishmentType = "MUTE";
                    long start = System.currentTimeMillis();
                    Long end = gtime != null ? Long.valueOf(System.currentTimeMillis() + this.plugin.getTimeHandler().parseTime(gtime) * (long)1000) : null;
                    DatabaseHandler databaseHandler = this.plugin.getDatabaseHandler();
                    String string2 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    Long l = end;
                    databaseHandler.addPunishment(player, uuid, reason, string2, punishmentType, start, l != null ? l : -1L);
                    DatabaseHandler databaseHandler2 = this.plugin.getDatabaseHandler();
                    String string3 = stack.getSender().getName();
                    Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                    Long l2 = end;
                    databaseHandler2.addPunishmentHistory(player, uuid, reason, string3, punishmentType, start, l2 != null ? l2 : -1L);
                    Pair[] destination$iv$iv2 = new Pair[]{TuplesKt.to("player", player), TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime))};
                    stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("mute", "mute", MapsKt.mapOf(destination$iv$iv2)));
                    Pair[] $i$f$filterNotTo = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime))};
                    Component muteMessage = this.plugin.getMessageHandler().getMessage("mute", "mute_message", MapsKt.mapOf($i$f$filterNotTo));
                    Player player2 = targetPlayer;
                    if (player2 != null) {
                        player2.sendMessage(muteMessage);
                    }
                    element$iv$iv2 = new Pair[]{TuplesKt.to("player", player), TuplesKt.to("reason", reason), TuplesKt.to("time", this.plugin.getTimeHandler().formatTime(gtime))};
                    Component broadcastMessage = this.plugin.getMessageHandler().getMessage("mute", "broadcast", MapsKt.mapOf(element$iv$iv2));
                    Collection collection = this.plugin.getServer().getOnlinePlayers();
                    Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Player onlinePlayer = (Player)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(onlinePlayer);
                        if (!PermissionChecker.INSTANCE.hasWithSee((CommandSender)onlinePlayer, PermissionChecker.PermissionKey.SEE_MUTE)) continue;
                        onlinePlayer.sendMessage(broadcastMessage);
                    }
                }
            } else {
                stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "mute", "usage", null, 4, null));
            }
        } else {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "error", "no_permission", null, 4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.MUTE)) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$mapTo$iv$iv;
                Collection v1 = this.plugin.getServer().getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(v1, "getOnlinePlayers(...)");
                Iterable $this$map$iv = v1;
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Player var10_10 = (Player)item$iv$iv;
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-MuteCommand$suggest$1 = false;
                    var12_12.add(it.getName());
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> this.generateTimeSuggestions();
            case 3 -> this.plugin.getMessageHandler().getReasons("mute", "reasons");
            default -> CollectionsKt.emptyList();
        };
    }

    private final List<String> generateTimeSuggestions() {
        String[] stringArray = new String[]{"s", "m", "h", "d"};
        List<String> units = CollectionsKt.listOf(stringArray);
        List suggestions = new ArrayList();
        for (int i = 1; i < 1000; ++i) {
            for (String unit : units) {
                suggestions.add(i + unit);
            }
        }
        return suggestions;
    }
}

