/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.basic.JailUtils;
import pl.syntaxdevteam.punisher.common.MessageHandler;
import pl.syntaxdevteam.punisher.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/syntaxdevteam/punisher/commands/SetSpawnCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nSetSpawnCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetSpawnCommand.kt\npl/syntaxdevteam/punisher/commands/SetSpawnCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1563#2:62\n1634#2,3:63\n*S KotlinDebug\n*F\n+ 1 SetSpawnCommand.kt\npl/syntaxdevteam/punisher/commands/SetSpawnCommand\n*L\n56#1:62\n56#1:63,3\n*E\n"})
public final class SetSpawnCommand
implements BasicCommand {
    @NotNull
    private final PunisherX plugin;

    public SetSpawnCommand(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(stack.getSender() instanceof Player)) {
            stack.getSender().sendMessage(MessageHandler.getLogMessage$default(this.plugin.getMessageHandler(), "error", "console", null, 4, null));
            return;
        }
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.MANAGE_SET_SPAWN)) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "error", "no_permission", null, 4, null));
            return;
        }
        CommandSender commandSender2 = stack.getSender();
        Intrinsics.checkNotNull(commandSender2, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)commandSender2;
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        Object object = location2.getWorld();
        if (object == null || (object = object.getName()) == null) {
            object = "world";
        }
        Object world = object;
        String locationX = String.valueOf(location2.getBlockX());
        String locationY = String.valueOf(location2.getBlockY());
        String locationZ = String.valueOf(location2.getBlockZ());
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        if (JailUtils.INSTANCE.setUnjailLocation(fileConfiguration, location2)) {
            this.plugin.saveConfig();
            Pair[] pairArray = new Pair[]{TuplesKt.to("world", world), TuplesKt.to("locationx", locationX), TuplesKt.to("locationy", locationY), TuplesKt.to("locationz", locationZ)};
            stack.getSender().sendMessage(this.plugin.getMessageHandler().getMessage("setspawn", "set", MapsKt.mapOf(pairArray)));
        } else {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "setspawn", "set_error", null, 4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        if (!PermissionChecker.INSTANCE.hasWithLegacy(commandSender, PermissionChecker.PermissionKey.MANAGE_SET_SPAWN)) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> CollectionsKt.listOf("radius");
            case 2 -> {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = new IntRange(1, 100);
                boolean $i$f$map = false;
                Iterable var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator var8_8 = $this$mapTo$iv$iv.iterator();
                while (var8_8.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int var10_10 = item$iv$iv = ((IntIterator)var8_8).nextInt();
                    Collection var12_12 = destination$iv$iv;
                    boolean $i$a$-map-SetSpawnCommand$suggest$1 = false;
                    var12_12.add(String.valueOf((int)it));
                }
                yield (List)destination$iv$iv;
            }
            default -> CollectionsKt.emptyList();
        };
    }
}

