/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.databases;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.punisher.PunisherX;
import pl.syntaxdevteam.punisher.common.Logger;
import pl.syntaxdevteam.punisher.databases.PunishmentData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0006\u0010\u0014\u001a\u00020\rJ>\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ>\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ1\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0018\u001a\u00020\u000b2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010&J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010(\u001a\u00020\u000bJ \u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010+\u001a\u00020\u0016J\u000e\u0010,\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u000bJ1\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0018\u001a\u00020\u000b2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010&J\u0006\u0010.\u001a\u00020$J\u0006\u0010/\u001a\u00020$J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0018\u001a\u00020\u000bH\u0007J\u0016\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\u000bJ\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020\"052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\"052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$J\u0006\u00107\u001a\u00020\rJ\u0006\u00108\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lpl/syntaxdevteam/punisher/databases/DatabaseHandler;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "dataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "logger", "Lpl/syntaxdevteam/punisher/common/Logger;", "dbType", "", "setupDataSource", "", "openConnection", "closeConnection", "getConnection", "Ljava/sql/Connection;", "enableSQLiteWAL", "connection", "createTables", "addPunishment", "", "name", "uuid", "reason", "operator", "punishmentType", "start", "", "end", "addPunishmentHistory", "getPunishments", "", "Lpl/syntaxdevteam/punisher/databases/PunishmentData;", "limit", "", "offset", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "getPunishmentsByIP", "ip", "removePunishment", "uuidOrIp", "removeAll", "getActiveWarnCount", "getPunishmentHistory", "countAllPunishments", "countAllPunishmentHistory", "getLastTenPunishments", "updatePunishmentReason", "id", "newReason", "getBannedPlayers", "", "getHistoryBannedPlayers", "exportDatabase", "importDatabase", "PunisherX"})
@SourceDebugExtension(value={"SMAP\nDatabaseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseHandler.kt\npl/syntaxdevteam/punisher/databases/DatabaseHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,834:1\n1869#2,2:835\n*S KotlinDebug\n*F\n+ 1 DatabaseHandler.kt\npl/syntaxdevteam/punisher/databases/DatabaseHandler\n*L\n354#1:835,2\n*E\n"})
public final class DatabaseHandler {
    @NotNull
    private final PunisherX plugin;
    @Nullable
    private HikariDataSource dataSource;
    @NotNull
    private Logger logger;
    @NotNull
    private final String dbType;

    public DatabaseHandler(@NotNull PunisherX plugin) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
                this.plugin = plugin;
                this.logger = this.plugin.getLogger();
                string = this.plugin.getConfig().getString("database.type");
                if (string == null) break block2;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                string = string2;
                if (string2 != null) break block3;
            }
            string = "sqlite";
        }
        this.dbType = string;
        this.setupDataSource();
    }

    private final void setupDataSource() {
        String string;
        String user;
        HikariConfig hikariConfig = new HikariConfig();
        String string2 = this.plugin.getConfig().getString("database.sql.dbname");
        if (string2 == null) {
            String string3 = this.plugin.getName();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        }
        String dbName = string2;
        String string4 = this.plugin.getConfig().getString("database.sql.username");
        if (string4 == null) {
            string4 = user = "ROOT";
        }
        if ((string = this.plugin.getConfig().getString("database.sql.password")) == null) {
            string = "U5eV3ryStr0ngP4ssw0rd";
        }
        String password = string;
        switch (this.dbType) {
            case "mariadb": 
            case "mysql": {
                hikariConfig.setJdbcUrl("jdbc:mysql://" + this.plugin.getConfig().getString("database.sql.host") + ":" + this.plugin.getConfig().getString("database.sql.port") + "/" + dbName);
                hikariConfig.setUsername(user);
                hikariConfig.setPassword(password);
                hikariConfig.setDriverClassName("com.mysql.cj.jdbc.Driver");
                break;
            }
            case "postgresql": {
                hikariConfig.setJdbcUrl("jdbc:postgresql://" + this.plugin.getConfig().getString("database.sql.host") + ":" + this.plugin.getConfig().getString("database.sql.port") + "/" + dbName);
                hikariConfig.setUsername(user);
                hikariConfig.setPassword(password);
                hikariConfig.setDriverClassName("org.postgresql.Driver");
                break;
            }
            case "sqlite": {
                hikariConfig.setJdbcUrl("jdbc:sqlite:" + this.plugin.getDataFolder() + "/" + dbName + ".db");
                hikariConfig.setDriverClassName("org.sqlite.JDBC");
                break;
            }
            case "h2": {
                hikariConfig.setJdbcUrl("jdbc:h2:./" + this.plugin.getDataFolder() + "/" + dbName);
                hikariConfig.setUsername(user);
                hikariConfig.setPassword(password);
                hikariConfig.setDriverClassName("org.h2.Driver");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported database type: " + this.dbType);
            }
        }
        if (Intrinsics.areEqual(this.dbType, "sqlite")) {
            hikariConfig.setMaximumPoolSize(2);
            hikariConfig.setMinimumIdle(1);
            hikariConfig.setConnectionTimeout(30000L);
            hikariConfig.setIdleTimeout(10000L);
            hikariConfig.setMaxLifetime(60000L);
            hikariConfig.setKeepaliveTime(30000L);
        } else {
            hikariConfig.setMaximumPoolSize(20);
            hikariConfig.setMinimumIdle(2);
            hikariConfig.setConnectionTimeout(30000L);
            hikariConfig.setIdleTimeout(600000L);
            hikariConfig.setMaxLifetime(1800000L);
            hikariConfig.setKeepaliveTime(900000L);
            hikariConfig.setLeakDetectionThreshold(2000L);
        }
        this.logger.debug("Setting up data source for database type: " + this.dbType);
        try {
            this.dataSource = new HikariDataSource(hikariConfig);
            this.logger.debug("HikariCP data source initialized successfully for " + this.dbType + ".");
        }
        catch (Exception e) {
            this.logger.err("Failed to initialize HikariCP data source: " + e.getMessage());
            throw e;
        }
    }

    public final void openConnection() {
        if (this.dataSource == null) {
            this.setupDataSource();
        }
    }

    public final void closeConnection() {
        try {
            HikariDataSource hikariDataSource;
            HikariDataSource hikariDataSource2;
            HikariDataSource hikariDataSource3;
            HikariDataSource hikariDataSource4 = this.dataSource;
            if (hikariDataSource4 != null) {
                hikariDataSource4.close();
            }
            this.logger.info("HikariCP pool shut down. Total=" + ((hikariDataSource3 = this.dataSource) != null && (hikariDataSource3 = hikariDataSource3.getHikariPoolMXBean()) != null ? Integer.valueOf(hikariDataSource3.getTotalConnections()) : null) + ", Active=" + ((hikariDataSource2 = this.dataSource) != null && (hikariDataSource2 = hikariDataSource2.getHikariPoolMXBean()) != null ? Integer.valueOf(hikariDataSource2.getActiveConnections()) : null) + ", Idle=" + ((hikariDataSource = this.dataSource) != null && (hikariDataSource = hikariDataSource.getHikariPoolMXBean()) != null ? Integer.valueOf(hikariDataSource.getIdleConnections()) : null));
        }
        catch (SQLException e) {
            this.logger.err("Error while closing HikariCP pool: " + e.getMessage());
        }
    }

    private final Connection getConnection() {
        Connection connection;
        try {
            HikariDataSource hikariDataSource;
            HikariDataSource hikariDataSource2;
            Connection connection2;
            HikariDataSource hikariDataSource3 = this.dataSource;
            Connection connection3 = connection2 = hikariDataSource3 != null ? hikariDataSource3.getConnection() : null;
            if (connection2 != null && Intrinsics.areEqual(this.dbType, "sqlite")) {
                this.enableSQLiteWAL(connection2);
            }
            this.logger.debug("Connection obtained: Active=" + ((hikariDataSource2 = this.dataSource) != null && (hikariDataSource2 = hikariDataSource2.getHikariPoolMXBean()) != null ? Integer.valueOf(hikariDataSource2.getActiveConnections()) : null) + ", Idle=" + ((hikariDataSource = this.dataSource) != null && (hikariDataSource = hikariDataSource.getHikariPoolMXBean()) != null ? Integer.valueOf(hikariDataSource.getIdleConnections()) : null));
        }
        catch (SQLException e) {
            this.logger.err("Failed to get connection. " + e.getMessage());
            connection = null;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enableSQLiteWAL(Connection connection) {
        this.logger.debug("SQLite connection detected! I'm enabling WAL mode");
        try {
            AutoCloseable autoCloseable = connection.createStatement();
            Throwable throwable = null;
            try {
                Statement statement = (Statement)autoCloseable;
                boolean bl = false;
                statement.execute("PRAGMA journal_mode=WAL;");
                this.logger.debug("SQLite WAL mode enabled.");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        catch (SQLException e) {
            this.logger.err("Failed to enable SQLite WAL mode. " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createTables() {
        block39: {
            Connection connection = this.getConnection();
            if (connection == null) break block39;
            AutoCloseable autoCloseable = connection;
            Throwable throwable = null;
            try {
                Connection conn = (Connection)autoCloseable;
                boolean bl = false;
                this.logger.debug("Database connection established from createTables");
                AutoCloseable autoCloseable2 = conn.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement statement = (Statement)autoCloseable2;
                    boolean bl2 = false;
                    try {
                        String createTablesPunishments = switch (this.dbType) {
                            case "sqlite" -> "CREATE TABLE IF NOT EXISTS punishments (\n    id INTEGER PRIMARY KEY AUTOINCREMENT,\n    name TEXT,\n    uuid TEXT,\n    reason TEXT,\n    operator TEXT,\n    punishmentType TEXT,\n    start TEXT,\n    endTime TEXT\n);";
                            case "postgresql" -> "CREATE TABLE IF NOT EXISTS punishments ( \n    id SERIAL PRIMARY KEY, \n    name VARCHAR(32), \n    uuid VARCHAR(36), \n    reason VARCHAR(255), \n    operator VARCHAR(16), \n    punishmentType VARCHAR(16), \n    start BIGINT, \n    endTime VARCHAR(32) \n); ";
                            case "h2" -> "CREATE TABLE IF NOT EXISTS punishments (\n    id INT AUTO_INCREMENT PRIMARY KEY,\n    name VARCHAR(32),\n    uuid VARCHAR(36),\n    reason VARCHAR(255),\n    operator VARCHAR(16),\n    punishmentType VARCHAR(16),\n    start BIGINT,\n    endTime VARCHAR(32)\n);";
                            default -> "CREATE TABLE IF NOT EXISTS punishments (\n    id INT AUTO_INCREMENT PRIMARY KEY,\n    name VARCHAR(32),\n    uuid VARCHAR(36),\n    reason VARCHAR(255),\n    operator VARCHAR(16),\n    punishmentType VARCHAR(16),\n    start BIGINT,\n    endTime VARCHAR(32)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;";
                        };
                        statement.executeUpdate(createTablesPunishments);
                        this.logger.debug("Operacje na tabeli 'punishments' uko\u0144czone.");
                        String createTablesPunishmenthistory = switch (this.dbType) {
                            case "sqlite" -> "CREATE TABLE IF NOT EXISTS punishmenthistory (\n    id INTEGER PRIMARY KEY AUTOINCREMENT,\n    name TEXT,\n    uuid TEXT,\n    reason TEXT,\n    operator TEXT,\n    punishmentType TEXT,\n    start TEXT,\n    endTime TEXT\n);";
                            case "postgresql" -> "CREATE TABLE IF NOT EXISTS punishmenthistory (\n    id SERIAL PRIMARY KEY,\n    name VARCHAR(32),\n    uuid VARCHAR(36),\n    reason VARCHAR(255),\n    operator VARCHAR(16),\n    punishmentType VARCHAR(16),\n    start BIGINT,\n    endTime VARCHAR(32)\n);";
                            case "h2" -> "CREATE TABLE IF NOT EXISTS punishmenthistory (\n    id INT AUTO_INCREMENT PRIMARY KEY,\n    name VARCHAR(32),\n    uuid VARCHAR(36),\n    reason VARCHAR(255),\n    operator VARCHAR(16),\n    punishmentType VARCHAR(16),\n    start BIGINT,\n    endTime VARCHAR(32)\n);";
                            default -> "CREATE TABLE IF NOT EXISTS punishmenthistory (\n    id INT AUTO_INCREMENT PRIMARY KEY,\n    name VARCHAR(32),\n    uuid VARCHAR(36),\n    reason VARCHAR(255),\n    operator VARCHAR(16),\n    punishmentType VARCHAR(16),\n    start BIGINT,\n    endTime VARCHAR(32)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;";
                        };
                        statement.executeUpdate(createTablesPunishmenthistory);
                        this.logger.debug("Operacje na tabeli 'punishmenthistory' uko\u0144czone.");
                    }
                    catch (SQLException ex) {
                        this.logger.err("B\u0142\u0105d podczas tworzenia tabel: " + ex.getMessage());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        this.logger.err("Brak po\u0142\u0105czenia z baz\u0105 danych.");
        this.logger.debug("Operacje tworzenia tabel zako\u0144czone.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addPunishment(@NotNull String name, @NotNull String uuid, @NotNull String reason, @NotNull String operator, @NotNull String punishmentType, long start, long end) {
        boolean bl;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Intrinsics.checkNotNullParameter(operator, "operator");
        Intrinsics.checkNotNullParameter(punishmentType, "punishmentType");
        try {
            boolean bl2;
            Connection connection = this.getConnection();
            if (connection != null) {
                AutoCloseable autoCloseable = connection;
                Throwable throwable = null;
                try {
                    boolean bl3;
                    Connection conn = (Connection)autoCloseable;
                    boolean bl4 = false;
                    this.logger.debug("Database connection established from addPunishment");
                    String query = "INSERT INTO punishments (name, uuid, reason, operator, punishmentType, start, endTime)\nVALUES (?, ?, ?, ?, ?, ?, ?)";
                    AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                    Throwable throwable2 = null;
                    try {
                        PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                        boolean bl5 = false;
                        preparedStatement.setString(1, name);
                        preparedStatement.setString(2, uuid);
                        preparedStatement.setString(3, reason);
                        preparedStatement.setString(4, operator);
                        preparedStatement.setString(5, punishmentType);
                        preparedStatement.setLong(6, start);
                        preparedStatement.setLong(7, end);
                        preparedStatement.executeUpdate();
                        this.plugin.getLogger().debug("Punishment for player " + name + " added to the database.");
                        bl3 = true;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                    }
                    bl2 = bl3;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
            }
            throw new SQLException("No connection available");
            bl = bl2;
        }
        catch (SQLException e) {
            this.plugin.getLogger().err("Failed to add punishment for player " + name + ". " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPunishmentHistory(@NotNull String name, @NotNull String uuid, @NotNull String reason, @NotNull String operator, @NotNull String punishmentType, long start, long end) {
        block14: {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Intrinsics.checkNotNullParameter(reason, "reason");
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(punishmentType, "punishmentType");
            try {
                Connection connection = this.getConnection();
                if (connection != null) {
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        this.logger.debug("Database connection established from addPunishmentHistory");
                        String query = "INSERT INTO punishmenthistory (name, uuid, reason, operator, punishmentType, start, endTime)\nVALUES (?, ?, ?, ?, ?, ?, ?)";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            preparedStatement.setString(1, name);
                            preparedStatement.setString(2, uuid);
                            preparedStatement.setString(3, reason);
                            preparedStatement.setString(4, operator);
                            preparedStatement.setString(5, punishmentType);
                            preparedStatement.setLong(6, start);
                            preparedStatement.setLong(7, end);
                            preparedStatement.executeUpdate();
                            this.plugin.getLogger().debug("Punishment history for player " + name + " added to the database.");
                            this.plugin.getDiscordWebhook().sendPunishmentWebhook(name, operator, reason, punishmentType, end);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block14;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to add punishment history for player " + name + ". " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PunishmentData> getPunishments(@NotNull String uuid, @Nullable Integer limit, @Nullable Integer offset) {
        List punishments;
        block32: {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            punishments = new ArrayList();
            this.logger.debug("Database connection established from getPunishments");
            try {
                block33: {
                    Connection connection = this.getConnection();
                    if (connection == null) break block33;
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        String string = this.dbType.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                        boolean supportsOrderAndLimit = switch (string) {
                            case "mariadb", "postgresql", "sqlite", "mysql" -> true;
                            case "h2" -> false;
                            default -> false;
                        };
                        String query = supportsOrderAndLimit && limit != null && offset != null ? "SELECT * FROM punishments\nWHERE uuid = ?\nORDER BY start DESC\nLIMIT ? OFFSET ?" : "SELECT * FROM punishments\nWHERE uuid = ?";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            preparedStatement.setString(1, uuid);
                            if (supportsOrderAndLimit && limit != null && offset != null) {
                                preparedStatement.setInt(2, limit);
                                preparedStatement.setInt(3, offset);
                            }
                            ResultSet resultSet = preparedStatement.executeQuery();
                            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
                            ResultSet resultSet2 = resultSet;
                            List punishmentsToRemove = new ArrayList();
                            while (resultSet2.next()) {
                                int id = resultSet2.getInt("id");
                                String type2 = resultSet2.getString("punishmentType");
                                String reason = resultSet2.getString("reason");
                                long start = resultSet2.getLong("start");
                                long end = resultSet2.getLong("endTime");
                                String name = resultSet2.getString("name");
                                String operator = resultSet2.getString("operator");
                                Intrinsics.checkNotNull(type2);
                                Intrinsics.checkNotNull(reason);
                                Intrinsics.checkNotNull(name);
                                Intrinsics.checkNotNull(operator);
                                PunishmentData punishment = new PunishmentData(id, uuid, type2, reason, start, end, name, operator);
                                boolean bl3 = this.plugin.getPunishmentManager().isPunishmentActive(punishment) ? punishments.add(punishment) : punishmentsToRemove.add(TuplesKt.to(uuid, type2));
                            }
                            Iterable $this$forEach$iv = punishmentsToRemove;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                Pair pair = (Pair)element$iv;
                                boolean bl4 = false;
                                String uuid2 = (String)pair.component1();
                                String type3 = (String)pair.component2();
                                DatabaseHandler.removePunishment$default(this, uuid2, type3, false, 4, null);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block32;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to get punishments for UUID: " + uuid + ". " + e.getMessage());
            }
        }
        return punishments;
    }

    public static /* synthetic */ List getPunishments$default(DatabaseHandler databaseHandler, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return databaseHandler.getPunishments(string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PunishmentData> getPunishmentsByIP(@NotNull String ip) {
        List punishments;
        block16: {
            Intrinsics.checkNotNullParameter(ip, "ip");
            punishments = new ArrayList();
            try {
                Connection connection = this.getConnection();
                if (connection != null) {
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        this.logger.debug("Database connection established from getPunishmentsByIP");
                        String query = "SELECT * FROM punishments WHERE uuid = ?";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            preparedStatement.setString(1, ip);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
                            ResultSet resultSet2 = resultSet;
                            while (resultSet2.next()) {
                                int id = resultSet2.getInt("id");
                                String type2 = resultSet2.getString("punishmentType");
                                String reason = resultSet2.getString("reason");
                                long start = resultSet2.getLong("start");
                                long end = resultSet2.getLong("endTime");
                                String name = resultSet2.getString("name");
                                String operator = resultSet2.getString("operator");
                                Intrinsics.checkNotNull(type2);
                                Intrinsics.checkNotNull(reason);
                                Intrinsics.checkNotNull(name);
                                Intrinsics.checkNotNull(operator);
                                PunishmentData punishment = new PunishmentData(id, ip, type2, reason, start, end, name, operator);
                                if (this.plugin.getPunishmentManager().isPunishmentActive(punishment)) {
                                    punishments.add(punishment);
                                    continue;
                                }
                                DatabaseHandler.removePunishment$default(this, ip, type2, false, 4, null);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block16;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to get punishments for IP: " + ip + ". " + e.getMessage());
            }
        }
        return punishments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void removePunishment(@NotNull String uuidOrIp, @NotNull String punishmentType, boolean removeAll) {
        block32: {
            Intrinsics.checkNotNullParameter(uuidOrIp, "uuidOrIp");
            Intrinsics.checkNotNullParameter(punishmentType, "punishmentType");
            try {
                block33: {
                    v0 = this.getConnection();
                    if (v0 == null) break block33;
                    var5_4 = v0;
                    var6_5 = null;
                    try {
                        block34: {
                            conn = (Connection)var5_4;
                            $i$a$-use-DatabaseHandler$removePunishment$1 = false;
                            this.logger.debug("Database connection established from removePunishment");
                            var9_10 = this.dbType;
                            switch (var9_10.hashCode()) {
                                case -2105481388: {
                                    if (!var9_10.equals("postgresql")) {
                                        break;
                                    }
                                    ** GOTO lbl26
                                }
                                case -894935028: {
                                    if (!var9_10.equals("sqlite")) {
                                        break;
                                    }
                                    ** GOTO lbl26
                                }
                                case 3274: {
                                    if (!var9_10.equals("h2")) break;
lbl26:
                                    // 3 sources

                                    v1 = removeAll ? "DELETE FROM punishments \nWHERE uuid = ? AND punishmentType = ?" : "DELETE FROM punishments \nWHERE uuid = ? AND punishmentType = ? \nAND start = (SELECT start FROM punishments WHERE uuid = ? AND punishmentType = ? ORDER BY start DESC LIMIT 1)";
                                    break block34;
                                }
                            }
                            v1 = removeAll != false ? "DELETE FROM punishments \nWHERE uuid = ? AND punishmentType = ?" : "DELETE FROM punishments \nWHERE uuid = ? AND punishmentType = ?\nORDER BY start DESC\nLIMIT 1";
                        }
                        query = v1;
                        var9_10 = conn.prepareStatement(query);
                        var11_12 = null;
                        try {
                            block35: {
                                block36: {
                                    preparedStatement = (PreparedStatement)var9_10;
                                    $i$a$-use-DatabaseHandler$removePunishment$1$1 = false;
                                    preparedStatement.setString(1, uuidOrIp);
                                    preparedStatement.setString(2, punishmentType);
                                    if (removeAll) break block35;
                                    v2 = this.plugin.getConfig().getString("database.type");
                                    if (v2 != null) {
                                        v3 = v2.toLowerCase(Locale.ROOT);
                                        v4 = v3;
                                        Intrinsics.checkNotNullExpressionValue(v3, "toLowerCase(...)");
                                    } else {
                                        v4 = null;
                                    }
                                    if (Intrinsics.areEqual(v4, "postgresql")) break block36;
                                    v5 = this.plugin.getConfig().getString("database.type");
                                    if (v5 != null) {
                                        v6 = v5.toLowerCase(Locale.ROOT);
                                        v7 = v6;
                                        Intrinsics.checkNotNullExpressionValue(v6, "toLowerCase(...)");
                                    } else {
                                        v7 = null;
                                    }
                                    if (Intrinsics.areEqual(v7, "h2")) break block36;
                                    v8 = this.plugin.getConfig().getString("database.type");
                                    if (v8 != null) {
                                        v9 = v8.toLowerCase(Locale.ROOT);
                                        v10 = v9;
                                        Intrinsics.checkNotNullExpressionValue(v9, "toLowerCase(...)");
                                    } else {
                                        v10 = null;
                                    }
                                    if (!Intrinsics.areEqual(v10, "sqlite")) break block35;
                                }
                                preparedStatement.setString(3, uuidOrIp);
                                preparedStatement.setString(4, punishmentType);
                            }
                            if ((rowsAffected = preparedStatement.executeUpdate()) > 0) {
                                this.plugin.getLogger().debug("Punishment of type " + punishmentType + " for UUID/IP: " + uuidOrIp + " removed from the database.");
                            } else {
                                this.plugin.getLogger().debug("No punishment of type " + punishmentType + " found for UUID/IP: " + uuidOrIp + ".");
                            }
                            var12_13 = Unit.INSTANCE;
                        }
                        catch (Throwable var13_15) {
                            var11_12 = var13_15;
                            throw var13_15;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)var9_10, var11_12);
                        }
                        var7_6 = Unit.INSTANCE;
                        break block32;
                    }
                    catch (Throwable var8_8) {
                        var6_5 = var8_8;
                        throw var8_8;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(var5_4, var6_5);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to remove punishment of type " + punishmentType + " for UUID/IP: " + uuidOrIp + ". " + e.getMessage());
            }
        }
    }

    public static /* synthetic */ void removePunishment$default(DatabaseHandler databaseHandler, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        databaseHandler.removePunishment(string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getActiveWarnCount(@NotNull String uuid) {
        List punishments;
        block15: {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            punishments = new ArrayList();
            try {
                Connection connection = this.getConnection();
                if (connection != null) {
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        this.logger.debug("Database connection established from getActiveWarnCount");
                        String query = "SELECT * FROM punishments WHERE uuid = ? AND punishmentType = 'WARN'";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            preparedStatement.setString(1, uuid);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
                            ResultSet resultSet2 = resultSet;
                            while (resultSet2.next()) {
                                int id = resultSet2.getInt("id");
                                String type2 = resultSet2.getString("punishmentType");
                                String reason = resultSet2.getString("reason");
                                long start = resultSet2.getLong("start");
                                long end = resultSet2.getLong("endTime");
                                String name = resultSet2.getString("name");
                                String operator = resultSet2.getString("operator");
                                Intrinsics.checkNotNull(type2);
                                Intrinsics.checkNotNull(reason);
                                Intrinsics.checkNotNull(name);
                                Intrinsics.checkNotNull(operator);
                                PunishmentData punishment = new PunishmentData(id, uuid, type2, reason, start, end, name, operator);
                                if (!this.plugin.getPunishmentManager().isPunishmentActive(punishment)) continue;
                                punishments.add(punishment);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block15;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to get active warn count for UUID: " + uuid + ". " + e.getMessage());
            }
        }
        return punishments.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PunishmentData> getPunishmentHistory(@NotNull String uuid, @Nullable Integer limit, @Nullable Integer offset) {
        List punishments;
        block31: {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            punishments = new ArrayList();
            this.logger.debug("Database connection established from getPunishmentHistory");
            try {
                block32: {
                    Connection connection = this.getConnection();
                    if (connection == null) break block32;
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        String string = this.dbType.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                        boolean supportsOrderAndLimit = switch (string) {
                            case "mariadb", "postgresql", "sqlite", "mysql" -> true;
                            case "h2" -> false;
                            default -> false;
                        };
                        String query = supportsOrderAndLimit && limit != null && offset != null ? "SELECT * FROM punishmentHistory\nWHERE uuid = ?\nORDER BY start DESC\nLIMIT ? OFFSET ?" : "SELECT * FROM punishmentHistory\nWHERE uuid = ?";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            preparedStatement.setString(1, uuid);
                            if (supportsOrderAndLimit && limit != null && offset != null) {
                                preparedStatement.setInt(2, limit);
                                preparedStatement.setInt(3, offset);
                            }
                            ResultSet resultSet = preparedStatement.executeQuery();
                            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
                            ResultSet resultSet2 = resultSet;
                            while (resultSet2.next()) {
                                int id = resultSet2.getInt("id");
                                String type2 = resultSet2.getString("punishmentType");
                                String reason = resultSet2.getString("reason");
                                long start = resultSet2.getLong("start");
                                long end = resultSet2.getLong("endTime");
                                String name = resultSet2.getString("name");
                                String operator = resultSet2.getString("operator");
                                Intrinsics.checkNotNull(type2);
                                Intrinsics.checkNotNull(reason);
                                Intrinsics.checkNotNull(name);
                                Intrinsics.checkNotNull(operator);
                                PunishmentData punishment = new PunishmentData(id, uuid, type2, reason, start, end, name, operator);
                                punishments.add(punishment);
                            }
                            resultSet2.close();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block31;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to get punishment history for UUID: " + uuid + ". " + e.getMessage());
            }
        }
        return punishments;
    }

    public static /* synthetic */ List getPunishmentHistory$default(DatabaseHandler databaseHandler, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return databaseHandler.getPunishmentHistory(string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int countAllPunishments() {
        int count;
        block15: {
            count = 0;
            try {
                Connection connection = this.getConnection();
                if (connection != null) {
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        String query = "SELECT COUNT(*) FROM punishments";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (resultSet.next()) {
                                count = resultSet.getInt(1);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block15;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to count punishments. " + e.getMessage());
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int countAllPunishmentHistory() {
        int count;
        block15: {
            count = 0;
            try {
                Connection connection = this.getConnection();
                if (connection != null) {
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        String query = "SELECT COUNT(*) FROM punishmenthistory";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (resultSet.next()) {
                                count = resultSet.getInt(1);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block15;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to count punishment history. " + e.getMessage());
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="This method is deprecated and will be removed in future releases. Use getPunishment or getPunishmentHistory instead.")
    @NotNull
    public final List<PunishmentData> getLastTenPunishments(@NotNull String uuid) {
        List punishments;
        block15: {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            punishments = new ArrayList();
            try {
                Connection connection = this.getConnection();
                if (connection != null) {
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        this.logger.debug("Database connection established from getLastTenPunishments");
                        String query = "SELECT * FROM punishmenthistory WHERE uuid = ? ORDER BY start DESC LIMIT 10";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            preparedStatement.setString(1, uuid);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
                            ResultSet resultSet2 = resultSet;
                            while (resultSet2.next()) {
                                int id = resultSet2.getInt("id");
                                String type2 = resultSet2.getString("punishmentType");
                                String reason = resultSet2.getString("reason");
                                long start = resultSet2.getLong("start");
                                long end = resultSet2.getLong("endTime");
                                String name = resultSet2.getString("name");
                                String operator = resultSet2.getString("operator");
                                Intrinsics.checkNotNull(type2);
                                Intrinsics.checkNotNull(reason);
                                Intrinsics.checkNotNull(name);
                                Intrinsics.checkNotNull(operator);
                                PunishmentData punishment = new PunishmentData(id, uuid, type2, reason, start, end, name, operator);
                                punishments.add(punishment);
                            }
                            resultSet2.close();
                            preparedStatement.close();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block15;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to get last ten punishments for UUID: " + uuid + ". " + e.getMessage());
            }
        }
        return punishments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean updatePunishmentReason(int id, @NotNull String newReason) {
        boolean bl;
        Intrinsics.checkNotNullParameter(newReason, "newReason");
        try {
            boolean bl2;
            Connection connection = this.getConnection();
            if (connection != null) {
                AutoCloseable autoCloseable = connection;
                Throwable throwable = null;
                try {
                    boolean bl3;
                    Connection conn = (Connection)autoCloseable;
                    boolean bl4 = false;
                    this.logger.debug("Database connection established from updatePunishmentReason");
                    String query = "UPDATE punishmentHistory SET reason = ? WHERE id = ?";
                    AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                    Throwable throwable2 = null;
                    try {
                        PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                        boolean bl5 = false;
                        preparedStatement.setString(1, newReason);
                        preparedStatement.setInt(2, id);
                        int rowsUpdated = preparedStatement.executeUpdate();
                        preparedStatement.close();
                        bl3 = rowsUpdated > 0;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                    }
                    bl2 = bl3;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
            }
            throw new SQLException("No connection available");
            bl = bl2;
        }
        catch (SQLException e) {
            this.plugin.getLogger().err("Failed to update punishment reason for ID: " + id + ". " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PunishmentData> getBannedPlayers(int limit, int offset) {
        List bannedPlayers;
        block33: {
            bannedPlayers = new ArrayList();
            try {
                block34: {
                    Connection connection = this.getConnection();
                    if (connection == null) break block34;
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        this.logger.debug("Database connection established from getBannedPlayers");
                        String string = this.dbType.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                        boolean supportsOrderAndLimit = switch (string) {
                            case "mariadb", "postgresql", "sqlite", "mysql" -> true;
                            case "h2" -> false;
                            default -> false;
                        };
                        String query = supportsOrderAndLimit ? "SELECT * FROM punishments \nWHERE punishmentType IN ('BAN', 'BANIP') \nORDER BY start DESC \nLIMIT ? OFFSET ?" : "SELECT * FROM punishments \nWHERE punishmentType IN ('BAN', 'BANIP')";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            if (supportsOrderAndLimit) {
                                preparedStatement.setInt(1, limit);
                                preparedStatement.setInt(2, offset);
                            }
                            ResultSet resultSet = preparedStatement.executeQuery();
                            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
                            ResultSet resultSet2 = resultSet;
                            int skipped = 0;
                            while (resultSet2.next()) {
                                if (!supportsOrderAndLimit && skipped < offset) {
                                    ++skipped;
                                    continue;
                                }
                                if (!supportsOrderAndLimit && bannedPlayers.size() >= limit) break;
                                int id = resultSet2.getInt("id");
                                String name = resultSet2.getString("name");
                                String uuid = resultSet2.getString("uuid");
                                String reason = resultSet2.getString("reason");
                                String operator = resultSet2.getString("operator");
                                String punishmentType = resultSet2.getString("punishmentType");
                                long start = resultSet2.getLong("start");
                                long end = resultSet2.getLong("endTime");
                                Intrinsics.checkNotNull(uuid);
                                Intrinsics.checkNotNull(punishmentType);
                                Intrinsics.checkNotNull(reason);
                                Intrinsics.checkNotNull(name);
                                Intrinsics.checkNotNull(operator);
                                PunishmentData punishment = new PunishmentData(id, uuid, punishmentType, reason, start, end, name, operator);
                                bannedPlayers.add(punishment);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block33;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to get banned players: " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().err("Unsupported database type: " + this.dbType);
            }
        }
        return bannedPlayers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PunishmentData> getHistoryBannedPlayers(int limit, int offset) {
        List bannedPlayers;
        block33: {
            bannedPlayers = new ArrayList();
            try {
                block34: {
                    Connection connection = this.getConnection();
                    if (connection == null) break block34;
                    AutoCloseable autoCloseable = connection;
                    Throwable throwable = null;
                    try {
                        Connection conn = (Connection)autoCloseable;
                        boolean bl = false;
                        this.logger.debug("Database connection established from getHistoryBannedPlayers");
                        String string = this.dbType.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                        boolean supportsOrderAndLimit = switch (string) {
                            case "mariadb", "postgresql", "sqlite", "mysql" -> true;
                            case "h2" -> false;
                            default -> false;
                        };
                        String query = supportsOrderAndLimit ? "SELECT * FROM punishments \nWHERE punishmentType IN ('BAN', 'BANIP') \nORDER BY start DESC \nLIMIT ? OFFSET ?" : "SELECT * FROM punishments \nWHERE punishmentType IN ('BAN', 'BANIP')";
                        AutoCloseable autoCloseable2 = conn.prepareStatement(query);
                        Throwable throwable2 = null;
                        try {
                            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                            boolean bl2 = false;
                            if (supportsOrderAndLimit) {
                                preparedStatement.setInt(1, limit);
                                preparedStatement.setInt(2, offset);
                            }
                            ResultSet resultSet = preparedStatement.executeQuery();
                            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
                            ResultSet resultSet2 = resultSet;
                            int skipped = 0;
                            while (resultSet2.next()) {
                                if (!supportsOrderAndLimit && skipped < offset) {
                                    ++skipped;
                                    continue;
                                }
                                if (!supportsOrderAndLimit && bannedPlayers.size() >= limit) break;
                                int id = resultSet2.getInt("id");
                                String name = resultSet2.getString("name");
                                String uuid = resultSet2.getString("uuid");
                                String reason = resultSet2.getString("reason");
                                String operator = resultSet2.getString("operator");
                                String punishmentType = resultSet2.getString("punishmentType");
                                long start = resultSet2.getLong("start");
                                long end = resultSet2.getLong("endTime");
                                Intrinsics.checkNotNull(uuid);
                                Intrinsics.checkNotNull(punishmentType);
                                Intrinsics.checkNotNull(reason);
                                Intrinsics.checkNotNull(name);
                                Intrinsics.checkNotNull(operator);
                                PunishmentData punishment = new PunishmentData(id, uuid, punishmentType, reason, start, end, name, operator);
                                bannedPlayers.add(punishment);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block33;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
                throw new SQLException("No connection available");
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to get banned players: " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().err("Unsupported database type: " + this.dbType);
            }
        }
        return bannedPlayers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportDatabase() {
        block17: {
            String[] stringArray = new String[]{"punishments", "punishmenthistory"};
            List<String> tables = CollectionsKt.listOf(stringArray);
            try {
                Connection connection = this.getConnection();
                if (connection == null) break block17;
                AutoCloseable autoCloseable = connection;
                Throwable throwable = null;
                try {
                    Connection conn = (Connection)autoCloseable;
                    boolean bl = false;
                    File dumpDir = new File(this.plugin.getDataFolder(), "dump");
                    if (!dumpDir.exists()) {
                        dumpDir.mkdirs();
                    }
                    File file = new File(dumpDir, "backup.sql");
                    Charset charset = Charsets.UTF_8;
                    int n = 8192;
                    Object object = file;
                    BufferedWriter writer = (object = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset)) instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
                    for (String table : tables) {
                        ResultSet resultSet = conn.createStatement().executeQuery("SELECT * FROM " + table);
                        ResultSetMetaData metaData = resultSet.getMetaData();
                        int columnCount = metaData.getColumnCount();
                        if (!resultSet.isBeforeFirst()) continue;
                        writer.write("INSERT INTO " + table + " VALUES\n");
                        boolean first = true;
                        while (resultSet.next()) {
                            if (!first) {
                                writer.write(",\n");
                            }
                            first = false;
                            writer.write("(");
                            int i = 1;
                            if (i <= columnCount) {
                                while (true) {
                                    Object value;
                                    if ((value = resultSet.getObject(i)) == null) {
                                        writer.write("NULL");
                                    } else {
                                        writer.write("'" + StringsKt.replace$default(value.toString(), "'", "''", false, 4, null) + "'");
                                    }
                                    if (i < columnCount) {
                                        writer.write(", ");
                                    }
                                    if (i == columnCount) break;
                                    ++i;
                                }
                            }
                            writer.write(")");
                        }
                        writer.write(";\n");
                    }
                    writer.close();
                    this.plugin.getLogger().success("Database exported to " + dumpDir + "/backup.sql");
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to export database. " + e.getMessage());
            }
            catch (IOException e) {
                this.plugin.getLogger().err("Failed to write to file. " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importDatabase() {
        block9: {
            String filePath = new File(this.plugin.getDataFolder(), "dump/backup.sql").getAbsolutePath();
            try {
                Connection connection = this.getConnection();
                if (connection == null) break block9;
                AutoCloseable autoCloseable = connection;
                Throwable throwable = null;
                try {
                    Connection conn = (Connection)autoCloseable;
                    boolean bl = false;
                    List lines = FilesKt.readLines$default(new File(filePath), null, 1, null);
                    Statement statement = conn.createStatement();
                    StringBuilder sql = new StringBuilder();
                    for (String line : lines) {
                        sql.append(line);
                        if (!StringsKt.endsWith$default(((Object)StringsKt.trim((CharSequence)line)).toString(), ";", false, 2, null)) continue;
                        statement.execute(sql.toString());
                        sql.setLength(0);
                    }
                    this.plugin.getLogger().success("Database imported from " + filePath);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().err("Failed to import database. " + e.getMessage());
            }
            catch (IOException e) {
                this.plugin.getLogger().err("Failed to read from file. " + e.getMessage());
            }
        }
    }
}

