/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.punisher.loader;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.punisher.PunisherX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lpl/syntaxdevteam/punisher/loader/VersionChecker;", "", "plugin", "Lpl/syntaxdevteam/punisher/PunisherX;", "<init>", "(Lpl/syntaxdevteam/punisher/PunisherX;)V", "getRawVersion", "", "getServerVersion", "isSupported", "", "checkAndLog", "Companion", "PunisherX"})
public final class VersionChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PunisherX plugin;
    @NotNull
    private static final Set<String> SUPPORTED_VERSIONS;

    public VersionChecker(@NotNull PunisherX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    private final String getRawVersion() {
        String string = Bukkit.getServer().getBukkitVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getBukkitVersion(...)");
        return string;
    }

    @NotNull
    public final String getServerVersion() {
        return StringsKt.substringBefore$default(this.getRawVersion(), "-", null, 2, null);
    }

    public final boolean isSupported() {
        return SUPPORTED_VERSIONS.contains(this.getServerVersion());
    }

    public final boolean checkAndLog() {
        boolean bl;
        String version = this.getServerVersion();
        if (this.isSupported()) {
            this.plugin.getLogger().success("The server is running on a supported version " + version + ".");
            bl = true;
        } else {
            this.plugin.getLogger().warning("Warning! Unsupported version " + version + " \u2013 use with caution!");
            bl = false;
        }
        return bl;
    }

    static {
        String[] stringArray = new String[]{"1.20.6", "1.21", "1.21.1", "1.21.2", "1.21.3", "1.21.4", "1.21.5"};
        SUPPORTED_VERSIONS = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lpl/syntaxdevteam/punisher/loader/VersionChecker$Companion;", "", "<init>", "()V", "SUPPORTED_VERSIONS", "", "", "PunisherX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

