/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.dragoninvsync.Func;

import com.google.common.collect.Iterables;
import de.dragon99z.dragoninvsync.Func.NbtFunc;
import de.dragon99z.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_167;
import net.minecraft.class_1799;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;

public class PlayerHash {
    private static final String AIR_CONSTANT = "{air}";

    public static String[] playerInventoryToBase64(class_1661 playerInventory) throws IllegalStateException {
        String content = PlayerHash.toBase64((class_3222)playerInventory.field_7546, (class_1263)playerInventory);
        class_1799[] itemStacks = new class_1799[playerInventory.field_7548.size()];
        for (int i = 0; i < playerInventory.field_7548.size(); ++i) {
            itemStacks[i] = playerInventory.method_7372(i);
        }
        String armor = PlayerHash.itemStackArrayToBase64((class_3222)playerInventory.field_7546, itemStacks);
        return new String[]{content, armor};
    }

    public static String itemStackArrayToBase64(class_3222 p, class_1799[] items) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream dataOutput = new ObjectOutputStream(outputStream);
            MinecraftServer server = p.field_13995;
            class_5455.class_6890 registries = server.method_30611();
            dataOutput.writeInt(items.length);
            for (class_1799 stack : items) {
                if (!stack.method_7960()) {
                    class_2520 nbt = NbtFunc.getNbtFromItemStack(stack, (class_7225.class_7874)registries);
                    String nbtString = nbt.toString();
                    dataOutput.writeUTF(nbtString);
                    continue;
                }
                dataOutput.writeUTF(AIR_CONSTANT);
            }
            dataOutput.close();
            return Base64Coder.encodeLines(outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks. Error: " + e.getMessage(), e);
        }
    }

    public static String toBase64(class_3222 p, class_1263 inventory) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream dataOutput = new ObjectOutputStream(outputStream);
            MinecraftServer server = p.field_13995;
            class_5455.class_6890 registries = server.method_30611();
            dataOutput.writeInt(inventory.method_5439());
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (!stack.method_7960()) {
                    class_2520 nbt = NbtFunc.getNbtFromItemStack(stack, (class_7225.class_7874)registries);
                    String nbtString = nbt.toString();
                    dataOutput.writeUTF(nbtString);
                    continue;
                }
                dataOutput.writeUTF(AIR_CONSTANT);
            }
            dataOutput.close();
            return Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static String advancementToBase64(class_3222 p) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream dataOutput = new ObjectOutputStream(outputStream);
            for (class_8779 advancement : p.field_13995.method_3851().method_12893()) {
                class_167 progress = p.method_14236().method_12882(advancement);
                dataOutput.writeBoolean(progress.method_740());
            }
            dataOutput.close();
            return Base64Coder.encodeLines(outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static class_1263 fromBase64(class_3222 p, String data) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines(data));
        ObjectInputStream dataInput = new ObjectInputStream(inputStream);
        class_1277 inventory = new class_1277(dataInput.readInt());
        MinecraftServer server = p.field_13995;
        class_5455.class_6890 registries = server.method_30611();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            String nbtString = dataInput.readUTF();
            if (Objects.equals(nbtString, AIR_CONSTANT)) {
                inventory.method_5447(i, class_1799.field_8037);
                continue;
            }
            class_2520 nbt = NbtFunc.stringToNbtElement(nbtString);
            Optional opStack = class_1799.method_57360((class_7225.class_7874)registries, (class_2520)nbt);
            if (!opStack.isPresent()) continue;
            inventory.method_5447(i, (class_1799)opStack.get());
        }
        dataInput.close();
        return inventory;
    }

    public static void advancementFromBase64(class_3222 p, String data) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines(data));
        ObjectInputStream dataInput = new ObjectInputStream(inputStream);
        for (int i = 0; i < p.field_13995.method_3851().method_12893().size(); ++i) {
            boolean done = dataInput.readBoolean();
            class_8779 advancementEntry = (class_8779)Iterables.get((Iterable)p.field_13995.method_3851().method_12893(), (int)i);
            for (String criteriaName : advancementEntry.comp_1920().comp_1915().keySet()) {
                if (done) {
                    p.method_14236().method_12878(advancementEntry, criteriaName);
                    continue;
                }
                p.method_14236().method_12883(advancementEntry, criteriaName);
            }
        }
        p.method_14236().method_12876(p);
        dataInput.close();
    }

    public static class_1799[] itemStackArrayFromBase64(class_3222 p, String data) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines(data));
        ObjectInputStream dataInput = new ObjectInputStream(inputStream);
        class_1799[] items = new class_1799[dataInput.readInt()];
        MinecraftServer server = p.field_13995;
        class_5455.class_6890 registries = server.method_30611();
        for (int i = 0; i < items.length; ++i) {
            String nbtString = dataInput.readUTF();
            if (Objects.equals(nbtString, AIR_CONSTANT)) {
                items[i] = class_1799.field_8037;
                continue;
            }
            class_2520 nbt = NbtFunc.stringToNbtElement(nbtString);
            Optional opStack = class_1799.method_57360((class_7225.class_7874)registries, (class_2520)nbt);
            if (!opStack.isPresent()) continue;
            items[i] = (class_1799)opStack.get();
        }
        dataInput.close();
        return items;
    }
}

