/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.mysql.cj.jdbc;

import de.dragon99z.mysql.cj.exceptions.CJException;
import de.dragon99z.mysql.cj.jdbc.JdbcConnection;
import de.dragon99z.mysql.cj.jdbc.MysqlDataSource;
import de.dragon99z.mysql.cj.jdbc.MysqlPooledConnection;
import de.dragon99z.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class MysqlConnectionPoolDataSource
extends MysqlDataSource
implements ConnectionPoolDataSource {
    static final long serialVersionUID = -7767325445592304961L;

    @Override
    public synchronized PooledConnection getPooledConnection() throws SQLException {
        try {
            Connection connection = this.getConnection();
            MysqlPooledConnection mysqlPooledConnection = MysqlPooledConnection.getInstance((JdbcConnection)connection);
            return mysqlPooledConnection;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public synchronized PooledConnection getPooledConnection(String u, String p) throws SQLException {
        try {
            Connection connection = this.getConnection(u, p);
            MysqlPooledConnection mysqlPooledConnection = MysqlPooledConnection.getInstance((JdbcConnection)connection);
            return mysqlPooledConnection;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }
}

