/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.mysql.cj.jdbc.ha;

import de.dragon99z.mysql.cj.jdbc.ConnectionImpl;
import de.dragon99z.mysql.cj.jdbc.JdbcConnection;
import de.dragon99z.mysql.cj.jdbc.ha.LoadBalancedConnectionProxy;
import de.dragon99z.mysql.cj.jdbc.ha.RandomBalanceStrategy;
import de.dragon99z.mysql.cj.util.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class ServerAffinityStrategy
extends RandomBalanceStrategy {
    public String[] affinityOrderedServers = null;

    public ServerAffinityStrategy(String affinityOrdervers) {
        if (!StringUtils.isNullOrEmpty(affinityOrdervers)) {
            this.affinityOrderedServers = affinityOrdervers.split(",");
        }
    }

    @Override
    public ConnectionImpl pickConnection(InvocationHandler proxy, List<String> configuredHosts, Map<String, JdbcConnection> liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        if (this.affinityOrderedServers == null) {
            return super.pickConnection(proxy, (List)configuredHosts, (Map)liveConnections, responseTimes, numRetries);
        }
        Map<String, Long> blockList = ((LoadBalancedConnectionProxy)proxy).getGlobalBlocklist();
        for (String host : this.affinityOrderedServers) {
            if (!configuredHosts.contains(host) || blockList.containsKey(host)) continue;
            ConnectionImpl conn = (ConnectionImpl)liveConnections.get(host);
            if (conn != null) {
                return conn;
            }
            try {
                conn = ((LoadBalancedConnectionProxy)proxy).createConnectionForHost(host);
                return conn;
            }
            catch (SQLException sqlEx) {
                if (!((LoadBalancedConnectionProxy)proxy).shouldExceptionTriggerConnectionSwitch(sqlEx)) continue;
                ((LoadBalancedConnectionProxy)proxy).addToGlobalBlocklist(host);
            }
        }
        return super.pickConnection(proxy, (List)configuredHosts, (Map)liveConnections, responseTimes, numRetries);
    }
}

