/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.mysql.cj.otel;

import de.dragon99z.mysql.cj.Messages;
import de.dragon99z.mysql.cj.exceptions.ExceptionFactory;
import de.dragon99z.mysql.cj.otel.OpenTelemetrySpan;
import de.dragon99z.mysql.cj.telemetry.TelemetryHandler;
import de.dragon99z.mysql.cj.telemetry.TelemetrySpan;
import de.dragon99z.mysql.cj.telemetry.TelemetrySpanName;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;

public class OpenTelemetryHandler
implements TelemetryHandler {
    private static boolean otelApiAvaliable = true;
    private OpenTelemetry openTelemetry = null;
    private Tracer tracer = null;
    private WeakHashMap<TelemetrySpan, Span> spans = new WeakHashMap();
    private List<Span> linkTargets = new ArrayList<Span>();

    public static boolean isOpenTelemetryApiAvailable() {
        return otelApiAvaliable;
    }

    public OpenTelemetryHandler() {
        if (!OpenTelemetryHandler.isOpenTelemetryApiAvailable()) {
            throw ExceptionFactory.createException(Messages.getString("Connection.OtelApiNotFound"));
        }
        this.openTelemetry = GlobalOpenTelemetry.get();
        this.tracer = this.openTelemetry.getTracer("MySQL Connector/J", "8.4.0");
    }

    @Override
    public TelemetrySpan startSpan(TelemetrySpanName spanName, Object ... args) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName.getName(args)).setSpanKind(SpanKind.CLIENT);
        this.linkTargets.stream().map(Span::getSpanContext).forEach(arg_0 -> ((SpanBuilder)spanBuilder).addLink(arg_0));
        Span otelSpan = spanBuilder.startSpan();
        OpenTelemetrySpan span = new OpenTelemetrySpan(otelSpan);
        this.spans.put(span, otelSpan);
        return span;
    }

    @Override
    public void addLinkTarget(TelemetrySpan span) {
        Span otelSpan = this.spans.get(span);
        if (otelSpan != null) {
            this.linkTargets.add(otelSpan);
        }
    }

    @Override
    public void removeLinkTarget(TelemetrySpan span) {
        Span otelSpan = this.spans.get(span);
        if (otelSpan != null) {
            this.linkTargets.remove(otelSpan);
        }
    }

    @Override
    public void propagateContext(BiConsumer<String, String> traceparentConsumer) {
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), traceparentConsumer, (carrier, key, value) -> carrier.accept(key, value));
    }

    static {
        try {
            Class.forName("io.opentelemetry.api.GlobalOpenTelemetry");
        }
        catch (ClassNotFoundException e) {
            otelApiAvaliable = false;
        }
    }
}

