/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.mysql.cj.protocol.a;

import de.dragon99z.mysql.cj.BindValue;
import de.dragon99z.mysql.cj.conf.PropertyKey;
import de.dragon99z.mysql.cj.exceptions.CJOperationNotSupportedException;
import de.dragon99z.mysql.cj.exceptions.ExceptionFactory;
import de.dragon99z.mysql.cj.exceptions.WrongArgumentException;
import de.dragon99z.mysql.cj.protocol.Message;
import de.dragon99z.mysql.cj.protocol.a.AbstractValueEncoder;
import de.dragon99z.mysql.cj.util.StringUtils;
import de.dragon99z.mysql.cj.util.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class ReaderValueEncoder
extends AbstractValueEncoder {
    @Override
    public byte[] getBytes(BindValue binding) {
        return this.readBytes((Reader)binding.getValue(), binding);
    }

    @Override
    public String getString(BindValue binding) {
        return "'** STREAM DATA **'";
    }

    @Override
    public void encodeAsBinary(Message msg, BindValue binding) {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    protected byte[] readBytes(Reader reader, BindValue binding) {
        try {
            byte[] bytes;
            String clobEncoding;
            char[] c = null;
            int len = 0;
            boolean useLength = this.propertySet.getBooleanProperty(PropertyKey.useStreamLengthsInPrepStmts).getValue();
            String string = clobEncoding = binding.isNational() ? null : this.propertySet.getStringProperty(PropertyKey.clobCharacterEncoding).getStringValue();
            if (clobEncoding == null) {
                clobEncoding = this.charEncoding.getStringValue();
            }
            long scaleOrLength = binding.getScaleOrLength();
            if (useLength && scaleOrLength != -1L) {
                c = new char[(int)scaleOrLength];
                int numCharsRead = Util.readFully(reader, c, (int)scaleOrLength);
                bytes = StringUtils.getBytes(new String(c, 0, numCharsRead), clobEncoding);
            } else {
                c = new char[4096];
                StringBuilder buf = new StringBuilder();
                while ((len = reader.read(c)) != -1) {
                    buf.append(c, 0, len);
                }
                bytes = StringUtils.getBytes(buf.toString(), clobEncoding);
            }
            return this.escapeBytesIfNeeded(bytes);
        }
        catch (UnsupportedEncodingException uec) {
            throw ExceptionFactory.createException(WrongArgumentException.class, uec.toString(), uec, this.exceptionInterceptor);
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createException(ioEx.toString(), ioEx, this.exceptionInterceptor);
        }
    }
}

