/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.mysql.cj.result;

import de.dragon99z.mysql.cj.Messages;
import de.dragon99z.mysql.cj.WarningListener;
import de.dragon99z.mysql.cj.conf.PropertySet;
import de.dragon99z.mysql.cj.exceptions.DataReadException;
import de.dragon99z.mysql.cj.protocol.InternalDate;
import de.dragon99z.mysql.cj.protocol.InternalTime;
import de.dragon99z.mysql.cj.protocol.InternalTimestamp;
import de.dragon99z.mysql.cj.result.AbstractDateTimeValueFactory;
import java.time.LocalDate;

public class LocalDateValueFactory
extends AbstractDateTimeValueFactory<LocalDate> {
    private WarningListener warningListener;

    public LocalDateValueFactory(PropertySet pset) {
        super(pset);
    }

    public LocalDateValueFactory(PropertySet pset, WarningListener warningListener) {
        this(pset);
        this.warningListener = warningListener;
    }

    @Override
    public LocalDate localCreateFromDate(InternalDate idate) {
        if (idate.getYear() == 0 && idate.getMonth() == 0 && idate.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        return LocalDate.of(idate.getYear(), idate.getMonth(), idate.getDay());
    }

    @Override
    public LocalDate localCreateFromTimestamp(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return (LocalDate)this.createFromDate(its);
    }

    @Override
    public LocalDate localCreateFromDatetime(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return (LocalDate)this.createFromDate(its);
    }

    @Override
    LocalDate localCreateFromTime(InternalTime it) {
        return LocalDate.of(1970, 1, 1);
    }

    @Override
    public String getTargetTypeName() {
        return LocalDate.class.getName();
    }
}

