/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.dragoninvsync;

import de.dragon99z.dragoninvsync.Events.onPlayerJoinEvent;
import de.dragon99z.dragoninvsync.Events.onPlayerLeaveEvent;
import de.dragon99z.dragoninvsync.Events.onServerStoppingEvent;
import de.dragon99z.dragoninvsync.Func.MyConfig;
import de.dragon99z.dragoninvsync.Func.MySQL;
import de.dragon99z.fasterxml.jackson.dataformat.toml.TomlMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragonInvSync
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"DragonInvSync");
    public static MyConfig config = new MyConfig();

    public static void connectMySQL() {
        if (!MySQL.hasConnection()) {
            MySQL.connect();
        }
        if (MySQL.hasConnection()) {
            try {
                Statement st = MySQL.con.createStatement();
                String createTableQuery = "CREATE TABLE IF NOT EXISTS `" + DragonInvSync.config.database.name + "`.`PlayerSync`  (  `UUID` varchar(255) NOT NULL, `Inventory` text NULL, `Armor` text NULL, `Health` double NULL, `Hunger` int NULL, `Saturation` float NULL, `GameMode` text NULL, `XP` float NULL, `LVL` int NULL, `EChest` text NULL, `Advancement` text NULL, PRIMARY KEY (`UUID`));";
                st.execute(createTableQuery);
            }
            catch (SQLException e) {
                LOGGER.error(e.toString());
            }
        }
    }

    public void onInitialize() {
        Path configDir = Path.of(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/DragonInvSync", new String[0]);
        configDir.toFile().mkdirs();
        try {
            File configFile = new File(String.valueOf(configDir) + "/config.toml");
            if (!configFile.exists()) {
                String data = new String(Objects.requireNonNull(DragonInvSync.class.getResourceAsStream("/config.toml")).readAllBytes());
                Files.write(configFile.toPath(), data.getBytes(), new OpenOption[0]);
            }
            TomlMapper mapper = new TomlMapper();
            config = mapper.readValue(configFile, MyConfig.class);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
        if (DragonInvSync.config.database.type.equalsIgnoreCase("MYSQL") && !config.validateMySQL()) {
            LOGGER.error("Invalid config - Stopping");
            System.exit(1);
        }
        DragonInvSync.connectMySQL();
        try {
            MySQL.validate("PlayerSync");
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
        }
        this.registerEvents();
    }

    public void registerEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> new onPlayerJoinEvent(handler.method_32311()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> new onPlayerLeaveEvent(handler.method_32311()));
        ServerLifecycleEvents.SERVER_STOPPING.register((Object)new onServerStoppingEvent());
    }
}

