/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.dragoninvsync.Func;

import de.dragon99z.dragoninvsync.DragonInvSync;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MySQL {
    public static Connection con;

    public static void connect() {
        if (!DragonInvSync.config.validateMySQL()) {
            DragonInvSync.LOGGER.error("Invalid MySQL configuration - Stopping");
            return;
        }
        String url = String.format("jdbc:mysql://%s:%d/%s?useUnicode=true&characterEncoding=utf8&useSSL=false&autoReconnect=true", DragonInvSync.config.mysql.address, DragonInvSync.config.mysql.port, DragonInvSync.config.database.name);
        try {
            Class.forName("de.dragon99z.mysql.cj.jdbc.Driver");
            con = DriverManager.getConnection(url, DragonInvSync.config.mysql.username, DragonInvSync.config.mysql.password);
            DragonInvSync.LOGGER.info("MySQL connected!");
        }
        catch (Exception e) {
            DragonInvSync.LOGGER.error("Could not connect to MySQL{}", DragonInvSync.config.mysql.debug ? ": " + String.valueOf(e) : "!");
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void disconnect() {
        try {
            DragonInvSync.LOGGER.debug("Closing MySQL connection...");
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            DragonInvSync.LOGGER.error("Error while disconnecting from MySQL: {}", (Throwable)e);
        }
        finally {
            con = null;
        }
    }

    public static synchronized boolean hasConnection() {
        DragonInvSync.LOGGER.debug("Connection status: {}", (Object)(con != null ? "Connected" : "Disconnected"));
        try {
            return con != null && !con.isClosed();
        }
        catch (SQLException e) {
            DragonInvSync.LOGGER.error("Error while checking connection status: {}", (Throwable)e);
            return false;
        }
    }

    public static void validate(String table) throws SQLException {
        if (!MySQL.hasConnection()) {
            return;
        }
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("SELECT * FROM " + table);){
            rs.next();
        }
    }
}

