/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.fasterxml.jackson.databind.ser.std;

import de.dragon99z.fasterxml.jackson.core.JsonGenerator;
import de.dragon99z.fasterxml.jackson.core.JsonToken;
import de.dragon99z.fasterxml.jackson.core.type.WritableTypeId;
import de.dragon99z.fasterxml.jackson.databind.JavaType;
import de.dragon99z.fasterxml.jackson.databind.JsonMappingException;
import de.dragon99z.fasterxml.jackson.databind.JsonNode;
import de.dragon99z.fasterxml.jackson.databind.SerializerProvider;
import de.dragon99z.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import de.dragon99z.fasterxml.jackson.databind.jsontype.TypeSerializer;
import de.dragon99z.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public abstract class ToStringSerializerBase
extends StdSerializer<Object> {
    public ToStringSerializerBase(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        return this.valueToString(value).isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this.valueToString(value));
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }

    public abstract String valueToString(Object var1);
}

