/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.mysql.cj;

import de.dragon99z.mysql.cj.CoreSession;
import de.dragon99z.mysql.cj.QueryResult;
import de.dragon99z.mysql.cj.conf.HostInfo;
import de.dragon99z.mysql.cj.conf.PropertySet;
import de.dragon99z.mysql.cj.exceptions.CJCommunicationsException;
import de.dragon99z.mysql.cj.protocol.ColumnDefinition;
import de.dragon99z.mysql.cj.protocol.Message;
import de.dragon99z.mysql.cj.protocol.ResultBuilder;
import de.dragon99z.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import de.dragon99z.mysql.cj.protocol.x.XProtocol;
import de.dragon99z.mysql.cj.protocol.x.XProtocolError;
import de.dragon99z.mysql.cj.protocol.x.XProtocolRowInputStream;
import de.dragon99z.mysql.cj.result.Row;
import de.dragon99z.mysql.cj.xdevapi.PreparableStatement;
import java.io.IOException;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MysqlxSession
extends CoreSession {
    public MysqlxSession(HostInfo hostInfo, PropertySet propSet) {
        super(hostInfo, propSet);
        this.protocol = new XProtocol(hostInfo, propSet);
        this.messageBuilder = this.protocol.getMessageBuilder();
        this.protocol.connect(hostInfo.getUser(), hostInfo.getPassword(), hostInfo.getDatabase());
    }

    public MysqlxSession(XProtocol prot) {
        super(null, prot.getPropertySet());
        this.protocol = prot;
        this.messageBuilder = this.protocol.getMessageBuilder();
    }

    @Override
    public String getProcessHost() {
        return this.protocol.getSocketConnection().getHost();
    }

    public int getPort() {
        return this.protocol.getSocketConnection().getPort();
    }

    public XProtocol getProtocol() {
        return (XProtocol)this.protocol;
    }

    @Override
    public void quit() {
        try {
            this.protocol.close();
        }
        catch (IOException ex) {
            throw new CJCommunicationsException(ex);
        }
        super.quit();
    }

    @Override
    public boolean isClosed() {
        return !((XProtocol)this.protocol).isOpen();
    }

    public boolean supportsPreparedStatements() {
        return ((XProtocol)this.protocol).supportsPreparedStatements();
    }

    public boolean readyForPreparingStatements() {
        return ((XProtocol)this.protocol).readyForPreparingStatements();
    }

    public int getNewPreparedStatementId(PreparableStatement<?> preparableStatement) {
        return ((XProtocol)this.protocol).getNewPreparedStatementId(preparableStatement);
    }

    public void freePreparedStatementId(int preparedStatementId) {
        ((XProtocol)this.protocol).freePreparedStatementId(preparedStatementId);
    }

    public boolean failedPreparingStatement(int preparedStatementId, XProtocolError e) {
        return ((XProtocol)this.protocol).failedPreparingStatement(preparedStatementId, e);
    }

    @Override
    public <M extends Message, R, RES> RES query(M message, Predicate<Row> rowFilter, Function<Row, R> rowMapper, Collector<R, ?, RES> collector) {
        this.protocol.send(message, 0);
        ColumnDefinition metadata = this.protocol.readMetadata();
        XProtocolRowInputStream ris = new XProtocolRowInputStream(metadata, (XProtocol)this.protocol, null);
        Stream<Row> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ris, 0), false);
        if (rowFilter != null) {
            stream = stream.filter(rowFilter);
        }
        RES result = stream.map(rowMapper).collect(collector);
        this.protocol.readQueryResult(new StatementExecuteOkBuilder());
        return result;
    }

    @Override
    public <M extends Message, R extends QueryResult> R query(M message, ResultBuilder<R> resultBuilder) {
        return ((XProtocol)this.protocol).query(message, resultBuilder);
    }

    @Override
    public <M extends Message, R extends QueryResult> CompletableFuture<R> queryAsync(M message, ResultBuilder<R> resultBuilder) {
        return ((XProtocol)this.protocol).queryAsync(message, resultBuilder);
    }
}

