/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.mysql.cj.conf;

import de.dragon99z.mysql.cj.conf.AbstractRuntimeProperty;
import de.dragon99z.mysql.cj.conf.PropertyDefinition;
import de.dragon99z.mysql.cj.exceptions.ExceptionFactory;
import de.dragon99z.mysql.cj.exceptions.ExceptionInterceptor;
import de.dragon99z.mysql.cj.exceptions.WrongArgumentException;

public class IntegerProperty
extends AbstractRuntimeProperty<Integer> {
    private static final long serialVersionUID = 9208223182595760858L;

    public IntegerProperty(PropertyDefinition<Integer> propertyDefinition) {
        super(propertyDefinition);
    }

    @Override
    protected void checkRange(Integer val, String valueAsString, ExceptionInterceptor exceptionInterceptor) {
        if (val < this.getPropertyDefinition().getLowerBound() || val > this.getPropertyDefinition().getUpperBound()) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "The connection property '" + this.getPropertyDefinition().getName() + "' only accepts integer values in the range of " + this.getPropertyDefinition().getLowerBound() + " - " + this.getPropertyDefinition().getUpperBound() + ", the value '" + (valueAsString == null ? Integer.valueOf(val) : valueAsString) + "' exceeds this range.", exceptionInterceptor);
        }
    }
}

