/*
 * Decompiled with CFR 0.152.
 */
package de.dragon99z.mysql.cj.log;

import de.dragon99z.mysql.cj.exceptions.CJException;
import de.dragon99z.mysql.cj.exceptions.ExceptionFactory;
import de.dragon99z.mysql.cj.exceptions.WrongArgumentException;
import de.dragon99z.mysql.cj.log.Log;
import de.dragon99z.mysql.cj.util.Util;

public class LogFactory {
    public static Log getLogger(String className, String instanceName) {
        if (className == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "Logger class can not be NULL");
        }
        if (instanceName == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "Logger instance name can not be NULL");
        }
        try {
            return Util.getInstance(Log.class, className, new Class[]{String.class}, new Object[]{instanceName}, null);
        }
        catch (CJException e1) {
            if (ClassNotFoundException.class.isInstance(e1.getCause())) {
                try {
                    return Util.getInstance(Log.class, Util.getPackageName(LogFactory.class) + "." + className, new Class[]{String.class}, new Object[]{instanceName}, null);
                }
                catch (CJException e2) {
                    throw e1;
                }
            }
            throw e1;
        }
    }
}

