/*
 * Decompiled with CFR 0.152.
 */
package com.g2806.PlayerMount;

import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PlayerMountPlugin
extends JavaPlugin
implements Listener {
    private final HashMap<UUID, Integer> sneakCount = new HashMap();
    private final HashMap<UUID, BossBar> riderBossBars = new HashMap();
    private final HashMap<UUID, Long> messageCooldown = new HashMap();
    private FileConfiguration config;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.config = this.getConfig();
    }

    public void onDisable() {
        this.saveConfig();
        this.riderBossBars.values().forEach(BossBar::removeAll);
        this.riderBossBars.clear();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Player player;
        block10: {
            block9: {
                if (!(sender instanceof Player)) break block9;
                player = (Player)sender;
                if (args.length == 1) break block10;
            }
            return false;
        }
        boolean value = args[0].equalsIgnoreCase("true");
        if (command.getName().equalsIgnoreCase("playermount")) {
            this.config.set(String.valueOf(player.getUniqueId()) + ".allowMount", (Object)value);
            this.saveConfig();
            player.sendMessage("Mounting preference set to: " + value);
        } else if (command.getName().equalsIgnoreCase("playermountbossbar")) {
            BossBar bossBar;
            this.config.set(String.valueOf(player.getUniqueId()) + ".bossbar", (Object)value);
            this.saveConfig();
            player.sendMessage("Boss bar visibility set to: " + value);
            if (!value && (bossBar = this.riderBossBars.get(player.getUniqueId())) != null) {
                bossBar.removePlayer(player);
            }
        } else {
            return false;
        }
        return true;
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player rider = event.getPlayer();
        UUID riderId = rider.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.messageCooldown.containsKey(riderId) && currentTime - this.messageCooldown.get(riderId) < 1000L) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (entity instanceof Player) {
            Player mount = (Player)entity;
            if (!this.config.getBoolean(String.valueOf(mount.getUniqueId()) + ".allowMount", true)) {
                rider.sendMessage(mount.getName() + " has disabled mounting.");
                this.messageCooldown.put(riderId, currentTime);
                return;
            }
            if (mount.addPassenger((Entity)rider)) {
                rider.sendMessage("Now riding " + mount.getName());
                mount.sendMessage(rider.getName() + " is now riding you");
                this.messageCooldown.put(riderId, currentTime);
                if (this.config.getBoolean(String.valueOf(rider.getUniqueId()) + ".bossbar", false)) {
                    BossBar bossBar = Bukkit.createBossBar((String)(mount.getName() + "'s Health"), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                    bossBar.addPlayer(rider);
                    bossBar.setProgress(mount.getHealth() / mount.getAttribute(Attribute.MAX_HEALTH).getValue());
                    this.riderBossBars.put(rider.getUniqueId(), bossBar);
                    this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
                        if (rider.getVehicle() == mount) {
                            bossBar.setProgress(mount.getHealth() / mount.getAttribute(Attribute.MAX_HEALTH).getValue());
                        } else {
                            bossBar.removeAll();
                            this.riderBossBars.remove(rider.getUniqueId());
                        }
                    }, 0L, 10L);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!player.getPassengers().isEmpty()) {
            player.eject();
        }
        this.sneakCount.remove(player.getUniqueId());
        this.messageCooldown.remove(player.getUniqueId());
        BossBar bossBar = this.riderBossBars.remove(player.getUniqueId());
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player mount = event.getPlayer();
        if (!event.isSneaking() || mount.getPassengers().isEmpty() || mount.getLocation().getPitch() > -60.0f) {
            return;
        }
        UUID mountId = mount.getUniqueId();
        int count = this.sneakCount.getOrDefault(mountId, 0) + 1;
        if (count >= 3) {
            mount.eject();
            mount.sendMessage("Dismounted rider!");
            for (Entity rider : mount.getPassengers()) {
                if (!(rider instanceof Player)) continue;
                rider.sendMessage("You were dismounted by " + mount.getName());
                BossBar bossBar = this.riderBossBars.remove(rider.getUniqueId());
                if (bossBar == null) continue;
                bossBar.removeAll();
            }
            this.sneakCount.remove(mountId);
        } else {
            this.sneakCount.put(mountId, count);
            mount.sendActionBar((Component)Component.text((String)("Look up and sneak " + (3 - count) + " more times to dismount rider.")));
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> this.sneakCount.remove(mountId), 60L);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player damager = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof Player) {
                Player target = (Player)entity;
                if (!damager.getPassengers().isEmpty() && damager.getPassengers().contains(target)) {
                    event.setCancelled(true);
                }
            }
        }
    }
}

