/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightquest.KnightQuestCommon;
import dev.xylonity.knightquest.common.entity.entities.EldBombEntity;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EldKnightEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Level serverWorld;
    private boolean summoned = false;
    private int counter;

    public EldKnightEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.serverWorld = world;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 90.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.ATTACK_SPEED, (double)0.4f).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.8f);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        AttributeInstance maxHealth = this.getAttribute(Attributes.MAX_HEALTH);
        if (maxHealth != null) {
            maxHealth.setBaseValue(KQConfigValues.ELDKNIGHT_MAX_HEALTH.get().doubleValue());
            this.setHealth(KQConfigValues.ELDKNIGHT_MAX_HEALTH.get().floatValue());
        }
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.45, false));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate));
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.swinging && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected SoundEvent getSwimSound() {
        return SoundEvents.AXOLOTL_SWIM;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(SoundEvents.IRON_GOLEM_STEP, 0.15f, 1.0f);
    }

    public void tick() {
        super.tick();
        ++this.counter;
        if (!this.summoned && (double)this.getHealth() < (double)this.getMaxHealth() * 0.5) {
            this.summoned = true;
            this.summonMinions();
        }
        if (this.summoned && this.counter > 80) {
            if (KQConfigValues.POISON_ELDKNIGHT.get().booleanValue()) {
                this.summonParticle();
                this.poisonNearbyPlayers();
            }
            if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.75) {
                this.heal(KQConfigValues.HEAL_ELDKNIGHT.get().floatValue());
            }
            this.counter = 0;
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.is(DamageTypes.PLAYER_EXPLOSION) || pSource.is(DamageTypes.EXPLOSION)) {
            return super.hurt(pSource, pAmount * 0.15f);
        }
        if (pSource.is(DamageTypes.ARROW)) {
            return super.hurt(pSource, pAmount * 0.1f);
        }
        return super.hurt(pSource, pAmount);
    }

    private void summonMinions() {
        double distance = 3.0;
        double angle = KQConfigValues.HEAL_ELDKNIGHT.get().floatValue() != 0.0f ? Math.toRadians(360.0 / (double)KQConfigValues.NUM_ELDBOMB_ELDKNIGHT.get().intValue()) : Math.toRadians(120.0);
        boolean punch = false;
        for (int i = 0; i < KQConfigValues.NUM_ELDBOMB_ELDKNIGHT.get(); ++i) {
            double xOffset = distance * Math.cos(angle * (double)i);
            double zOffset = distance * Math.sin(angle * (double)i);
            EldBombEntity entity = (EldBombEntity)KnightQuestEntities.ELDBOMB.get().create(this.serverWorld);
            if (entity == null) continue;
            BlockPos spawnPos = this.blockPosition().offset((int)xOffset, 0, (int)zOffset);
            if (!this.serverWorld.getBlockState(spawnPos).isAir()) {
                int d = 1;
                while ((double)d <= distance) {
                    BlockPos adjustedPos = this.blockPosition().offset((int)(xOffset / (double)d), 0, (int)(zOffset / (double)d));
                    if (this.serverWorld.getBlockState(adjustedPos).isAir()) {
                        spawnPos = adjustedPos;
                        break;
                    }
                    ++d;
                }
            }
            entity.moveTo(spawnPos, 0.0f, 0.0f);
            this.serverWorld.addFreshEntity((Entity)entity);
            for (int j = 0; j < 20; ++j) {
                this.serverWorld.addParticle((ParticleOptions)ParticleTypes.EFFECT, (double)spawnPos.getX() + 0.5 + this.serverWorld.random.nextDouble() - 0.5, (double)spawnPos.getY() + 0.5 + this.serverWorld.random.nextDouble() - 0.5, (double)spawnPos.getZ() + 0.5 + this.serverWorld.random.nextDouble() - 0.5, 0.0, 0.0, 0.0);
            }
            if (punch) continue;
            this.serverWorld.getEntitiesOfClass(Player.class, entity.getBoundingBox().inflate(5.0)).forEach(player -> {
                Vec3 direction = player.position().subtract(this.position()).normalize().scale(1.5);
                player.push(direction.x, direction.y + 0.5, direction.z);
            });
            punch = true;
        }
        int particleCount = 120;
        double particleRadius = 4.0;
        for (int i = 0; i < particleCount; ++i) {
            double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
            double xParticleOffset = particleRadius * Math.cos(angleOffset);
            double zParticleOffset = particleRadius * Math.sin(angleOffset);
            this.serverWorld.addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX() + xParticleOffset, this.getY() - 0.1, this.getZ() + zParticleOffset, 0.0, 0.05, 0.0);
        }
        this.serverWorld.playSound(null, this.blockPosition(), SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void poisonNearbyPlayers() {
        this.serverWorld.getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(3.5)).forEach(player -> player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 1)));
    }

    private void summonParticle() {
        this.serverWorld.addParticle(KnightQuestCommon.COMMON_PLATFORM.getStartsetParticle().get(), this.getX(), this.getY() - 0.48, this.getZ(), 4.0, 0.0, 0.0);
    }
}

