/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xylonity.knightquest.client.entity.model.SamhainModel;
import dev.xylonity.knightquest.common.entity.entities.SamhainEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class SamhainRenderer
extends GeoEntityRenderer<SamhainEntity> {
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;

    public SamhainRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SamhainModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<SamhainEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, SamhainEntity animatable) {
                return switch (bone.getName()) {
                    case "armorBipedLeftFoot", "armorBipedRightFoot" -> this.bootsStack;
                    case "armorBipedLeftLeg", "armorBipedRightLeg" -> this.leggingsStack;
                    case "armorBipedBody", "armorBipedRightArm", "armorBipedLeftArm" -> this.chestplateStack;
                    case "armorBipedHead" -> this.helmetStack;
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, SamhainEntity animatable) {
                return switch (bone.getName()) {
                    case "armorBipedLeftFoot", "armorBipedRightFoot" -> EquipmentSlot.FEET;
                    case "armorBipedLeftLeg", "armorBipedRightLeg" -> EquipmentSlot.LEGS;
                    case "armorBipedRightArm" -> {
                        if (!animatable.m_21526_()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case "armorBipedLeftArm" -> {
                        if (animatable.m_21526_()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case "armorBipedBody" -> EquipmentSlot.CHEST;
                    case "armorBipedHead" -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, SamhainEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case "armorBipedLeftFoot", "armorBipedLeftLeg" -> baseModel.f_102814_;
                    case "armorBipedRightFoot", "armorBipedRightLeg" -> baseModel.f_102813_;
                    case "armorBipedRightArm" -> baseModel.f_102811_;
                    case "armorBipedLeftArm" -> baseModel.f_102812_;
                    case "armorBipedBody" -> baseModel.f_102810_;
                    case "armorBipedHead" -> baseModel.f_102808_;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<SamhainEntity>((GeoRenderer)this){

            protected ItemStack getStackForBone(GeoBone bone, SamhainEntity animatable) {
                return switch (bone.getName()) {
                    case "bipedHandLeft" -> animatable.m_21526_() ? SamhainRenderer.this.mainHandItem : SamhainRenderer.this.offhandItem;
                    case "bipedHandRight" -> animatable.m_21526_() ? SamhainRenderer.this.offhandItem : SamhainRenderer.this.mainHandItem;
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, SamhainEntity animatable) {
                return switch (bone.getName()) {
                    case "bipedHandLeft", "bipedHandRight" -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, SamhainEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                String currentAnimationName;
                AnimationController controller = (AnimationController)animatable.getAnimatableInstanceCache().getManagerForId((long)animatable.m_19879_()).getAnimationControllers().get("controller");
                if (controller != null && controller.getCurrentAnimation() != null && (currentAnimationName = controller.getCurrentAnimation().animation().name()).startsWith("sit")) {
                    return;
                }
                if (stack == SamhainRenderer.this.mainHandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    poseStack.m_85837_(0.05, 0.1, -0.45);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
                } else if (stack == SamhainRenderer.this.offhandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    poseStack.m_85837_(0.05, 0.1, -0.45);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SamhainEntity animatable) {
        return new ResourceLocation("knightquest", "textures/entity/samhain.png");
    }

    public void render(SamhainEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        if (entity.m_6162_()) {
            poseStack.m_85841_(0.35f, 0.35f, 0.35f);
        } else {
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        }
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void preRender(PoseStack poseStack, SamhainEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.mainHandItem = animatable.m_21205_();
        this.offhandItem = animatable.m_21206_();
    }
}

