/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightquest.common.entity.entities.GhastlingEntity;
import dev.xylonity.knightquest.common.entity.entities.ai.NearestAttackableTargetGoal;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestEntities;
import dev.xylonity.knightquest.registry.KnightQuestParticles;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GremlinEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> IS_PASSIVE = SynchedEntityData.m_135353_(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_TAKE_COIN = SynchedEntityData.m_135353_(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GOLD_VARIATION = SynchedEntityData.m_135353_(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(GremlinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int tickCounterShield = 0;
    private int tickCounter = 0;
    private boolean isHalfHealth;

    public GremlinEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        if (!this.m_9236_().m_5776_()) {
            boolean attack1 = new Random().nextBoolean();
            this.f_19804_.m_135381_(ATTACK, (Object)attack1);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_PASSIVE, (Object)false);
        this.f_19804_.m_135372_(SHOULD_TAKE_COIN, (Object)false);
        this.f_19804_.m_135372_(GOLD_VARIATION, (Object)0);
        this.f_19804_.m_135372_(PHASE, (Object)1);
        this.f_19804_.m_135372_(ATTACK, (Object)false);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(KQConfigValues.GREMLIN_MAX_HEALTH);
            this.m_21153_((float)KQConfigValues.GREMLIN_MAX_HEALTH);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean getIsPassive() {
        return (Boolean)this.f_19804_.m_135370_(IS_PASSIVE);
    }

    public boolean getShouldTakeCoin() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_TAKE_COIN);
    }

    public int getGoldVariation() {
        return (Integer)this.f_19804_.m_135370_(GOLD_VARIATION);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public boolean getAttack() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setIsPassive(boolean isPassive) {
        this.f_19804_.m_135381_(IS_PASSIVE, (Object)isPassive);
    }

    public void setShouldTakeCoin(boolean shouldTakeCoin) {
        this.f_19804_.m_135381_(SHOULD_TAKE_COIN, (Object)shouldTakeCoin);
    }

    public void setGoldVariation(int goldVariation) {
        this.f_19804_.m_135381_(GOLD_VARIATION, (Object)goldVariation);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public void setAttack(boolean attack) {
        this.f_19804_.m_135381_(ATTACK, (Object)attack);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22281_, 5.5).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.63f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    private void updateAttributes() {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_(this.m_21133_(Attributes.f_22281_) * (double)KQConfigValues.MULTIPLIER_GREMLIN_ATTACK_DAMAGE);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.m_21133_(Attributes.f_22279_) * (double)KQConfigValues.MULTIPLIER_GREMLIN_MOVEMENT_SPEED);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22283_)).m_22100_(this.m_21133_(Attributes.f_22283_) * (double)KQConfigValues.MULTIPLIER_GREMLIN_ATTACK_SPEED);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new NearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "deadcontroller", 0, this::deadPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "coincontroller", 0, this::coinPredicate)});
    }

    private PlayState coinPredicate(AnimationState<?> event) {
        if (this.getIsPassive() && this.getShouldTakeCoin()) {
            event.getController().forceAnimationReset();
            String goldVariation = this.getGoldVariation() == 0 ? "gold" : "gold2";
            event.getController().setAnimation(RawAnimation.begin().then(goldVariation, Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState deadPredicate(AnimationState<?> event) {
        if (this.m_21224_()) {
            event.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        super.m_8119_();
        if ((double)this.m_21223_() < (double)this.m_21233_() * 0.5) {
            if (!this.isHalfHealth) {
                this.m_9236_().m_7106_((ParticleOptions)KnightQuestParticles.GREMLIN_PARTICLE.get(), this.m_20185_(), this.m_20186_() - 0.48, this.m_20189_(), 2.0, 0.0, 0.0);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11868_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.isHalfHealth = true;
                if (this.getAttack()) {
                    this.spawnShield();
                } else {
                    this.updateAttributes();
                }
                this.setPhase(2);
            }
            if (this.getAttack()) {
                ++this.tickCounterShield;
                if (this.tickCounterShield % 22 == 0 && this.tickCounterShield / 25 <= 1) {
                    this.spawnShield();
                }
            }
        }
        if (this.getIsPassive()) {
            ++this.tickCounter;
            if (this.tickCounter == 1) {
                this.setShouldTakeCoin(true);
            } else if (this.tickCounter == 3) {
                this.setShouldTakeCoin(false);
            } else if (this.tickCounter == 80) {
                this.setIsPassive(false);
                this.setShouldTakeCoin(false);
                this.tickCounter = 0;
            }
        }
    }

    private void spawnShield() {
        GhastlingEntity entity = (GhastlingEntity)((EntityType)KnightQuestEntities.SHIELD.get()).m_20615_(this.m_9236_());
        if (entity != null) {
            entity.m_20035_(this.m_20097_(), 1.0f, 0.0f);
            this.m_9236_().m_7967_((Entity)entity);
        }
    }

    @NotNull
    protected InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        if (KQConfigValues.CAN_TAKE_GOLD_GREMLIN) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            Item goldIngot = Items.f_42417_;
            Item item = itemstack.m_41720_();
            if (item.equals(goldIngot)) {
                pPlayer.m_21211_().m_41774_(1);
                this.m_6710_(null);
                this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
                this.m_6274_().m_21936_(MemoryModuleType.f_26368_);
                this.m_6703_(null);
                this.m_6598_(null);
                this.setGoldVariation(this.m_217043_().m_216339_(0, 2));
                this.setIsPassive(true);
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (this.tickCounter != 0) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected SoundEvent m_5501_() {
        return SoundEvents.f_144067_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12501_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12502_;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }
}

