/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightquest.common.entity.entities.SwampmanAxeEntity;
import dev.xylonity.knightquest.common.entity.entities.ai.RangedAttackGoal;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SwampmanEntity
extends Monster
implements GeoEntity,
RangedAttackMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(SwampmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean isHalfHealth;

    public SwampmanEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.initEquipment();
    }

    protected int m_7305_(int pCurrentAir) {
        return this.m_6062_();
    }

    private void initEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)1);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22283_, 0.5).m_22268_(Attributes.f_22279_, 0.5).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new RangedAttackGoal<SwampmanEntity>(this, 0.7, 10, 15.0f));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(KQConfigValues.SWAMPMAN_MAX_HEALTH);
            this.m_21153_((float)KQConfigValues.SWAMPMAN_MAX_HEALTH);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_6504_(@NotNull LivingEntity pTarget, float pVelocity) {
        SwampmanAxeEntity swampmanAxeEntity = new SwampmanAxeEntity(this.m_9236_(), (LivingEntity)this);
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.34) - swampmanAxeEntity.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        swampmanAxeEntity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.3f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        if (KQConfigValues.POISON_PHASE_2_SWAMPMAN) {
            swampmanAxeEntity.addEffect(new MobEffectInstance(MobEffects.f_19614_, 100, 0, true, true, true));
        }
        this.m_9236_().m_7967_((Entity)swampmanAxeEntity);
    }

    public int m_6062_() {
        return 1000;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate)});
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.m_6117_() && this.m_21205_().m_41720_() instanceof ProjectileWeaponItem) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("bow_attack", Animation.LoopType.PLAY_ONCE));
        } else if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        super.m_8119_();
        if ((double)this.m_21223_() < (double)this.m_21233_() * 0.5 && !this.isHalfHealth && KQConfigValues.CAN_CHANGE_PHASE_SWAMPMAN) {
            this.m_9236_().m_7106_((ParticleOptions)KnightQuestParticles.BLUEBLASTWAVE.get(), this.m_20185_(), this.m_20186_() - 0.48, this.m_20189_(), 2.0, 0.0, 0.0);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11868_, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.isHalfHealth = true;
            this.setPhase(2);
        }
        if (this.getPhase() == 2 && this.f_19797_ % 20 == 0) {
            this.m_5634_(KQConfigValues.PHASE_2_HEALING_SWAMPMAN);
        }
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        if (this.f_20890_) {
            event.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected SoundEvent m_5501_() {
        return SoundEvents.f_144067_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_243972_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_243775_;
    }
}

