/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.platform;

import dev.xylonity.knightlib.registry.KnightLibItems;
import dev.xylonity.knightquest.KnightQuest;
import dev.xylonity.knightquest.client.armor.GeoItemArmor;
import dev.xylonity.knightquest.common.item.ChaoticEssenceItem;
import dev.xylonity.knightquest.common.item.KQArmorItem;
import dev.xylonity.knightquest.common.item.KnightQuestItem;
import dev.xylonity.knightquest.common.item.RadiantEssenceItem;
import dev.xylonity.knightquest.common.material.KQArmorMaterials;
import dev.xylonity.knightquest.common.material.KQItemMaterials;
import dev.xylonity.knightquest.platform.KnightQuestPlatform;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import dev.xylonity.knightquest.registry.KnightQuestWeapons;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KnightQuestForgePlatform
implements KnightQuestPlatform {
    private static final String TOOLTIP_ITEM_PATH = "tooltip.item.knightquest.";

    @Override
    public Supplier<Item> getGreatEssence() {
        return KnightLibItems.GREAT_ESSENCE;
    }

    @Override
    public Supplier<Item> getPaladinSword() {
        return KnightQuestWeapons.PALADIN_SWORD;
    }

    @Override
    public <T extends Item> Supplier<T> registerItem(String id, Supplier<T> item) {
        return KnightQuest.ITEMS.register(id, item);
    }

    @Override
    public <T extends Item> Supplier<T> registerSpecificItem(String id, Item.Properties properties, KnightQuestItems.KQItemType type) {
        if (type == KnightQuestItems.KQItemType.CHAOTIC_ESSENCE) {
            return this.registerItem(id, () -> new ChaoticEssenceItem(properties, id));
        }
        if (type == KnightQuestItems.KQItemType.RADIANT_ESSENCE) {
            return this.registerItem(id, () -> new RadiantEssenceItem(properties, id));
        }
        return this.registerItem(id, () -> new KnightQuestItem(properties, id));
    }

    @Override
    public <T extends SoundEvent> Supplier<T> registerSound(String id, Supplier<T> sound) {
        return KnightQuest.SOUNDS.register(id, sound);
    }

    @Override
    public <T extends ParticleType<?>> Supplier<T> registerParticle(String id, boolean overrideLimiter) {
        return KnightQuest.PARTICLES.register(id, () -> new SimpleParticleType(overrideLimiter));
    }

    @Override
    public <T extends Item> Supplier<T> registerGeoArmorItem(final String id, KQArmorMaterials armorMaterial, ArmorItem.Type armorType, boolean containsTooltip, boolean containsExtraTooltip) {
        if (containsExtraTooltip) {
            return KnightQuest.ITEMS.register(id, () -> new GeoItemArmor(armorMaterial, armorType, new Item.Properties(), id, containsTooltip){

                @Override
                public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
                    pTooltipComponents.add((Component)Component.m_237115_((String)(KnightQuestForgePlatform.TOOLTIP_ITEM_PATH + id)));
                    super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
                }
            });
        }
        return KnightQuest.ITEMS.register(id, () -> new GeoItemArmor(armorMaterial, armorType, new Item.Properties(), id, containsTooltip));
    }

    @Override
    public <T extends Item> Supplier<T> registerAxeItem(String id, KQItemMaterials itemMaterial, float extraDamageBoost, float speedMalus) {
        return KnightQuest.ITEMS.register(id, () -> new AxeItem((Tier)itemMaterial, extraDamageBoost, -3.0f, new Item.Properties()));
    }

    @Override
    public <T extends Item> Supplier<T> registerSwordItem(final String id, KQItemMaterials itemMaterial, float speedMalus, boolean containsTooltip) {
        if (containsTooltip) {
            return KnightQuest.ITEMS.register(id, () -> new SwordItem(itemMaterial, 4, speedMalus, new Item.Properties()){

                public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
                    pTooltipComponents.add((Component)Component.m_237115_((String)(KnightQuestForgePlatform.TOOLTIP_ITEM_PATH + id)));
                    super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
                }
            });
        }
        return KnightQuest.ITEMS.register(id, () -> new SwordItem((Tier)itemMaterial, 4, -2.4f, new Item.Properties()));
    }

    @Override
    public <T extends Item> Supplier<T> registerArmorItem(String id, KQArmorMaterials armorMaterial, ArmorItem.Type armorType, boolean containsTooltip) {
        return KnightQuest.ITEMS.register(id, () -> new KQArmorItem(armorMaterial, armorType, new Item.Properties(), containsTooltip));
    }

    @Override
    public <T extends CreativeModeTab> Supplier<T> registerCreativeModeTab(String id, Supplier<T> tab) {
        return KnightQuest.CREATIVE_TABS.register(id, tab);
    }

    @Override
    public <T extends Item> Supplier<T> registerMusicDisc(String id, int signal, Supplier<SoundEvent> soundEvent, Item.Properties properties, int length) {
        return this.registerItem(id, () -> new RecordItem(signal, (SoundEvent)soundEvent.get(), properties, length));
    }

    @Override
    public CreativeModeTab.Builder creativeTabBuilder() {
        return CreativeModeTab.builder();
    }
}

