/*
 * Decompiled with CFR 0.152.
 */
package express.http.request;

import com.sun.net.httpserver.Headers;
import express.http.Cookie;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

final class RequestUtils {
    private RequestUtils() {
    }

    static HashMap<String, Cookie> parseCookies(Headers headers) {
        HashMap<String, Cookie> cookieList = new HashMap<String, Cookie>();
        Object headerCookies = headers.get("Cookie");
        if (headerCookies == null || headerCookies.isEmpty()) {
            return cookieList;
        }
        char[] chars = ((String)headerCookies.get(0)).toCharArray();
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        boolean swap = false;
        for (char c : chars) {
            if (c == '=') {
                swap = true;
                continue;
            }
            if (c == ';') {
                String rkey = key.toString().trim();
                cookieList.put(rkey, new Cookie(rkey, val.toString()));
                key.setLength(0);
                val.setLength(0);
                swap = false;
                continue;
            }
            if (swap) {
                val.append(c);
                continue;
            }
            key.append(c);
        }
        if (key.length() > 0 && val.length() > 0) {
            String rkey = key.toString().trim();
            cookieList.put(rkey, new Cookie(rkey, val.toString()));
        }
        return cookieList;
    }

    static HashMap<String, String> parseRawQuery(String rawQuery) {
        String[] values;
        HashMap<String, String> queries = new HashMap<String, String>();
        if (rawQuery == null) {
            return queries;
        }
        for (String arg : values = rawQuery.split("&")) {
            if (arg.isEmpty()) continue;
            String key = null;
            String value = null;
            if (arg.contains("=")) {
                String[] data = arg.split("=");
                key = URLDecoder.decode(data[0], StandardCharsets.UTF_8);
                value = data.length >= 2 && !data[1].isBlank() ? URLDecoder.decode(data[1], StandardCharsets.UTF_8) : null;
            } else {
                key = arg;
            }
            queries.put(key, value);
        }
        return queries;
    }
}

