/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcu.windows.mixin.mcef;

import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.kelcu.windows.Windows;
import ru.kelcu.windows.components.Window;
import ru.kelcu.windows.screens.DesktopScreen;
import ru.kelcu.windows.screens.apps.BrowserScreen;

@Pseudo
@Mixin(value={CefClient.class})
public class CefClientMixin {
    @Inject(at={@At(value="HEAD")}, method={"onAddressChange"}, remap=false)
    public void onAddressChange(CefBrowser browser, CefFrame frame, String url, CallbackInfo ci) {
        Window window = this.getWindowByBrowser(browser);
        if (window != null) {
            ((BrowserScreen)window.screen).editBox.method_1852(url);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onTooltip"}, remap=false)
    public void onTooltip(CefBrowser browser, String text, CallbackInfoReturnable<Boolean> cir) {
        Window window = this.getWindowByBrowser(browser);
        if (window != null) {
            ((BrowserScreen)window.screen).tooltipHell = text;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onConsoleMessage"}, remap=false, cancellable=true)
    public void onLoadingStateChange(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line, CallbackInfoReturnable<Boolean> cir) {
        if (!Windows.config.getBoolean("BROWSER.LOGS_ENABLES", false)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onTitleChange"}, remap=false)
    public void onTitleChange(CefBrowser browser, String title, CallbackInfo ci) {
        Window window = this.getWindowByBrowser(browser);
        if (window != null) {
            ((BrowserScreen)window.screen).titleTab = title;
        }
    }

    @Unique
    public Window getWindowByBrowser(CefBrowser browser) {
        for (Window window : DesktopScreen.windows) {
            if (!(window.screen instanceof BrowserScreen) || ((BrowserScreen)window.screen).browser.getIdentifier() != browser.getIdentifier()) continue;
            return window;
        }
        return null;
    }
}

