/*
 * Decompiled with CFR 0.152.
 */
package express;

import express.Router;
import express.filter.FilterImpl;
import express.filter.FilterLayerHandler;
import express.filter.FilterTask;
import express.filter.FilterWorker;
import express.http.HttpRequestHandler;
import java.util.ArrayList;

public class ExpressRouter
implements Router {
    private final ArrayList<FilterWorker> workers = new ArrayList();
    private final FilterLayerHandler handler = new FilterLayerHandler(2);

    @Override
    public ExpressRouter use(HttpRequestHandler middleware) {
        this.addMiddleware("*", "*", middleware);
        return this;
    }

    @Override
    public ExpressRouter use(String context, HttpRequestHandler middleware) {
        this.addMiddleware("*", context, middleware);
        return this;
    }

    @Override
    public ExpressRouter use(String context, String requestMethod, HttpRequestHandler middleware) {
        this.addMiddleware(requestMethod.toUpperCase(), context, middleware);
        return this;
    }

    private void addMiddleware(String requestMethod, String context, HttpRequestHandler middleware) {
        if (middleware instanceof FilterTask) {
            this.workers.add(new FilterWorker((FilterTask)((Object)middleware)));
        }
        this.handler.add(0, new FilterImpl(requestMethod, context, middleware));
    }

    @Override
    public ExpressRouter all(HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("*", "*", request));
        return this;
    }

    @Override
    public ExpressRouter all(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("*", context, request));
        return this;
    }

    @Override
    public ExpressRouter all(String context, String requestMethod, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl(requestMethod, context, request));
        return this;
    }

    @Override
    public ExpressRouter get(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("GET", context, request));
        return this;
    }

    @Override
    public ExpressRouter post(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("POST", context, request));
        return this;
    }

    @Override
    public ExpressRouter put(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("PUT", context, request));
        return this;
    }

    @Override
    public ExpressRouter delete(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("DELETE", context, request));
        return this;
    }

    @Override
    public ExpressRouter patch(String context, HttpRequestHandler request) {
        this.handler.add(1, new FilterImpl("PATCH", context, request));
        return this;
    }

    public ArrayList<FilterWorker> getWorker() {
        return this.workers;
    }

    public FilterLayerHandler getHandler() {
        return this.handler;
    }
}

