/*
 * Decompiled with CFR 0.152.
 */
package express.http;

import express.http.SameSite;
import java.time.Instant;

public class Cookie {
    private String name;
    private String value;
    private String expire;
    private String path = "/";
    private String domain;
    private String sameSite;
    private boolean secure = false;
    private boolean httpOnly = false;
    private long maxAge = -1L;

    public Cookie(String name, String value) {
        name = name.trim();
        if (name.isEmpty() || name.charAt(0) == '$') {
            throw new IllegalArgumentException("Illegal cookie name");
        }
        this.name = name;
        this.value = value;
    }

    public Cookie() {
    }

    public String getName() {
        return this.name;
    }

    public Cookie setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Cookie setValue(String value) {
        this.value = value;
        return this;
    }

    public String getExpire() {
        return this.expire;
    }

    public Cookie setExpire(Instant instant) {
        this.expire = instant.toString();
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public Cookie setPath(String path) {
        this.path = path;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Cookie setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public Cookie setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public String getSameSite() {
        return this.sameSite;
    }

    public Cookie setSameSite(SameSite sameSite) {
        if (sameSite == null) {
            return this;
        }
        this.sameSite = sameSite.name();
        return this;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public Cookie setMaxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Cookie) {
            Cookie other = (Cookie)obj;
            if (!other.getValue().equals(this.getValue())) {
                return false;
            }
            if (!other.getName().equals(this.getName())) {
                return false;
            }
            if (!other.getDomain().equals(this.getDomain())) {
                return false;
            }
            if (!other.getExpire().equals(this.getExpire())) {
                return false;
            }
            if (other.getMaxAge() != this.getMaxAge()) {
                return false;
            }
            if (!other.getSameSite().equals(this.getSameSite())) {
                return false;
            }
            return other.getPath().equals(this.getPath());
        }
        return super.equals(obj);
    }

    public String toString() {
        if (this.name == null || this.value == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.name).append("=").append(this.value);
        if (this.path != null) {
            b.append("; Path=").append(this.path);
        }
        if (this.expire != null) {
            b.append("; Expire=").append(this.expire);
        }
        if (this.maxAge != -1L) {
            b.append("; Max-Age=").append(this.maxAge);
        }
        if (this.domain != null) {
            b.append("; Domain=").append(this.domain);
        }
        if (this.sameSite != null) {
            b.append("; SameSite=").append(this.sameSite);
        }
        if (this.secure) {
            b.append("; Secure");
        }
        if (this.httpOnly) {
            b.append("; HttpOnly");
        }
        return b.toString();
    }
}

