/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcu.windows.components.builders;

import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import ru.kelcu.windows.components.Window;
import ru.kelcuprum.alinlib.gui.GuiUtils;

public class WindowBuilder {
    public double x;
    public double y;
    public double width;
    public double height;
    public boolean active = true;
    public boolean visible = true;
    public class_2960 icon = GuiUtils.getResourceLocation((String)"windows", (String)"textures/start/icons/cmd.png");
    public class_2561 title;
    public class_437 screen;
    public UUID uuid = UUID.randomUUID();
    public boolean resizable = true;
    public boolean maximize = false;
    public int buttons = 0;
    protected boolean isCustomPos = false;
    public class_437 lastScreen = null;

    public WindowBuilder() {
        this((class_2561)null);
    }

    public WindowBuilder(String title) {
        this((class_2561)class_2561.method_43471((String)title));
    }

    public WindowBuilder(class_2561 title) {
        this.title = title;
        int w = class_310.method_1551().method_22683().method_4486();
        int h = class_310.method_1551().method_22683().method_4502();
        this.width = (int)((double)w * 0.75);
        this.height = (int)((double)h * 0.75);
        this.x = Math.max(0.0, ((double)w - this.width) / 2.0);
        this.y = Math.max(0.0, ((double)h - this.height) / 2.0);
    }

    public WindowBuilder setTitle(String title) {
        return this.setTitle((class_2561)class_2561.method_43471((String)title));
    }

    public WindowBuilder setTitle(class_2561 title) {
        this.title = title;
        return this;
    }

    public class_2561 getTitle() {
        return this.screen.method_25440().equals((Object)class_2561.method_43473()) ? (this.title == null ? class_2561.method_43470((String)String.format("%s.exe", this.screen.getClass().getSimpleName())) : this.title) : this.screen.method_25440();
    }

    public WindowBuilder setPosition(double x, double y) {
        this.x = x;
        this.y = y;
        this.isCustomPos = true;
        return this;
    }

    public WindowBuilder setSize(double width, double height) {
        this.width = width;
        this.height = height;
        if (!this.isCustomPos) {
            int w = class_310.method_1551().method_22683().method_4486();
            int h = class_310.method_1551().method_22683().method_4502();
            this.x = Math.max(0.0, ((double)w - width) / 2.0);
            this.y = Math.max(0.0, ((double)h - height) / 2.0);
        }
        return this;
    }

    public WindowBuilder setActive(boolean active) {
        this.active = active;
        return this;
    }

    public boolean getActive() {
        return this.active;
    }

    public WindowBuilder setVisible(boolean visible) {
        this.visible = visible;
        if (!visible) {
            this.active = false;
        }
        return this;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public WindowBuilder setScreen(class_437 screen) {
        this.lastScreen = this.screen;
        this.screen = screen;
        return this;
    }

    public class_437 getScreen() {
        return this.screen;
    }

    public class_437 getLastScreen() {
        return this.lastScreen;
    }

    public WindowBuilder setButtons(int buttons) {
        this.buttons = buttons;
        return this;
    }

    public WindowBuilder setResizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    public WindowBuilder setIcon(class_2960 icon) {
        this.icon = icon;
        return this;
    }

    public Window build() {
        Window window = new Window(this.uuid, (int)this.x, (int)this.y, (int)this.width, (int)this.height, this.title, this.active, this.buttons, this.visible, this.screen, this.icon);
        window.resizable = this.resizable;
        return window;
    }
}

