/*
 * Decompiled with CFR 0.152.
 */
package express.http.response;

import com.google.gson.JsonElement;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import express.http.Cookie;
import express.utils.MediaType;
import express.utils.Status;
import express.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response {
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    private final HttpExchange httpExchange;
    private final OutputStream body;
    private final Headers headers;
    private String contentType = MediaType._txt.getMIME();
    private boolean isClose = false;
    private long contentLength = 0L;
    private int status = 200;

    public Response(HttpExchange exchange) {
        this.httpExchange = exchange;
        this.headers = exchange.getResponseHeaders();
        this.body = exchange.getResponseBody();
    }

    public Response setHeader(String key, String value) {
        this.headers.add(key, value);
        return this;
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    public void redirect(String location) {
        this.headers.add("Location", location);
        this.setStatus(Status._302);
        this.send();
    }

    public Response setCookie(Cookie cookie) {
        if (this.isClosed()) {
            return this;
        }
        this.headers.add("Set-Cookie", cookie.toString());
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public Response setStatus(Status status) {
        return this.setStatus(status.getCode());
    }

    public Response setStatus(int status) {
        if (this.isClosed()) {
            return this;
        }
        this.status = status;
        return this;
    }

    public void sendStatus(Status status) {
        this.sendStatus(status.getCode());
    }

    public void sendStatus(int status) {
        if (this.isClosed()) {
            return;
        }
        this.status = status;
        this.send();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(MediaType contentType) {
        this.contentType = contentType.getMIME();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void send() {
        if (this.isClosed()) {
            return;
        }
        this.contentLength = 0L;
        this.sendHeaders();
        this.close();
    }

    public void json(String j) {
        this.setContentType(MediaType._json.getMIME());
        this.send(j);
    }

    public void json(JsonElement j) {
        this.setContentType(MediaType._json.getMIME());
        this.send(j.toString());
    }

    public void send(String s) {
        if (s == null) {
            this.send();
            return;
        }
        if (this.isClosed()) {
            return;
        }
        Charset decodingCharset = Charset.defaultCharset();
        try {
            String charsetName = this.getContentType().split(";")[1].replace(" ", "").split("\\=")[1];
            decodingCharset = Charset.forName(charsetName);
        }
        catch (Exception charsetName) {
            // empty catch block
        }
        byte[] data = s.getBytes(decodingCharset);
        this.contentLength = data.length;
        this.sendHeaders();
        try {
            this.body.write(s.getBytes());
        }
        catch (IOException e) {
            log.error("Failed to write char sequence to client.", (Throwable)e);
        }
        this.close();
    }

    public boolean sendAttachment(Path file) {
        if (this.isClosed() || !Files.isRegularFile(file, new LinkOption[0])) {
            return false;
        }
        String dispo = "attachment; filename=\"" + String.valueOf(file.getFileName()) + "\"";
        this.setHeader("Content-Disposition", dispo);
        return this.send(file);
    }

    public boolean sendChunked(Path file) {
        return this.sendFile(file, true);
    }

    public boolean send(Path file) {
        return this.sendFile(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendFile(Path file, boolean wantChunked) {
        if (this.isClosed() || !Files.isRegularFile(file, new LinkOption[0])) {
            return false;
        }
        try {
            int n;
            MediaType mediaType;
            if (!wantChunked) {
                this.contentLength = Files.size(file);
            }
            this.contentType = (mediaType = Utils.getContentType(file)) == null ? null : mediaType.getMIME();
            this.sendHeaders();
            InputStream fis = Files.newInputStream(file, StandardOpenOption.READ);
            byte[] buffer = new byte[1024];
            while ((n = fis.read(buffer)) != -1) {
                this.body.write(buffer, 0, n);
            }
            fis.close();
        }
        catch (IOException e) {
            log.error("Failed to pipe file to output stream.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBytes(byte[] bytes) {
        if (this.isClosed() || bytes == null) {
            return false;
        }
        try {
            this.contentLength = bytes.length;
            this.contentType = MediaType._bin.getMIME();
            this.sendHeaders();
            this.body.write(bytes);
        }
        catch (IOException e) {
            log.error("Failed to pipe file to output stream.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean streamFrom(long contentLength, InputStream is, MediaType mediaType) {
        if (this.isClosed() || is == null) {
            return false;
        }
        try {
            int n;
            this.contentLength = contentLength;
            if (mediaType != null & this.contentType == null) {
                this.contentType = mediaType.getMIME();
            }
            this.sendHeaders();
            byte[] buffer = new byte[4096];
            while ((n = is.read(buffer)) != -1) {
                this.body.write(buffer, 0, n);
            }
            is.close();
        }
        catch (IOException e) {
            log.error("Failed to pipe file to output stream.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
        return true;
    }

    public boolean streamFrom(InputStream is, MediaType mediaType) {
        return this.streamFrom(0L, is, mediaType);
    }

    public boolean isClosed() {
        return this.isClose;
    }

    private void sendHeaders() {
        try {
            boolean hasContent;
            boolean bl = hasContent = this.contentLength != 0L;
            if (hasContent) {
                String contentType = this.getContentType() == null ? MediaType._bin.getExtension() : this.getContentType();
                this.headers.set("Content-Type", contentType);
            }
            this.httpExchange.sendResponseHeaders(this.status, hasContent ? this.contentLength : -1L);
        }
        catch (IOException e) {
            log.error("Failed to send headers.", (Throwable)e);
        }
    }

    private void close() {
        try {
            this.body.close();
            this.isClose = true;
        }
        catch (IOException e) {
            log.error("Failed to close output stream.", (Throwable)e);
        }
    }
}

