/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcu.windows.screens.apps;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFBrowser;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.TextureFormat;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_10868;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import ru.kelcu.windows.Windows;
import ru.kelcu.windows.mixin.ExampleTextureMixin;
import ru.kelcu.windows.screens.components.alinlib.EditBox;
import ru.kelcu.windows.utils.WinColors;
import ru.kelcu.windows.utils.WindowUtils;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.editbox.EditBoxBuilder;
import ru.kelcuprum.alinlib.gui.components.buttons.Button;
import ru.kelcuprum.alinlib.gui.styles.AbstractStyle;

public class BrowserScreen
extends class_437 {
    private static final int BROWSER_DRAW_OFFSET = 1;
    private static final int BROWSER_DRAW_TITLE_OFFSET = 24;
    public MCEFBrowser browser;
    public String titleTab = "";
    public String tooltipHell = "";
    protected class_2960 exampleLocation;
    protected ExampleTexture exampleTexture;
    public static boolean isFirstHuy = true;
    public ru.kelcuprum.alinlib.gui.components.editbox.EditBox editBox;
    public Button buttonReload;

    public BrowserScreen() {
        super((class_2561)class_2561.method_43470((String)"Clovium"));
        if (isFirstHuy) {
            isFirstHuy = false;
            MCEF.getSettings().setUserAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) MCEF/2 Clovium/69 Chrome/119.0.0.0 Safari/537.36");
        }
    }

    protected void method_25426() {
        super.method_25426();
        if (this.browser == null) {
            this.exampleLocation = class_2960.method_60655((String)"example", (String)("frame_" + UUID.randomUUID().toString().replace("-", "")));
            this.exampleTexture = new ExampleTexture(-1, this.exampleLocation.toString());
            String url = Windows.config.getString("BROWSER.HOME_PAGE", "https://www.google.com");
            boolean transparent = false;
            this.browser = MCEF.createBrowser((String)url, (boolean)transparent);
            this.resizeBrowser();
            class_310.method_1551().method_1531().method_4616(this.exampleLocation, (class_1044)this.exampleTexture);
        }
        boolean x = false;
        boolean y = false;
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"minedows.browser.back"), s -> {
            if (this.browser.canGoBack()) {
                this.browser.goBack();
            }
        }).setSprite(WinColors.getLightIcon("textures/browser/back")).setSize(20, 20).setPosition(2, 1).setStyle((AbstractStyle)Windows.minedowsStyle).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"minedows.browser.forward"), s -> {
            if (this.browser.canGoForward()) {
                this.browser.goForward();
            }
        }).setSprite(WinColors.getLightIcon("textures/browser/forward")).setSize(20, 20).setPosition(22, 1).setStyle((AbstractStyle)Windows.minedowsStyle).build());
        this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"minedows.browser.home"), s -> this.browser.loadURL(Windows.config.getString("BROWSER.HOME_PAGE", "https://www.google.com"))).setSprite(WinColors.getLightIcon("textures/browser/home")).setSize(20, 20).setPosition(46, 1).setStyle((AbstractStyle)Windows.minedowsStyle).build());
        this.buttonReload = (Button)this.method_37063((class_364)new ButtonBuilder((class_2561)class_2561.method_43471((String)"minedows.browser.reload"), s -> {
            if (this.browser.isLoading()) {
                this.browser.stopLoad();
            } else {
                this.browser.reload();
            }
        }).setSprite(WinColors.getLightIcon("textures/browser/reload")).setSize(20, 20).setPosition(70, 1).setStyle((AbstractStyle)Windows.minedowsStyle).build());
        this.editBox = new EditBox(new EditBoxBuilder().setValue(this.browser.getURL()).setSize(this.field_22789 - 96, 20).setPosition(94, 1));
        this.method_37063((class_364)this.editBox);
    }

    private int mouseX(double x) {
        return (int)((x - 1.0) * (double)this.field_22787.method_22683().method_4495());
    }

    private int mouseY(double y) {
        return (int)((y - 24.0 - 1.0) * (double)this.field_22787.method_22683().method_4495());
    }

    private int scaleX(double x) {
        return (int)((x - 2.0) * (double)this.field_22787.method_22683().method_4495());
    }

    private int scaleY(double y) {
        return (int)((y - 24.0 - 2.0) * (double)this.field_22787.method_22683().method_4495());
    }

    private void resizeBrowser() {
        if (this.field_22789 > 100 && this.field_22790 > 100) {
            this.browser.resize(this.scaleX(this.field_22789), this.scaleY(this.field_22790));
        }
    }

    private void updateFrame() {
        this.exampleTexture.setId(this.browser.getRenderer().getTextureID());
        this.exampleTexture.setWidth(this.field_22789);
        this.exampleTexture.setHeight(this.field_22790);
    }

    public void method_25410(class_310 minecraft, int i, int j) {
        super.method_25410(minecraft, i, j);
        this.resizeBrowser();
    }

    public void method_25419() {
        this.browser.close();
        super.method_25419();
    }

    public void method_25393() {
        super.method_25393();
        if (this.buttonReload != null && this.browser != null) {
            ((ButtonBuilder)this.buttonReload.builder).setIcon(this.browser.isLoading() ? GuiUtils.getResourceLocation((String)"windows", (String)"textures/browser/cancel.png") : GuiUtils.getResourceLocation((String)"windows", (String)"textures/browser/reload.png"));
        }
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        this.updateFrame();
        WindowUtils.welcomeToWhiteSpace(guiGraphics, 0, 24, this.field_22789, this.field_22790 - 24);
        guiGraphics.method_25291(class_10799.field_56883, this.exampleLocation, 1, 25, 0.0f, 0.0f, this.field_22789 - 2, this.field_22790 - 24 - 2, this.field_22789 - 2, this.field_22790 - 24 - 2, Color.white.getRGB());
        if (!this.tooltipHell.isEmpty()) {
            guiGraphics.method_71276((class_2561)class_2561.method_43470((String)this.tooltipHell), i, j);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX > 24.0) {
            this.method_25395(null);
        }
        this.browser.sendMousePress(this.mouseX(mouseX), this.mouseY(mouseY), button);
        this.browser.setFocus(true);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.browser.sendMouseRelease(this.mouseX(mouseX), this.mouseY(mouseY), button);
        this.browser.setFocus(true);
        return super.method_25406(mouseX, mouseY, button);
    }

    @NotNull
    public class_2561 method_25440() {
        if (this.browser.getFocusedFrame() == null) {
            return super.method_25440();
        }
        return this.browser.isLoading() ? class_2561.method_43470((String)"Loading...") : (this.titleTab.isBlank() ? super.method_25440() : class_2561.method_43473().method_27693(this.titleTab).method_27693(" \u2014 ").method_10852(super.method_25440()));
    }

    public void method_16014(double mouseX, double mouseY) {
        this.browser.sendMouseMove(this.mouseX(mouseX), this.mouseY(mouseY));
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.browser.sendMouseWheel(this.mouseX(mouseX), this.mouseY(mouseY), scrollY, 0);
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.editBox.method_25370()) {
            if (keyCode == 257) {
                this.updateUrl();
                this.method_25365(false);
                this.method_25395(null);
            }
            return this.editBox.method_25404(keyCode, scanCode, modifiers);
        }
        this.browser.sendKeyPress(keyCode, (long)scanCode, modifiers);
        this.browser.setFocus(true);
        if (keyCode == 256 && this.method_25422()) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public void updateUrl() {
        double r;
        String url = this.editBox.method_1882();
        if ((url.toLowerCase().contains("vk.ru") || url.toLowerCase().contains("vk.com")) && (r = Math.random()) < 0.25) {
            throw new RuntimeException("\u041a\u0430\u043a\u0438\u0435 \u043d\u0430\u0444\u0438\u0433 \u0412\u041a? \u042f \u0441\u043a\u0430\u0437\u0430\u043b Clovisoft");
        }
        String[] args = url.split("\\.");
        boolean search = false;
        if (!url.contains("://")) {
            if (args.length >= 2) {
                for (String hell : args) {
                    if (!hell.matches("[ ,!]")) continue;
                    search = true;
                }
            } else {
                search = true;
            }
        }
        this.browser.loadURL(search ? BrowserScreen.getSearchURL(url) : url);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.editBox.method_25370()) {
            return super.method_16803(keyCode, scanCode, modifiers);
        }
        this.browser.sendKeyRelease(keyCode, (long)scanCode, modifiers);
        this.browser.setFocus(true);
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.editBox.method_25370()) {
            return super.method_25400(codePoint, modifiers);
        }
        if (codePoint == '\u0000') {
            return false;
        }
        this.browser.sendKeyTyped(codePoint, modifiers);
        this.browser.setFocus(true);
        return super.method_25400(codePoint, modifiers);
    }

    public static String getSearchURL(String query) {
        return switch (Windows.config.getNumber("BROWSER.SEARCH", (Number)0).intValue()) {
            case 4 -> String.format(Windows.config.getString("BROWSER.SEARCH.CUSTOM", "https://google.com/search?q=%s"), query);
            case 3 -> String.format("https://www.startpage.com/do/dsearch?q=%s", query);
            case 2 -> String.format("https://duckduckgo.com/?q=%s", query);
            case 1 -> String.format("https://yandex.ru/search?text=%s", query);
            default -> String.format("https://google.com/search?q=%s", query);
        };
    }

    public static class ExampleTexture
    extends class_1044 {
        protected final ExampleGlTexture glTexture;

        public ExampleTexture(int id, @NotNull String label) {
            this.glTexture = new ExampleGlTexture(5, label, TextureFormat.RGBA8, 100, 100, 1, 1, id);
            this.glTexture.setTextureFilter(FilterMode.NEAREST, false);
            this.field_56974 = this.glTexture;
            GpuDevice device = RenderSystem.getDevice();
            this.field_60597 = device.createTextureView(this.field_56974);
        }

        public void setId(int id) {
            this.glTexture.setGlId(id);
        }

        public void setWidth(int width) {
            this.glTexture.setWidth(width);
        }

        public void setHeight(int height) {
            this.glTexture.setHeight(height);
        }
    }

    public static class ExampleGlTexture
    extends class_10868 {
        protected int width;
        protected int height;

        public ExampleGlTexture(int usage, String label, TextureFormat texFormat, int width, int height, int depthOrLayers, int mipLevels, int glId) {
            super(usage, label, texFormat, width, height, depthOrLayers, mipLevels, glId);
            this.width = width;
            this.height = height;
        }

        public int getWidth(int i) {
            return this.width >> i;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight(int i) {
            return this.height >> i;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int method_68427() {
            return this.field_57882;
        }

        public void setGlId(int id) {
            ((ExampleTextureMixin)((Object)this)).setId(id);
        }
    }
}

