/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcu.windows.utils;

import java.util.Random;

public class Perlin2D {
    private byte[] permutationTable;

    public Perlin2D(long seed) {
        Random random = new Random(seed);
        this.permutationTable = new byte[1024];
        random.nextBytes(this.permutationTable);
    }

    public float getNoise(float fx, float fy, int octaves, float persistence) {
        float amplitude = 1.0f;
        float max = 0.0f;
        float result = 0.0f;
        while (octaves-- > 0) {
            max += amplitude;
            result += this.getNoise(fx, fy) * amplitude;
            amplitude *= persistence;
            fx *= 2.0f;
            fy *= 2.0f;
        }
        return result / max;
    }

    public float getNoise(float x, float y) {
        int left = (int)x;
        int top = (int)y;
        float localX = x - (float)left;
        float localY = y - (float)top;
        Vector topLeftGradient = this.getPseudoRandomGradientVector(left, top);
        Vector topRightGradient = this.getPseudoRandomGradientVector(left + 1, top);
        Vector bottomLeftGradient = this.getPseudoRandomGradientVector(left, top + 1);
        Vector bottomRightGradient = this.getPseudoRandomGradientVector(left + 1, top + 1);
        Vector distanceToTopLeft = new Vector(localX, localY);
        Vector distanceToTopRight = new Vector(localX - 1.0f, localY);
        Vector distanceToBottomLeft = new Vector(localX, localY - 1.0f);
        Vector distanceToBottomRight = new Vector(localX - 1.0f, localY - 1.0f);
        float tx1 = this.dot(distanceToTopLeft, topLeftGradient);
        float tx2 = this.dot(distanceToTopRight, topRightGradient);
        float bx1 = this.dot(distanceToBottomLeft, bottomLeftGradient);
        float bx2 = this.dot(distanceToBottomRight, bottomRightGradient);
        float tx = this.lerp(tx1, tx2, this.qunticCurve(localX));
        float bx = this.lerp(bx1, bx2, this.qunticCurve(localX));
        float tb = this.lerp(tx, bx, this.qunticCurve(localY));
        return tb;
    }

    private float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private float dot(Vector a, Vector b) {
        return a.x * b.x + a.y * b.y;
    }

    private float qunticCurve(float t) {
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    private Vector getPseudoRandomGradientVector(int x, int y) {
        int v = (int)(((long)x * 1836311903L ^ (long)y * 2971215073L + 4807526976L) & 0x3FFL);
        v = this.permutationTable[v] & 3;
        switch (v) {
            case 0: {
                return new Vector(1.0f, 0.0f);
            }
            case 1: {
                return new Vector(-1.0f, 0.0f);
            }
            case 2: {
                return new Vector(0.0f, 1.0f);
            }
        }
        return new Vector(0.0f, -1.0f);
    }

    private static class Vector {
        float x;
        float y;

        Vector(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

