/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcu.windows;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import ru.kelcu.windows.style.MinedowsStyle;
import ru.kelcu.windows.utils.Perlin2D;
import ru.kelcu.windows.utils.ThemeManager;
import ru.kelcu.windows.utils.WallpaperUtil;
import ru.kelcu.windows.utils.WinColors;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.api.events.client.ClientLifecycleEvents;
import ru.kelcuprum.alinlib.config.Config;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.styles.AbstractStyle;

public class Windows
implements ClientModInitializer {
    public static boolean gameStarted = false;
    public static Config config = new Config("config/minedows/conf.json");
    public static Thread perlinNoises;
    public static MinedowsStyle minedowsStyle;
    public static Perlin2D perlin;
    public static int xPerlin;

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(s -> {
            WallpaperUtil.registerDefaultWallpapers();
            ThemeManager.registerDefaultThemes();
            try {
                String file = config.getString("WALLPAPER.FILE", "");
                if (!file.isEmpty()) {
                    if (file.equals("fluffy_forever")) {
                        WallpaperUtil.fluffy();
                    } else if (WallpaperUtil.getWallpaperData(file) != null) {
                        WallpaperUtil.loadWallpaper(WallpaperUtil.getWallpaperData(file));
                    } else {
                        WallpaperUtil.loadFileWallpaper(Path.of(file, new String[0]));
                    }
                }
                if (WallpaperUtil.width == 0 && WallpaperUtil.height == 0) {
                    config.setNumber("WALLPAPER.TYPE", (Number)0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                Windows.generatePerlin(AlinLib.MINECRAFT.method_22683().method_4486() / 2, AlinLib.MINECRAFT.method_22683().method_4502() / 2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        FabricLoader.getInstance().getModContainer("minedows").ifPresent(container -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)GuiUtils.getResourceLocation((String)"minedows", (String)"windows_sound"), (ModContainer)container, (class_2561)class_2561.method_43471((String)"resourcePack.windows_sound"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
        GuiUtils.registerStyle((AbstractStyle)minedowsStyle);
        ClientLifecycleEvents.CLIENT_FULL_STARTED.register(s -> {
            gameStarted = true;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3414.method_47908((class_2960)class_2960.method_60655((String)"windows", (String)"windows_startup")), (float)1.0f));
            perlinNoises = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            if (config.getNumber("WALLPAPER.TYPE", (Number)0).intValue() == 1 && AlinLib.MINECRAFT.field_1687 == null) {
                                Windows.generatePerlin(AlinLib.MINECRAFT.field_1755.field_22789 / 2, AlinLib.MINECRAFT.field_1755.field_22790 / 2);
                                ++xPerlin;
                                continue;
                            }
                            Thread.sleep(500L);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            });
            perlinNoises.start();
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(s -> {
            if (perlinNoises != null) {
                perlinNoises.interrupt();
            }
        });
    }

    public static void generatePerlin(int width, int height) throws IOException {
        if (perlin == null) {
            perlin = new Perlin2D((long)(9.223372036854776E18 * ((double)(Math.random() > 0.5 ? -1 : 1) * Math.random())));
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        for (int xd = 0; xd < width; ++xd) {
            for (int yd = 0; yd < height; ++yd) {
                float value = perlin.getNoise((float)(xd + xPerlin) / 100.0f, (float)yd / 100.0f, 8, 0.2f) + 0.5f;
                int[] colors = WinColors.getPerlinColors();
                bufferedImage.setRGB(xd, yd, GuiUtils.interpolate((int)colors[0], (int)colors[1], (float)value));
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        class_1011 image = class_1011.method_4309((InputStream)is);
        AtomicReference texture = new AtomicReference();
        class_310.method_1551().execute(() -> {
            texture.set(new class_1043(() -> "perlin", image));
            class_310.method_1551().method_1531().method_4616(GuiUtils.getResourceLocation((String)"minedows", (String)"perlin"), (class_1044)texture.get());
        });
    }

    public static boolean isModMenuInstalled() {
        return FabricLoader.getInstance().isModLoaded("modmenu") || FabricLoader.getInstance().isModLoaded("menulogue");
    }

    public static boolean isCatalogueInstalled() {
        return FabricLoader.getInstance().isModLoaded("catalogue");
    }

    public static boolean isDeveloperPreview() {
        String version = ((ModContainer)FabricLoader.getInstance().getModContainer("minedows").get()).getMetadata().getVersion().getFriendlyString();
        return FabricLoader.getInstance().isDevelopmentEnvironment() || version.contains("alpha") || version.contains("beta") || version.contains("dev") || version.contains("rc");
    }

    static {
        minedowsStyle = new MinedowsStyle();
        perlin = null;
        xPerlin = 0;
    }
}

