/*
 * Decompiled with CFR 0.152.
 */
package ru.sansrus.simple_autoclicker1_21_9.client;

import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1747;
import net.minecraft.class_1781;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2824;
import net.minecraft.class_2846;
import net.minecraft.class_2868;
import net.minecraft.class_2873;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_318;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_638;
import net.minecraft.class_746;
import ru.sansrus.simple_autoclicker1_21_9.client.AutoClickerManager;

@Environment(value=EnvType.CLIENT)
public enum AutoClickAction {
    FORWARD(c -> AutoClickAction.pressKey(c, "key.forward"), c -> AutoClickAction.releaseKey(c, "key.forward")),
    BACKWARD(c -> AutoClickAction.pressKey(c, "key.back"), c -> AutoClickAction.releaseKey(c, "key.back")),
    LEFT(c -> AutoClickAction.pressKey(c, "key.left"), c -> AutoClickAction.releaseKey(c, "key.left")),
    RIGHT(c -> AutoClickAction.pressKey(c, "key.right"), c -> AutoClickAction.releaseKey(c, "key.right")),
    SPRINT(c -> {
        if (c != null) {
            c.field_1690.field_1867.method_23481(true);
        }
    }, c -> {
        if (c != null) {
            c.field_1690.field_1867.method_23481(false);
        }
    }),
    JUMP(c -> {
        boolean canJumpSafely;
        if (c == null || c.field_1724 == null) {
            return;
        }
        class_746 p = c.field_1724;
        try {
            if (p.method_68878() || p.method_31549() != null && p.method_31549().field_7478) {
                p.method_6043();
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = canJumpSafely = p.method_24828() || p.method_5869() || p.method_5771() || p.method_6101() || p.method_5765();
        if (canJumpSafely) {
            p.method_6043();
        }
    }),
    SNEAK(c -> {
        if (c != null && c.field_1690 != null) {
            c.field_1690.field_1832.method_23481(true);
        }
    }, c -> {
        if (c != null && c.field_1690 != null) {
            c.field_1690.field_1832.method_23481(false);
        }
    }),
    USE_ITEM(c -> {
        if (c == null || c.field_1724 == null || c.field_1687 == null || c.field_1761 == null) {
            return;
        }
        block5: for (class_1268 hand : class_1268.values()) {
            class_239 hr;
            class_1799 stack = c.field_1724.method_5998(hand);
            if (stack.method_7960()) continue;
            class_1269 itemResult = c.field_1761.method_2919((class_1657)c.field_1724, hand);
            if (itemResult == class_1269.field_5812 || itemResult == class_1269.field_21466) {
                if (c.field_1690 != null && c.field_1690.field_1904 != null) {
                    c.field_1690.field_1904.method_23481(true);
                }
                return;
            }
            double reach = c.field_1724.method_45325(class_5134.field_47758);
            class_239 selector0$temp = hr = c.field_1724.method_5745(reach, 0.0f, true);
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3965.class, class_3966.class}, (Object)selector0$temp, index$1)) {
                case -1: {
                    continue block5;
                }
                case 0: {
                    class_1269 blockResult;
                    class_3965 bhr = (class_3965)selector0$temp;
                    class_2338 placePos = bhr.method_17777().method_10093(bhr.method_17780());
                    if (AutoClickAction.requiresSupport(stack.method_7909()) && !AutoClickAction.hasSupport(c.field_1687, placePos) || (blockResult = c.field_1761.method_2896(c.field_1724, hand, bhr)) != class_1269.field_5812 && blockResult != class_1269.field_21466) continue block5;
                    if (c.field_1690 != null && c.field_1690.field_1904 != null) {
                        c.field_1690.field_1904.method_23481(true);
                    }
                    return;
                }
                case 1: {
                    class_3966 ehr = (class_3966)selector0$temp;
                    class_1269 entResult = c.field_1761.method_2917((class_1657)c.field_1724, ehr.method_17782(), ehr, hand);
                    if (entResult != class_1269.field_5812 && entResult != class_1269.field_21466) continue block5;
                    if (c.field_1690 != null && c.field_1690.field_1904 != null) {
                        c.field_1690.field_1904.method_23481(true);
                    }
                    return;
                }
                default: {
                    continue block5;
                }
            }
        }
        if (c.field_1690 != null && c.field_1690.field_1904 != null) {
            c.field_1690.field_1904.method_23481(true);
        }
    }, c -> {
        if (c == null) {
            return;
        }
        if (c.field_1690 != null && c.field_1690.field_1904 != null) {
            c.field_1690.field_1904.method_23481(false);
        }
    }),
    ATTACK(c -> {
        class_3966 entityHit;
        class_1297 target;
        if (c.field_1724 == null || c.field_1761 == null) {
            return;
        }
        if (c.field_1724.method_7261(0.0f) < 1.0f) {
            return;
        }
        AutoClickerManager.playHandSwing(c, class_1268.field_5808, true);
        double reach = c.field_1724.method_45325(class_5134.field_47758);
        class_239 hit = c.field_1724.method_5745(reach, 0.0f, true);
        if (hit instanceof class_3966 && (target = (entityHit = (class_3966)hit).method_17782()).method_5805() && target.method_5732()) {
            c.field_1761.method_2918((class_1657)c.field_1724, target);
            c.field_1724.field_3944.method_52787((class_2596)class_2824.method_34206((class_1297)target, (boolean)c.field_1724.method_5715()));
        }
    }),
    DROP(c -> {
        if (c.field_1724 != null) {
            c.field_1724.method_7290(false);
            AutoClickerManager.playHandSwing(c, class_1268.field_5808, true);
        }
    }),
    PICK_BLOCK(c -> {
        int i;
        int currentSlot;
        class_3966 ehr;
        class_1297 ent;
        if (c.field_1724 == null || c.field_1687 == null || c.method_1562() == null) {
            return;
        }
        double reach = c.field_1724.method_45325(class_5134.field_47758);
        class_239 hr = c.field_1724.method_5745(reach, 0.0f, false);
        class_1799 targetStack = class_1799.field_8037;
        if (hr instanceof class_3965) {
            class_3965 bhr = (class_3965)hr;
            class_2338 pos = bhr.method_17777();
            class_2680 state = c.field_1687.method_8320(pos);
            targetStack = state.method_26204().method_9564().method_65171((class_4538)c.field_1687, pos, true);
        } else if (hr instanceof class_3966 && (ent = (ehr = (class_3966)hr).method_17782()) instanceof class_1309) {
            targetStack = ent.method_31480();
        }
        if (targetStack.method_7960()) {
            return;
        }
        class_1661 inv = c.field_1724.method_31548();
        if (class_1799.method_31577((class_1799)inv.method_5438(currentSlot = inv.method_67532()), (class_1799)targetStack)) {
            return;
        }
        for (i = 0; i < 9; ++i) {
            if (!class_1799.method_31577((class_1799)inv.method_5438(i), (class_1799)targetStack)) continue;
            inv.method_61496(i);
            c.method_1562().method_52787((class_2596)new class_2868(i));
            return;
        }
        for (i = 9; i < 36; ++i) {
            if (!class_1799.method_31577((class_1799)inv.method_5438(i), (class_1799)targetStack)) continue;
            c.field_1761.method_2906(c.field_1724.field_7498.field_7763, i, currentSlot, class_1713.field_7791, (class_1657)c.field_1724);
            return;
        }
        if (c.field_1724.method_68878()) {
            inv.method_5447(currentSlot, targetStack.method_7972());
            c.method_1562().method_52787((class_2596)new class_2873(36 + currentSlot, targetStack.method_7972()));
        }
    }),
    SWAP_HANDS(c -> {
        if (c.field_1724 == null || c.method_1562() == null) {
            return;
        }
        c.method_1562().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11036));
    }),
    HOTBAR_1(c -> AutoClickAction.selectHotbar(c, 0)),
    HOTBAR_2(c -> AutoClickAction.selectHotbar(c, 1)),
    HOTBAR_3(c -> AutoClickAction.selectHotbar(c, 2)),
    HOTBAR_4(c -> AutoClickAction.selectHotbar(c, 3)),
    HOTBAR_5(c -> AutoClickAction.selectHotbar(c, 4)),
    HOTBAR_6(c -> AutoClickAction.selectHotbar(c, 5)),
    HOTBAR_7(c -> AutoClickAction.selectHotbar(c, 6)),
    HOTBAR_8(c -> AutoClickAction.selectHotbar(c, 7)),
    HOTBAR_9(c -> AutoClickAction.selectHotbar(c, 8)),
    TOGGLE_PERSPECTIVE(c -> {
        if (c == null || c.field_1690 == null) {
            return;
        }
        class_315 opts = c.field_1690;
        opts.method_31043(opts.method_31044().method_31036());
    }),
    SCREENSHOT(c -> {
        if (c == null) {
            return;
        }
        try {
            class_276 fb = c.method_1522();
            if (fb != null) {
                class_318.method_1659((File)c.field_1697, (class_276)fb, text -> {
                    if (c.field_1705 != null && c.field_1705.method_1743() != null) {
                        c.field_1705.method_1743().method_1812(text);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    });

    private final Action press;
    private final Action release;

    private AutoClickAction(Action press, Action release) {
        this.press = press;
        this.release = release;
    }

    private AutoClickAction(Action press) {
        this(press, c -> {});
    }

    public void press(class_310 c) {
        this.press.run(c);
    }

    public void release(class_310 c) {
        this.release.run(c);
    }

    private static void pressKey(class_310 c, String key) {
        if (c == null) {
            return;
        }
        class_304 kb = class_304.method_65807((String)key);
        if (kb != null) {
            kb.method_23481(true);
        }
    }

    private static void releaseKey(class_310 c, String key) {
        if (c == null) {
            return;
        }
        class_304 kb = class_304.method_65807((String)key);
        if (kb != null) {
            kb.method_23481(false);
        }
    }

    private static void selectHotbar(class_310 c, int hotbarIndex) {
        if (c.field_1724 == null || c.method_1562() == null) {
            return;
        }
        if (hotbarIndex < 0 || hotbarIndex > 8) {
            return;
        }
        c.field_1724.method_31548().method_61496(hotbarIndex);
        c.method_1562().method_52787((class_2596)new class_2868(hotbarIndex));
    }

    private static boolean hasSupport(class_638 world, class_2338 placePos) {
        if (world == null) {
            return false;
        }
        class_2338 below = placePos.method_10074();
        class_2680 belowState = world.method_8320(below);
        try {
            if (belowState.method_26206((class_1922)world, below, class_2350.field_11036)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (class_2350 dir : class_2350.values()) {
            if (dir == class_2350.field_11036) continue;
            class_2338 neighbor = placePos.method_10093(dir);
            class_2680 ns = world.method_8320(neighbor);
            try {
                if (!ns.method_26206((class_1922)world, neighbor, dir.method_10153())) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean requiresSupport(class_1792 item) {
        if (item instanceof class_1747) {
            return true;
        }
        return item instanceof class_1781;
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    static interface Action {
        public void run(class_310 var1);
    }
}

