/*
 * Decompiled with CFR 0.152.
 */
package ru.sansrus.simple_autoclicker1_21.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import ru.sansrus.simple_autoclicker1_21.client.AutoClickAction;

@Environment(value=EnvType.CLIENT)
public class AutoClickerConfig {
    private static final File FILE = FabricLoader.getInstance().getConfigDir().resolve("simpleautoclicker.json").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static AutoClickerConfig INSTANCE;
    public boolean globalEnabled = false;
    public List<Entry> entries = new ArrayList<Entry>();

    public static AutoClickerConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = AutoClickerConfig.load();
        }
        return INSTANCE;
    }

    public void save() {
        try (FileWriter w = new FileWriter(FILE);){
            GSON.toJson((Object)this, (Appendable)w);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static AutoClickerConfig load() {
        AutoClickerConfig autoClickerConfig;
        if (!FILE.exists()) {
            return new AutoClickerConfig();
        }
        FileReader r = new FileReader(FILE);
        try {
            autoClickerConfig = (AutoClickerConfig)GSON.fromJson((Reader)r, AutoClickerConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return new AutoClickerConfig();
            }
        }
        ((Reader)r).close();
        return autoClickerConfig;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Entry {
        public String name = "New";
        public AutoClickAction action = AutoClickAction.FORWARD;
        public int intervalTicks = 20;
        public boolean enabled = true;
        public int useDurationTicks = 1;
        public boolean spamMode = false;
        public boolean cooldownMode = false;
        public boolean onlyEntityMode = false;
        public transient int tickCounter = 0;
        public transient boolean pressed = false;
    }
}

