/*
 * Decompiled with CFR 0.152.
 */
package ru.sansrus.simple_autoclicker1_21.client;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2879;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.sansrus.simple_autoclicker1_21.client.AutoClickAction;
import ru.sansrus.simple_autoclicker1_21.client.AutoClickerConfig;

@Environment(value=EnvType.CLIENT)
public class AutoClickerManager {
    private final class_310 client = class_310.method_1551();
    private final AutoClickerConfig cfg = AutoClickerConfig.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AutoClickManager");
    private boolean isBreakingBlock = false;
    private class_3965 lastBlockHit = null;
    private boolean lastGlobalEnabled;

    public AutoClickerManager() {
        this.lastGlobalEnabled = this.cfg.globalEnabled;
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
    }

    private void onTick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            this.fullReset();
            this.lastGlobalEnabled = this.cfg.globalEnabled;
            return;
        }
        if (!this.cfg.globalEnabled) {
            if (this.lastGlobalEnabled) {
                this.simpleReset();
                this.lastGlobalEnabled = false;
            }
            return;
        }
        this.lastGlobalEnabled = true;
        for (AutoClickerConfig.Entry e : this.cfg.entries) {
            if (!e.enabled) continue;
            if (e.action != AutoClickAction.ATTACK) {
                this.handleNonAttack(e, client);
                continue;
            }
            boolean cooldown = e.cooldownMode;
            boolean onlyEntity = e.onlyEntityMode;
            boolean spam = e.spamMode || e.intervalTicks == 0;
            TargetInfo targetInfo = CustomAttack.findTarget(client);
            boolean hasEntity = targetInfo.hasEntity();
            boolean hasBlock = targetInfo.hasBlock();
            if (cooldown) {
                if (onlyEntity && !hasEntity || !(client.field_1724.method_7261(0.0f) >= 1.0f)) continue;
                this.performAttack(targetInfo);
                AutoClickerManager.playHandSwing(client, class_1268.field_5808, true);
                continue;
            }
            if (onlyEntity) {
                if (!hasEntity) {
                    if (e.pressed) {
                        e.pressed = false;
                    }
                    e.tickCounter = 0;
                    if (!this.isBreakingBlock) continue;
                    if (client.field_1761 == null) {
                        return;
                    }
                    client.field_1761.method_2925();
                    this.isBreakingBlock = false;
                    this.lastBlockHit = null;
                    continue;
                }
                if (spam) {
                    e.pressed = this.performAttack(targetInfo);
                    if (!hasBlock || !this.isBreakingBlock) continue;
                    this.continueBreaking();
                    continue;
                }
                ++e.tickCounter;
                if (!e.pressed && e.tickCounter >= e.intervalTicks) {
                    this.performAttack(targetInfo);
                    e.pressed = true;
                    e.tickCounter = 0;
                    continue;
                }
                if (!e.pressed || e.tickCounter < e.useDurationTicks) continue;
                e.pressed = false;
                e.tickCounter = 0;
                continue;
            }
            if (spam) {
                this.performAttack(targetInfo);
                AutoClickerManager.playHandSwing(client, class_1268.field_5808, true);
                if (this.performAttack(targetInfo)) {
                    e.pressed = true;
                }
                if (!targetInfo.hasBlock()) continue;
                this.continueBreaking();
                continue;
            }
            ++e.tickCounter;
            if (!e.pressed && e.tickCounter >= e.intervalTicks) {
                this.performAttack(targetInfo);
                AutoClickerManager.playHandSwing(client, class_1268.field_5808, true);
                e.pressed = true;
                e.tickCounter = 0;
                continue;
            }
            if (e.pressed && e.tickCounter >= e.useDurationTicks) {
                if (this.isBreakingBlock) {
                    if (client.field_1761 == null) {
                        return;
                    }
                    client.field_1761.method_2925();
                    this.isBreakingBlock = false;
                    this.lastBlockHit = null;
                }
                e.pressed = false;
                e.tickCounter = 0;
                continue;
            }
            if (!e.pressed || !hasBlock) continue;
            this.continueBreaking();
        }
    }

    private void fullReset() {
        for (AutoClickerConfig.Entry e : this.cfg.entries) {
            e.pressed = false;
            e.tickCounter = 0;
        }
        this.stopBlockIfNeeded();
        this.client.field_1690.field_1886.method_23481(false);
    }

    private void simpleReset() {
        if (this.client.field_1724 == null) {
            return;
        }
        for (AutoClickerConfig.Entry e : this.cfg.entries) {
            e.pressed = false;
            e.tickCounter = 0;
        }
        this.stopBlockIfNeeded();
        this.client.field_1724.method_6075();
    }

    private void stopBlockIfNeeded() {
        if (this.isBreakingBlock && this.client.field_1761 != null) {
            this.client.field_1761.method_2925();
        }
        this.isBreakingBlock = false;
        this.lastBlockHit = null;
    }

    private boolean performAttack(TargetInfo targetInfo) {
        if (this.client.field_1687 == null || this.client.field_1724 == null || this.client.field_1761 == null) {
            return false;
        }
        if (targetInfo.hasEntity()) {
            if (this.client.field_1724.method_7261(0.0f) < 1.0f) {
                return false;
            }
            this.client.field_1761.method_2918((class_1657)this.client.field_1724, targetInfo.entityHitResult.method_17782());
            AutoClickerManager.playHandSwing(this.client, class_1268.field_5808, true);
            if (this.isBreakingBlock) {
                this.client.field_1761.method_2925();
                this.isBreakingBlock = false;
                this.lastBlockHit = null;
            }
            return true;
        }
        if (targetInfo.hasBlock()) {
            class_3965 bhr = targetInfo.blockHitResult;
            if (!this.isBreakingBlock || this.lastBlockHit == null || !this.lastBlockHit.method_17777().equals((Object)bhr.method_17777())) {
                this.client.field_1761.method_2910(bhr.method_17777(), bhr.method_17780());
                this.isBreakingBlock = true;
                this.lastBlockHit = bhr;
            } else {
                this.client.field_1761.method_2902(bhr.method_17777(), bhr.method_17780());
            }
            AutoClickerManager.playHandSwing(this.client, class_1268.field_5808, true);
            return true;
        }
        return false;
    }

    private void handleNonAttack(AutoClickerConfig.Entry e, class_310 client) {
        boolean spam;
        boolean bl = spam = e.spamMode || e.intervalTicks == 0;
        if (spam) {
            this.press(e);
            if (this.isHoldAction(e.action)) {
                e.pressed = true;
            } else {
                this.release(e);
                e.pressed = false;
            }
            return;
        }
        ++e.tickCounter;
        if (!e.pressed && e.tickCounter >= e.intervalTicks) {
            this.press(e);
            if (this.isHoldAction(e.action)) {
                e.pressed = true;
            } else {
                this.release(e);
                e.pressed = false;
            }
            e.tickCounter = 0;
        } else if (e.pressed && e.tickCounter >= e.useDurationTicks) {
            this.release(e);
            e.pressed = false;
            e.tickCounter = 0;
        }
    }

    private boolean isHoldAction(AutoClickAction action) {
        return switch (action) {
            case AutoClickAction.FORWARD, AutoClickAction.BACKWARD, AutoClickAction.LEFT, AutoClickAction.RIGHT, AutoClickAction.JUMP, AutoClickAction.SNEAK, AutoClickAction.USE_ITEM, AutoClickAction.SPRINT, AutoClickAction.ATTACK -> true;
            default -> false;
        };
    }

    private void press(AutoClickerConfig.Entry e) {
        if (e.action == AutoClickAction.ATTACK) {
            return;
        }
        e.action.press(this.client);
    }

    private void release(AutoClickerConfig.Entry e) {
        if (e.action == AutoClickAction.ATTACK) {
            return;
        }
        e.action.release(this.client);
    }

    private void continueBreaking() {
        if (this.client.field_1687 == null || this.client.field_1724 == null || this.client.field_1761 == null || !this.isBreakingBlock || this.lastBlockHit == null) {
            return;
        }
        this.client.field_1761.method_2902(this.lastBlockHit.method_17777(), this.lastBlockHit.method_17780());
        AutoClickerManager.playHandSwing(this.client, class_1268.field_5808, true);
    }

    public static void playHandSwing(class_310 client, class_1268 hand, boolean notifyServer) {
        if (client == null || client.field_1724 == null) {
            return;
        }
        client.field_1724.method_6104(hand);
        if (notifyServer && client.method_1562() != null) {
            client.method_1562().method_52787((class_2596)new class_2879(hand));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class CustomAttack {
        private CustomAttack() {
        }

        public static TargetInfo findTarget(class_310 client) {
            class_3965 bhr;
            if (client.field_1724 == null || client.field_1687 == null) {
                return new TargetInfo(null, null);
            }
            double reach = client.field_1724.method_45325(class_5134.field_47758);
            class_243 eyePos = client.field_1724.method_5836(0.0f);
            class_239 rawHit = client.field_1724.method_5745(reach, 0.0f, false);
            class_3965 blockHit = rawHit instanceof class_3965 ? (bhr = (class_3965)rawHit) : null;
            double blockDistSq = blockHit != null ? eyePos.method_1025(blockHit.method_17784()) : Double.MAX_VALUE;
            class_243 look = client.field_1724.method_5828(0.0f);
            class_243 end = eyePos.method_1019(look.method_1021(reach));
            class_238 searchBox = client.field_1724.method_5829().method_18804(look.method_1021(reach)).method_1009(1.0, 1.0, 1.0);
            double closestEntityDistSq = Double.MAX_VALUE;
            class_3966 closestEntityHit = null;
            for (class_1309 ent : client.field_1687.method_8390(class_1309.class, searchBox, e -> e != client.field_1724 && !e.method_7325())) {
                class_243 hitPos;
                double distSq;
                class_238 entBox = ent.method_5829().method_1014(0.3);
                Optional optHit = entBox.method_992(eyePos, end);
                if (!optHit.isPresent() || (distSq = eyePos.method_1025(hitPos = (class_243)optHit.get())) >= blockDistSq || !(distSq < closestEntityDistSq)) continue;
                closestEntityDistSq = distSq;
                closestEntityHit = new class_3966((class_1297)ent, hitPos);
            }
            return new TargetInfo(closestEntityHit, blockHit);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TargetInfo {
        public final class_3966 entityHitResult;
        public final class_3965 blockHitResult;

        public TargetInfo(class_3966 entityHitResult, class_3965 blockHitResult) {
            this.entityHitResult = entityHitResult;
            this.blockHitResult = blockHitResult;
        }

        public boolean hasEntity() {
            return this.entityHitResult != null;
        }

        public boolean hasBlock() {
            return this.blockHitResult != null;
        }
    }
}

