/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.action_hunger;

import com.minenash.action_hunger.FoodLevelForSprintPacket;
import com.minenash.action_hunger.config.Config;
import com.minenash.action_hunger.config.HealthEffect;
import com.minenash.action_hunger.mixin.LivingEntityAccessor;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class ActionHunger
implements ModInitializer {
    public static boolean ignoreWake = false;

    public void onInitialize() {
        PayloadTypeRegistry.playS2C().register(FoodLevelForSprintPacket.PACKET_ID, FoodLevelForSprintPacket.PACKET_CODEC);
        Config.init("action_hunger", "ActionHunger", Config.class);
        this.mapHealthEffects();
        CommandRegistrationCallback.EVENT.register((dispatcher, access, env) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"action_hunger_reload").executes(context -> {
            Config.init("action_hunger", "ActionHunger", Config.class);
            this.mapHealthEffects();
            ((class_2168)context.getSource()).method_9211().method_3760().method_14581(ServerPlayNetworking.createS2CPacket((class_8710)new FoodLevelForSprintPacket(Config.foodLevelForSprint)));
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"\u00a72[ActionHunger]:\u00a7a Config reload complete"));
            return 1;
        })));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (HealthEffect effect : Config.effects) {
                class_1291 statusEffect = effect.statusEffect;
                if (statusEffect == null || effect.onSleep) continue;
                for (class_3222 player : server.method_3760().method_14571()) {
                    boolean inHunger;
                    float health = player.method_6032();
                    float hunger = player.method_7344().method_7586();
                    boolean inHealth = health >= (float)effect.healthLowBound && health <= (float)effect.healthHighBound;
                    boolean bl = inHunger = hunger >= (float)effect.hungerLowBound && hunger <= (float)effect.hungerHighBound;
                    if (!(effect.requiredBounds == Config.RequiredBounds.BOTH ? inHealth && inHunger : inHealth || inHunger)) continue;
                    float stepper = effect.amplifierCurveSource == Config.AmplifierCurveSource.HUNGER ? hunger : health;
                    double amplifierModifier = ActionHunger.getCurveModifier(stepper, effect.amplifierCurve, effect.amplifierCurveMultiplier);
                    player.method_6092(new class_1293(class_6880.method_40223((Object)statusEffect), 1, (int)Math.round(amplifierModifier * (double)effect.amplifier)));
                }
            }
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> ((LivingEntityAccessor)player).setActiveItemStack(class_1799.field_8037));
    }

    private void mapHealthEffects() {
        for (HealthEffect effect : Config.effects) {
            effect.statusEffect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_60654((String)effect.effect));
        }
    }

    public static double getCurveModifier(float stepper, Config.Curve curve, float multiplier) {
        double step = (20.0f - stepper) * multiplier + 1.0f;
        return switch (curve) {
            default -> throw new MatchException(null, null);
            case Config.Curve.DISABLED -> 1.0;
            case Config.Curve.LINEAR -> step;
            case Config.Curve.QUADRATIC -> Math.pow(step, 2.0);
            case Config.Curve.EXPONENTIAL -> Math.pow(Math.E, step);
        };
    }
}

