/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.action_hunger.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TinyConfig {
    public static void init(String modid, String modname, Class<?> config) {
        Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).setPrettyPrinting().create();
        Path path = FabricLoader.getInstance().getConfigDir().resolve(modid + ".json");
        Logger logger = LogManager.getLogger((String)modid);
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), config);
        }
        catch (Exception e) {
            logger.error("[" + modname + ": Couldn't load config; reverting to defaults");
            try {
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.createFile(path, new FileAttribute[0]);
                }
                Files.write(path, gson.toJson(config.newInstance()).getBytes(), new OpenOption[0]);
            }
            catch (Exception e2) {
                logger.error(modname + ": Couldn't save config.");
                e.printStackTrace();
            }
        }
    }
}

